// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class BulkDeleteRoleRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Bulk delete roles.
/// </para>
/// <para>
/// The role management APIs are generally the preferred way to manage roles, rather than using file-based role management.
/// The bulk delete roles API cannot delete roles that are defined in roles files.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.BulkDeleteRoleRequestConverter))]
public sealed partial class BulkDeleteRoleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BulkDeleteRoleRequest(System.Collections.Generic.ICollection<string> names)
	{
		Names = names;
	}
#if NET7_0_OR_GREATER
	public BulkDeleteRoleRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public BulkDeleteRoleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BulkDeleteRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityBulkDeleteRole;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.bulk_delete_role";

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// An array of role names to delete
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Names { get; set; }
}

/// <summary>
/// <para>
/// Bulk delete roles.
/// </para>
/// <para>
/// The role management APIs are generally the preferred way to manage roles, rather than using file-based role management.
/// The bulk delete roles API cannot delete roles that are defined in roles files.
/// </para>
/// </summary>
public readonly partial struct BulkDeleteRoleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BulkDeleteRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest instance)
	{
		Instance = instance;
	}

	public BulkDeleteRoleRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest instance) => new Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest(Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role names to delete
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor Names(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Names = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role names to delete
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor Names(params string[] values)
	{
		Instance.Names = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkDeleteRoleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}