// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class ActivateUserProfileRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Activate a user profile.
/// </para>
/// <para>
/// Create or update a user profile on behalf of another user.
/// </para>
/// <para>
/// NOTE: The user profile feature is designed only for use by Kibana and Elastic's Observability, Enterprise Search, and Elastic Security solutions.
/// Individual users and external applications should not call this API directly.
/// The calling application must have either an <c>access_token</c> or a combination of <c>username</c> and <c>password</c> for the user that the profile document is intended for.
/// Elastic reserves the right to change or remove this feature in future releases without prior notice.
/// </para>
/// <para>
/// This API creates or updates a profile document for end users with information that is extracted from the user's authentication object including <c>username</c>, <c>full_name,</c> <c>roles</c>, and the authentication realm.
/// For example, in the JWT <c>access_token</c> case, the profile user's <c>username</c> is extracted from the JWT token claim pointed to by the <c>claims.principal</c> setting of the JWT realm that authenticated the token.
/// </para>
/// <para>
/// When updating a profile document, the API enables the document if it was disabled.
/// Any updates do not change existing content for either the <c>labels</c> or <c>data</c> fields.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ActivateUserProfileRequestConverter))]
public sealed partial class ActivateUserProfileRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ActivateUserProfileRequest(Elastic.Clients.Elasticsearch.Security.GrantType grantType)
	{
		GrantType = grantType;
	}
#if NET7_0_OR_GREATER
	public ActivateUserProfileRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ActivateUserProfileRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ActivateUserProfileRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityActivateUserProfile;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.activate_user_profile";

	/// <summary>
	/// <para>
	/// The user's Elasticsearch access token or JWT.
	/// Both <c>access</c> and <c>id</c> JWT token types are supported and they depend on the underlying JWT realm configuration.
	/// If you specify the <c>access_token</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public string? AccessToken { get; set; }

	/// <summary>
	/// <para>
	/// The type of grant.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Security.GrantType GrantType { get; set; }

	/// <summary>
	/// <para>
	/// The user's password.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public string? Password { get; set; }

	/// <summary>
	/// <para>
	/// The username that identifies the user.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public string? Username { get; set; }
}

/// <summary>
/// <para>
/// Activate a user profile.
/// </para>
/// <para>
/// Create or update a user profile on behalf of another user.
/// </para>
/// <para>
/// NOTE: The user profile feature is designed only for use by Kibana and Elastic's Observability, Enterprise Search, and Elastic Security solutions.
/// Individual users and external applications should not call this API directly.
/// The calling application must have either an <c>access_token</c> or a combination of <c>username</c> and <c>password</c> for the user that the profile document is intended for.
/// Elastic reserves the right to change or remove this feature in future releases without prior notice.
/// </para>
/// <para>
/// This API creates or updates a profile document for end users with information that is extracted from the user's authentication object including <c>username</c>, <c>full_name,</c> <c>roles</c>, and the authentication realm.
/// For example, in the JWT <c>access_token</c> case, the profile user's <c>username</c> is extracted from the JWT token claim pointed to by the <c>claims.principal</c> setting of the JWT realm that authenticated the token.
/// </para>
/// <para>
/// When updating a profile document, the API enables the document if it was disabled.
/// Any updates do not change existing content for either the <c>labels</c> or <c>data</c> fields.
/// </para>
/// </summary>
public readonly partial struct ActivateUserProfileRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ActivateUserProfileRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest instance)
	{
		Instance = instance;
	}

	public ActivateUserProfileRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest instance) => new Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest(Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The user's Elasticsearch access token or JWT.
	/// Both <c>access</c> and <c>id</c> JWT token types are supported and they depend on the underlying JWT realm configuration.
	/// If you specify the <c>access_token</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor AccessToken(string? value)
	{
		Instance.AccessToken = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of grant.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor GrantType(Elastic.Clients.Elasticsearch.Security.GrantType value)
	{
		Instance.GrantType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The user's password.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor Password(string? value)
	{
		Instance.Password = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The username that identifies the user.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor Username(string? value)
	{
		Instance.Username = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ActivateUserProfileRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}