// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SearchableSnapshots;

public sealed partial class MountRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The period to wait for the master node.
	/// If the master node is not available before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The mount option for the searchable snapshot index.
	/// </para>
	/// </summary>
	public string? Storage { get => Q<string?>("storage"); set => Q("storage", value); }

	/// <summary>
	/// <para>
	/// If true, the request blocks until the operation is complete.
	/// </para>
	/// </summary>
	public bool? WaitForCompletion { get => Q<bool?>("wait_for_completion"); set => Q("wait_for_completion", value); }
}

/// <summary>
/// <para>
/// Mount a snapshot.
/// Mount a snapshot as a searchable snapshot index.
/// Do not use this API for snapshots managed by index lifecycle management (ILM).
/// Manually mounting ILM-managed snapshots can interfere with ILM processes.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.SearchableSnapshots.Json.MountRequestConverter))]
public sealed partial class MountRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MountRequest(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot) : base(r => r.Required("repository", repository).Required("snapshot", snapshot))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MountRequest(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot, Elastic.Clients.Elasticsearch.IndexName index) : base(r => r.Required("repository", repository).Required("snapshot", snapshot))
	{
		Index = index;
	}
#if NET7_0_OR_GREATER
	public MountRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MountRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SearchableSnapshotsMount;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "searchable_snapshots.mount";

	/// <summary>
	/// <para>
	/// The name of the repository containing the snapshot of the index to mount.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Repository { get => P<Elastic.Clients.Elasticsearch.Name>("repository"); set => PR("repository", value); }

	/// <summary>
	/// <para>
	/// The name of the snapshot of the index to mount.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Snapshot { get => P<Elastic.Clients.Elasticsearch.Name>("snapshot"); set => PR("snapshot", value); }

	/// <summary>
	/// <para>
	/// The period to wait for the master node.
	/// If the master node is not available before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The mount option for the searchable snapshot index.
	/// </para>
	/// </summary>
	public string? Storage { get => Q<string?>("storage"); set => Q("storage", value); }

	/// <summary>
	/// <para>
	/// If true, the request blocks until the operation is complete.
	/// </para>
	/// </summary>
	public bool? WaitForCompletion { get => Q<bool?>("wait_for_completion"); set => Q("wait_for_completion", value); }

	/// <summary>
	/// <para>
	/// The names of settings that should be removed from the index when it is mounted.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? IgnoreIndexSettings { get; set; }

	/// <summary>
	/// <para>
	/// The name of the index contained in the snapshot whose data is to be mounted.
	/// If no <c>renamed_index</c> is specified, this name will also be used to create the new index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get; set; }

	/// <summary>
	/// <para>
	/// The settings that should be added to the index when it is mounted.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? IndexSettings { get; set; }

	/// <summary>
	/// <para>
	/// The name of the index that will be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? RenamedIndex { get; set; }
}

/// <summary>
/// <para>
/// Mount a snapshot.
/// Mount a snapshot as a searchable snapshot index.
/// Do not use this API for snapshots managed by index lifecycle management (ILM).
/// Manually mounting ILM-managed snapshots can interfere with ILM processes.
/// </para>
/// </summary>
public readonly partial struct MountRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MountRequestDescriptor(Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequest instance)
	{
		Instance = instance;
	}

	public MountRequestDescriptor(Elastic.Clients.Elasticsearch.Name repository, Elastic.Clients.Elasticsearch.Name snapshot)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequest(repository, snapshot);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public MountRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor(Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequest instance) => new Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequest(Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the repository containing the snapshot of the index to mount.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor Repository(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Repository = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the snapshot of the index to mount.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor Snapshot(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Snapshot = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for the master node.
	/// If the master node is not available before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The mount option for the searchable snapshot index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor Storage(string? value)
	{
		Instance.Storage = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the request blocks until the operation is complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor WaitForCompletion(bool? value = true)
	{
		Instance.WaitForCompletion = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The names of settings that should be removed from the index when it is mounted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor IgnoreIndexSettings(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.IgnoreIndexSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The names of settings that should be removed from the index when it is mounted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor IgnoreIndexSettings(params string[] values)
	{
		Instance.IgnoreIndexSettings = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the index contained in the snapshot whose data is to be mounted.
	/// If no <c>renamed_index</c> is specified, this name will also be used to create the new index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The settings that should be added to the index when it is mounted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor IndexSettings(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.IndexSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The settings that should be added to the index when it is mounted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor IndexSettings()
	{
		Instance.IndexSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The settings that should be added to the index when it is mounted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor IndexSettings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.IndexSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor AddIndexSetting(string key, object value)
	{
		Instance.IndexSettings ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.IndexSettings.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the index that will be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor RenamedIndex(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.RenamedIndex = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequest Build(System.Action<Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor(new Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchableSnapshots.MountRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}