// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

public sealed partial class SearchRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c> and there are shard request timeouts or shard failures, the request returns partial results.
	/// If <c>false</c>, it returns an error with no partial results.
	/// </para>
	/// <para>
	/// To override the default behavior, you can set the <c>search.default_allow_partial_results</c> cluster setting to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? AllowPartialSearchResults { get => Q<bool?>("allow_partial_search_results"); set => Q("allow_partial_search_results", value); }

	/// <summary>
	/// <para>
	/// The analyzer to use for the query string.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public string? Analyzer { get => Q<string?>("analyzer"); set => Q("analyzer", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, wildcard and prefix queries are analyzed.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public bool? AnalyzeWildcard { get => Q<bool?>("analyze_wildcard"); set => Q("analyze_wildcard", value); }

	/// <summary>
	/// <para>
	/// The number of shard results that should be reduced at once on the coordinating node.
	/// If the potential number of shards in the request can be large, this value should be used as a protection mechanism to reduce the memory overhead per search request.
	/// </para>
	/// </summary>
	public long? BatchedReduceSize { get => Q<long?>("batched_reduce_size"); set => Q("batched_reduce_size", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, network round-trips between the coordinating node and the remote clusters are minimized when running cross-cluster search (CCS) requests.
	/// </para>
	/// </summary>
	public bool? CcsMinimizeRoundtrips { get => Q<bool?>("ccs_minimize_roundtrips"); set => Q("ccs_minimize_roundtrips", value); }

	/// <summary>
	/// <para>
	/// The default operator for the query string query: <c>AND</c> or <c>OR</c>.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Operator? DefaultOperator { get => Q<Elastic.Clients.Elasticsearch.QueryDsl.Operator?>("default_operator"); set => Q("default_operator", value); }

	/// <summary>
	/// <para>
	/// The field to use as a default when no field prefix is given in the query string.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public string? Df { get => Q<string?>("df"); set => Q("df", value); }

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// It supports comma-separated values such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// Should this request force synthetic _source?
	/// Use this to test if the mapping supports synthetic _source and to get a sense of the worst case performance.
	/// Fetches with this enabled will be slower the enabling synthetic source natively in the index.
	/// </para>
	/// </summary>
	public bool? ForceSyntheticSource { get => Q<bool?>("force_synthetic_source"); set => Q("force_synthetic_source", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, concrete, expanded or aliased indices will be ignored when frozen.
	/// </para>
	/// </summary>
	[System.Obsolete("Deprecated in '7.16.0'.")]
	public bool? IgnoreThrottled { get => Q<bool?>("ignore_throttled"); set => Q("ignore_throttled", value); }

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if it targets a missing or closed index.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes the score contribution from any named queries.
	/// </para>
	/// <para>
	/// This functionality reruns each named query on every hit in a search response.
	/// Typically, this adds a small overhead to a request.
	/// However, using computationally expensive named queries on a large number of hits may add significant overhead.
	/// </para>
	/// </summary>
	public bool? IncludeNamedQueriesScore { get => Q<bool?>("include_named_queries_score"); set => Q("include_named_queries_score", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based query failures (such as providing text to a numeric field) in the query string will be ignored.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public bool? Lenient { get => Q<bool?>("lenient"); set => Q("lenient", value); }

	/// <summary>
	/// <para>
	/// The number of concurrent shard requests per node that the search runs concurrently.
	/// This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests.
	/// </para>
	/// </summary>
	public int? MaxConcurrentShardRequests { get => Q<int?>("max_concurrent_shard_requests"); set => Q("max_concurrent_shard_requests", value); }

	/// <summary>
	/// <para>
	/// The nodes and shards used for the search.
	/// By default, Elasticsearch selects from eligible nodes and shards using adaptive replica selection, accounting for allocation awareness.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>_only_local</c> to run the search only on shards on the local node.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_local</c> to, if possible, run the search on shards on the local node, or if not, select shards using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_only_nodes:&lt;node-id>,&lt;node-id></c> to run the search on only the specified nodes IDs. If suitable shards exist on more than one selected node, use shards on those nodes using the default method. If none of the specified nodes are available, select shards from any available node using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_prefer_nodes:&lt;node-id>,&lt;node-id></c> to if possible, run the search on the specified nodes IDs. If not, select shards using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_shards:&lt;shard>,&lt;shard></c> to run the search only on the specified shards. You can combine this value with other <c>preference</c> values. However, the <c>_shards</c> value must come first. For example: <c>_shards:2,3|_local</c>.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>&lt;custom-string></c> (any string that does not start with <c>_</c>) to route searches with the same <c>&lt;custom-string></c> to the same shards in the same order.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public string? Preference { get => Q<string?>("preference"); set => Q("preference", value); }

	/// <summary>
	/// <para>
	/// A threshold that enforces a pre-filter roundtrip to prefilter search shards based on query rewriting if the number of shards the search request expands to exceeds the threshold.
	/// This filter roundtrip can limit the number of shards significantly if for instance a shard can not match any documents based on its rewrite method (if date filters are mandatory to match but the shard bounds and the query are disjoint).
	/// When unspecified, the pre-filter phase is executed if any of these conditions is met:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// The request targets more than 128 shards.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// The request targets one or more read-only index.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// The primary sort of the query targets an indexed field.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public long? PreFilterShardSize { get => Q<long?>("pre_filter_shard_size"); set => Q("pre_filter_shard_size", value); }

	/// <summary>
	/// <para>
	/// A query in the Lucene query string syntax.
	/// Query parameter searches do not support the full Elasticsearch Query DSL but are handy for testing.
	/// </para>
	/// <para>
	/// IMPORTANT: This parameter overrides the query parameter in the request body.
	/// If both parameters are specified, documents matching the query request body parameter are not returned.
	/// </para>
	/// </summary>
	public string? QueryLuceneSyntax { get => Q<string?>("q"); set => Q("q", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the caching of search results is enabled for requests where <c>size</c> is <c>0</c>.
	/// It defaults to index level settings.
	/// </para>
	/// </summary>
	public bool? RequestCache { get => Q<bool?>("request_cache"); set => Q("request_cache", value); }

	/// <summary>
	/// <para>
	/// Indicates whether <c>hits.total</c> should be rendered as an integer or an object in the rest search response.
	/// </para>
	/// </summary>
	public bool? RestTotalHitsAsInt { get => Q<bool?>("rest_total_hits_as_int"); set => Q("rest_total_hits_as_int", value); }

	/// <summary>
	/// <para>
	/// A custom value that is used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get => Q<Elastic.Clients.Elasticsearch.Routing?>("routing"); set => Q("routing", value); }

	/// <summary>
	/// <para>
	/// The period to retain the search context for scrolling.
	/// By default, this value cannot exceed <c>1d</c> (24 hours).
	/// You can change this limit by using the <c>search.max_keep_alive</c> cluster-level setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Scroll { get => Q<Elastic.Clients.Elasticsearch.Duration?>("scroll"); set => Q("scroll", value); }

	/// <summary>
	/// <para>
	/// Indicates how distributed term frequencies are calculated for relevance scoring.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchType? SearchType { get => Q<Elastic.Clients.Elasticsearch.SearchType?>("search_type"); set => Q("search_type", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceExcludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_excludes"); set => Q("_source_excludes", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceIncludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_includes"); set => Q("_source_includes", value); }

	/// <summary>
	/// <para>
	/// The field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? SuggestField { get => Q<Elastic.Clients.Elasticsearch.Field?>("suggest_field"); set => Q("suggest_field", value); }

	/// <summary>
	/// <para>
	/// The suggest mode.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SuggestMode? SuggestMode { get => Q<Elastic.Clients.Elasticsearch.SuggestMode?>("suggest_mode"); set => Q("suggest_mode", value); }

	/// <summary>
	/// <para>
	/// The number of suggestions to return.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public long? SuggestSize { get => Q<long?>("suggest_size"); set => Q("suggest_size", value); }

	/// <summary>
	/// <para>
	/// The source text for which the suggestions should be returned.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public string? SuggestText { get => Q<string?>("suggest_text"); set => Q("suggest_text", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, aggregation and suggester names are be prefixed by their respective types in the response.
	/// </para>
	/// </summary>
	public bool? TypedKeys { get => Q<bool?>("typed_keys"); set => Q("typed_keys", value); }
}

/// <summary>
/// <para>
/// Run a search.
/// </para>
/// <para>
/// Get search hits that match the query defined in the request.
/// You can provide search queries using the <c>q</c> query string parameter or the request body.
/// If both are specified, only the query parameter is used.
/// </para>
/// <para>
/// If the Elasticsearch security features are enabled, you must have the read index privilege for the target data stream, index, or alias. For cross-cluster search, refer to the documentation about configuring CCS privileges.
/// To search a point in time (PIT) for an alias, you must have the <c>read</c> index privilege for the alias's data streams or indices.
/// </para>
/// <para>
/// <strong>Search slicing</strong>
/// </para>
/// <para>
/// When paging through a large number of documents, it can be helpful to split the search into multiple slices to consume them independently with the <c>slice</c> and <c>pit</c> properties.
/// By default the splitting is done first on the shards, then locally on each shard.
/// The local splitting partitions the shard into contiguous ranges based on Lucene document IDs.
/// </para>
/// <para>
/// For instance if the number of shards is equal to 2 and you request 4 slices, the slices 0 and 2 are assigned to the first shard and the slices 1 and 3 are assigned to the second shard.
/// </para>
/// <para>
/// IMPORTANT: The same point-in-time ID should be used for all slices.
/// If different PIT IDs are used, slices can overlap and miss documents.
/// This situation can occur because the splitting criterion is based on Lucene document IDs, which are not stable across changes to the index.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.SearchRequestConverter))]
public partial class SearchRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.SearchRequestParameters>
{
	public SearchRequest(Elastic.Clients.Elasticsearch.Indices? indices) : base(r => r.Optional("index", indices))
	{
	}
#if NET7_0_OR_GREATER
	public SearchRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SearchRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.NoNamespaceSearch;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "search";

	/// <summary>
	/// <para>
	/// A comma-separated list of data streams, indices, and aliases to search.
	/// It supports wildcards (<c>*</c>).
	/// To search all data streams and indices, omit this parameter or use <c>*</c> or <c>_all</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? Indices { get => P<Elastic.Clients.Elasticsearch.Indices?>("index"); set => PO("index", value); }

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c> and there are shard request timeouts or shard failures, the request returns partial results.
	/// If <c>false</c>, it returns an error with no partial results.
	/// </para>
	/// <para>
	/// To override the default behavior, you can set the <c>search.default_allow_partial_results</c> cluster setting to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? AllowPartialSearchResults { get => Q<bool?>("allow_partial_search_results"); set => Q("allow_partial_search_results", value); }

	/// <summary>
	/// <para>
	/// The analyzer to use for the query string.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public string? Analyzer { get => Q<string?>("analyzer"); set => Q("analyzer", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, wildcard and prefix queries are analyzed.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public bool? AnalyzeWildcard { get => Q<bool?>("analyze_wildcard"); set => Q("analyze_wildcard", value); }

	/// <summary>
	/// <para>
	/// The number of shard results that should be reduced at once on the coordinating node.
	/// If the potential number of shards in the request can be large, this value should be used as a protection mechanism to reduce the memory overhead per search request.
	/// </para>
	/// </summary>
	public long? BatchedReduceSize { get => Q<long?>("batched_reduce_size"); set => Q("batched_reduce_size", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, network round-trips between the coordinating node and the remote clusters are minimized when running cross-cluster search (CCS) requests.
	/// </para>
	/// </summary>
	public bool? CcsMinimizeRoundtrips { get => Q<bool?>("ccs_minimize_roundtrips"); set => Q("ccs_minimize_roundtrips", value); }

	/// <summary>
	/// <para>
	/// The default operator for the query string query: <c>AND</c> or <c>OR</c>.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Operator? DefaultOperator { get => Q<Elastic.Clients.Elasticsearch.QueryDsl.Operator?>("default_operator"); set => Q("default_operator", value); }

	/// <summary>
	/// <para>
	/// The field to use as a default when no field prefix is given in the query string.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public string? Df { get => Q<string?>("df"); set => Q("df", value); }

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// It supports comma-separated values such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// Should this request force synthetic _source?
	/// Use this to test if the mapping supports synthetic _source and to get a sense of the worst case performance.
	/// Fetches with this enabled will be slower the enabling synthetic source natively in the index.
	/// </para>
	/// </summary>
	public bool? ForceSyntheticSource { get => Q<bool?>("force_synthetic_source"); set => Q("force_synthetic_source", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, concrete, expanded or aliased indices will be ignored when frozen.
	/// </para>
	/// </summary>
	[System.Obsolete("Deprecated in '7.16.0'.")]
	public bool? IgnoreThrottled { get => Q<bool?>("ignore_throttled"); set => Q("ignore_throttled", value); }

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if it targets a missing or closed index.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes the score contribution from any named queries.
	/// </para>
	/// <para>
	/// This functionality reruns each named query on every hit in a search response.
	/// Typically, this adds a small overhead to a request.
	/// However, using computationally expensive named queries on a large number of hits may add significant overhead.
	/// </para>
	/// </summary>
	public bool? IncludeNamedQueriesScore { get => Q<bool?>("include_named_queries_score"); set => Q("include_named_queries_score", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based query failures (such as providing text to a numeric field) in the query string will be ignored.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public bool? Lenient { get => Q<bool?>("lenient"); set => Q("lenient", value); }

	/// <summary>
	/// <para>
	/// The number of concurrent shard requests per node that the search runs concurrently.
	/// This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests.
	/// </para>
	/// </summary>
	public int? MaxConcurrentShardRequests { get => Q<int?>("max_concurrent_shard_requests"); set => Q("max_concurrent_shard_requests", value); }

	/// <summary>
	/// <para>
	/// The nodes and shards used for the search.
	/// By default, Elasticsearch selects from eligible nodes and shards using adaptive replica selection, accounting for allocation awareness.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>_only_local</c> to run the search only on shards on the local node.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_local</c> to, if possible, run the search on shards on the local node, or if not, select shards using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_only_nodes:&lt;node-id>,&lt;node-id></c> to run the search on only the specified nodes IDs. If suitable shards exist on more than one selected node, use shards on those nodes using the default method. If none of the specified nodes are available, select shards from any available node using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_prefer_nodes:&lt;node-id>,&lt;node-id></c> to if possible, run the search on the specified nodes IDs. If not, select shards using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_shards:&lt;shard>,&lt;shard></c> to run the search only on the specified shards. You can combine this value with other <c>preference</c> values. However, the <c>_shards</c> value must come first. For example: <c>_shards:2,3|_local</c>.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>&lt;custom-string></c> (any string that does not start with <c>_</c>) to route searches with the same <c>&lt;custom-string></c> to the same shards in the same order.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public string? Preference { get => Q<string?>("preference"); set => Q("preference", value); }

	/// <summary>
	/// <para>
	/// A threshold that enforces a pre-filter roundtrip to prefilter search shards based on query rewriting if the number of shards the search request expands to exceeds the threshold.
	/// This filter roundtrip can limit the number of shards significantly if for instance a shard can not match any documents based on its rewrite method (if date filters are mandatory to match but the shard bounds and the query are disjoint).
	/// When unspecified, the pre-filter phase is executed if any of these conditions is met:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// The request targets more than 128 shards.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// The request targets one or more read-only index.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// The primary sort of the query targets an indexed field.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public long? PreFilterShardSize { get => Q<long?>("pre_filter_shard_size"); set => Q("pre_filter_shard_size", value); }

	/// <summary>
	/// <para>
	/// A query in the Lucene query string syntax.
	/// Query parameter searches do not support the full Elasticsearch Query DSL but are handy for testing.
	/// </para>
	/// <para>
	/// IMPORTANT: This parameter overrides the query parameter in the request body.
	/// If both parameters are specified, documents matching the query request body parameter are not returned.
	/// </para>
	/// </summary>
	public string? QueryLuceneSyntax { get => Q<string?>("q"); set => Q("q", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the caching of search results is enabled for requests where <c>size</c> is <c>0</c>.
	/// It defaults to index level settings.
	/// </para>
	/// </summary>
	public bool? RequestCache { get => Q<bool?>("request_cache"); set => Q("request_cache", value); }

	/// <summary>
	/// <para>
	/// Indicates whether <c>hits.total</c> should be rendered as an integer or an object in the rest search response.
	/// </para>
	/// </summary>
	public bool? RestTotalHitsAsInt { get => Q<bool?>("rest_total_hits_as_int"); set => Q("rest_total_hits_as_int", value); }

	/// <summary>
	/// <para>
	/// A custom value that is used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get => Q<Elastic.Clients.Elasticsearch.Routing?>("routing"); set => Q("routing", value); }

	/// <summary>
	/// <para>
	/// The period to retain the search context for scrolling.
	/// By default, this value cannot exceed <c>1d</c> (24 hours).
	/// You can change this limit by using the <c>search.max_keep_alive</c> cluster-level setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Scroll { get => Q<Elastic.Clients.Elasticsearch.Duration?>("scroll"); set => Q("scroll", value); }

	/// <summary>
	/// <para>
	/// Indicates how distributed term frequencies are calculated for relevance scoring.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchType? SearchType { get => Q<Elastic.Clients.Elasticsearch.SearchType?>("search_type"); set => Q("search_type", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceExcludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_excludes"); set => Q("_source_excludes", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceIncludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_includes"); set => Q("_source_includes", value); }

	/// <summary>
	/// <para>
	/// The field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? SuggestField { get => Q<Elastic.Clients.Elasticsearch.Field?>("suggest_field"); set => Q("suggest_field", value); }

	/// <summary>
	/// <para>
	/// The suggest mode.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SuggestMode? SuggestMode { get => Q<Elastic.Clients.Elasticsearch.SuggestMode?>("suggest_mode"); set => Q("suggest_mode", value); }

	/// <summary>
	/// <para>
	/// The number of suggestions to return.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public long? SuggestSize { get => Q<long?>("suggest_size"); set => Q("suggest_size", value); }

	/// <summary>
	/// <para>
	/// The source text for which the suggestions should be returned.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public string? SuggestText { get => Q<string?>("suggest_text"); set => Q("suggest_text", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, aggregation and suggester names are be prefixed by their respective types in the response.
	/// </para>
	/// </summary>
	public bool? TypedKeys { get => Q<bool?>("typed_keys"); set => Q("typed_keys", value); }

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? Aggregations { get; set; }

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? Collapse { get; set; }

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? DocvalueFields { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns detailed information about score computation as part of a hit.
	/// </para>
	/// </summary>
	public bool? Explain { get; set; }

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Ext { get; set; }

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? Fields { get; set; }

	/// <summary>
	/// <para>
	/// The starting document offset, which must be non-negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public int? From { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.Highlight? Highlight { get; set; }

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>? IndicesBoost { get; set; }

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.KnnSearch>? Knn { get; set; }

	/// <summary>
	/// <para>
	/// The minimum <c>_score</c> for matching documents.
	/// Documents with a lower <c>_score</c> are not included in search results and results collected by aggregations.
	/// </para>
	/// </summary>
	public double? MinScore { get; set; }

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReference? Pit { get; set; }

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? PostFilter { get; set; }

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to return detailed timing information about the execution of individual components in a search request.
	/// NOTE: This is a debugging tool and adds significant overhead to search execution.
	/// </para>
	/// </summary>
	public bool? Profile { get; set; }

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rank? Rank { get; set; }

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.Rescore>? Rescore { get; set; }

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Retriever? Retriever { get; set; }

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? RuntimeMappings { get; set; }

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? ScriptFields { get; set; }

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? SearchAfter { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns sequence number and primary term of the last modification of each hit.
	/// </para>
	/// </summary>
	public bool? SeqNoPrimaryTerm { get; set; }

	/// <summary>
	/// <para>
	/// The number of hits to return, which must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> property.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SlicedScroll? Slice { get; set; }

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? Sort { get; set; }

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? Source { get; set; }

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Stats { get; set; }

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? StoredFields { get; set; }

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.Suggester? Suggest { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of documents to collect for each shard.
	/// If a query reaches this limit, Elasticsearch terminates the query early.
	/// Elasticsearch collects documents before sorting.
	/// </para>
	/// <para>
	/// IMPORTANT: Use with caution.
	/// Elasticsearch applies this property to each shard handling the request.
	/// When possible, let Elasticsearch perform early termination automatically.
	/// Avoid specifying this property for requests that target data streams with backing indices across multiple data tiers.
	/// </para>
	/// <para>
	/// If set to <c>0</c> (default), the query does not terminate early.
	/// </para>
	/// </summary>
	public long? TerminateAfter { get; set; }

	/// <summary>
	/// <para>
	/// The period of time to wait for a response from each shard.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// Defaults to no timeout.
	/// </para>
	/// </summary>
	public string? Timeout { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, calculate and return document scores, even if the scores are not used for sorting.
	/// </para>
	/// </summary>
	public bool? TrackScores { get; set; }

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.TrackHits? TrackTotalHits { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns the document version as part of a hit.
	/// </para>
	/// </summary>
	public bool? Version { get; set; }
}

/// <summary>
/// <para>
/// Run a search.
/// </para>
/// <para>
/// Get search hits that match the query defined in the request.
/// You can provide search queries using the <c>q</c> query string parameter or the request body.
/// If both are specified, only the query parameter is used.
/// </para>
/// <para>
/// If the Elasticsearch security features are enabled, you must have the read index privilege for the target data stream, index, or alias. For cross-cluster search, refer to the documentation about configuring CCS privileges.
/// To search a point in time (PIT) for an alias, you must have the <c>read</c> index privilege for the alias's data streams or indices.
/// </para>
/// <para>
/// <strong>Search slicing</strong>
/// </para>
/// <para>
/// When paging through a large number of documents, it can be helpful to split the search into multiple slices to consume them independently with the <c>slice</c> and <c>pit</c> properties.
/// By default the splitting is done first on the shards, then locally on each shard.
/// The local splitting partitions the shard into contiguous ranges based on Lucene document IDs.
/// </para>
/// <para>
/// For instance if the number of shards is equal to 2 and you request 4 slices, the slices 0 and 2 are assigned to the first shard and the slices 1 and 3 are assigned to the second shard.
/// </para>
/// <para>
/// IMPORTANT: The same point-in-time ID should be used for all slices.
/// If different PIT IDs are used, slices can overlap and miss documents.
/// This situation can occur because the splitting criterion is based on Lucene document IDs, which are not stable across changes to the index.
/// </para>
/// </summary>
public readonly partial struct SearchRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.SearchRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SearchRequestDescriptor(Elastic.Clients.Elasticsearch.SearchRequest instance)
	{
		Instance = instance;
	}

	public SearchRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.SearchRequest(indices);
	}

	public SearchRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.SearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SearchRequestDescriptor(Elastic.Clients.Elasticsearch.SearchRequest instance) => new Elastic.Clients.Elasticsearch.SearchRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SearchRequest(Elastic.Clients.Elasticsearch.SearchRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of data streams, indices, and aliases to search.
	/// It supports wildcards (<c>*</c>).
	/// To search all data streams and indices, omit this parameter or use <c>*</c> or <c>_all</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and there are shard request timeouts or shard failures, the request returns partial results.
	/// If <c>false</c>, it returns an error with no partial results.
	/// </para>
	/// <para>
	/// To override the default behavior, you can set the <c>search.default_allow_partial_results</c> cluster setting to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AllowPartialSearchResults(bool? value = true)
	{
		Instance.AllowPartialSearchResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analyzer to use for the query string.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, wildcard and prefix queries are analyzed.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AnalyzeWildcard(bool? value = true)
	{
		Instance.AnalyzeWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of shard results that should be reduced at once on the coordinating node.
	/// If the potential number of shards in the request can be large, this value should be used as a protection mechanism to reduce the memory overhead per search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor BatchedReduceSize(long? value)
	{
		Instance.BatchedReduceSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, network round-trips between the coordinating node and the remote clusters are minimized when running cross-cluster search (CCS) requests.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor CcsMinimizeRoundtrips(bool? value = true)
	{
		Instance.CcsMinimizeRoundtrips = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The default operator for the query string query: <c>AND</c> or <c>OR</c>.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor DefaultOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.DefaultOperator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to use as a default when no field prefix is given in the query string.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Df(string? value)
	{
		Instance.Df = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// It supports comma-separated values such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// It supports comma-separated values such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Should this request force synthetic _source?
	/// Use this to test if the mapping supports synthetic _source and to get a sense of the worst case performance.
	/// Fetches with this enabled will be slower the enabling synthetic source natively in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor ForceSyntheticSource(bool? value = true)
	{
		Instance.ForceSyntheticSource = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.16.0'.")]
	/// <summary>
	/// <para>
	/// If <c>true</c>, concrete, expanded or aliased indices will be ignored when frozen.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor IgnoreThrottled(bool? value = true)
	{
		Instance.IgnoreThrottled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if it targets a missing or closed index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes the score contribution from any named queries.
	/// </para>
	/// <para>
	/// This functionality reruns each named query on every hit in a search response.
	/// Typically, this adds a small overhead to a request.
	/// However, using computationally expensive named queries on a large number of hits may add significant overhead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor IncludeNamedQueriesScore(bool? value = true)
	{
		Instance.IncludeNamedQueriesScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based query failures (such as providing text to a numeric field) in the query string will be ignored.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Lenient(bool? value = true)
	{
		Instance.Lenient = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of concurrent shard requests per node that the search runs concurrently.
	/// This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor MaxConcurrentShardRequests(int? value)
	{
		Instance.MaxConcurrentShardRequests = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The nodes and shards used for the search.
	/// By default, Elasticsearch selects from eligible nodes and shards using adaptive replica selection, accounting for allocation awareness.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>_only_local</c> to run the search only on shards on the local node.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_local</c> to, if possible, run the search on shards on the local node, or if not, select shards using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_only_nodes:&lt;node-id>,&lt;node-id></c> to run the search on only the specified nodes IDs. If suitable shards exist on more than one selected node, use shards on those nodes using the default method. If none of the specified nodes are available, select shards from any available node using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_prefer_nodes:&lt;node-id>,&lt;node-id></c> to if possible, run the search on the specified nodes IDs. If not, select shards using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_shards:&lt;shard>,&lt;shard></c> to run the search only on the specified shards. You can combine this value with other <c>preference</c> values. However, the <c>_shards</c> value must come first. For example: <c>_shards:2,3|_local</c>.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>&lt;custom-string></c> (any string that does not start with <c>_</c>) to route searches with the same <c>&lt;custom-string></c> to the same shards in the same order.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Preference(string? value)
	{
		Instance.Preference = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A threshold that enforces a pre-filter roundtrip to prefilter search shards based on query rewriting if the number of shards the search request expands to exceeds the threshold.
	/// This filter roundtrip can limit the number of shards significantly if for instance a shard can not match any documents based on its rewrite method (if date filters are mandatory to match but the shard bounds and the query are disjoint).
	/// When unspecified, the pre-filter phase is executed if any of these conditions is met:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// The request targets more than 128 shards.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// The request targets one or more read-only index.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// The primary sort of the query targets an indexed field.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor PreFilterShardSize(long? value)
	{
		Instance.PreFilterShardSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query in the Lucene query string syntax.
	/// Query parameter searches do not support the full Elasticsearch Query DSL but are handy for testing.
	/// </para>
	/// <para>
	/// IMPORTANT: This parameter overrides the query parameter in the request body.
	/// If both parameters are specified, documents matching the query request body parameter are not returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor QueryLuceneSyntax(string? value)
	{
		Instance.QueryLuceneSyntax = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the caching of search results is enabled for requests where <c>size</c> is <c>0</c>.
	/// It defaults to index level settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor RequestCache(bool? value = true)
	{
		Instance.RequestCache = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether <c>hits.total</c> should be rendered as an integer or an object in the rest search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor RestTotalHitsAsInt(bool? value = true)
	{
		Instance.RestTotalHitsAsInt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A custom value that is used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to retain the search context for scrolling.
	/// By default, this value cannot exceed <c>1d</c> (24 hours).
	/// You can change this limit by using the <c>search.max_keep_alive</c> cluster-level setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Scroll(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Scroll = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how distributed term frequencies are calculated for relevance scoring.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SearchType(Elastic.Clients.Elasticsearch.SearchType? value)
	{
		Instance.SearchType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SourceExcludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SourceExcludes<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SourceIncludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SourceIncludes<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SuggestField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.SuggestField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SuggestField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.SuggestField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The suggest mode.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SuggestMode(Elastic.Clients.Elasticsearch.SuggestMode? value)
	{
		Instance.SuggestMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of suggestions to return.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SuggestSize(long? value)
	{
		Instance.SuggestSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source text for which the suggestions should be returned.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SuggestText(string? value)
	{
		Instance.SuggestText = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, aggregation and suggester names are be prefixed by their respective types in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor TypedKeys(bool? value = true)
	{
		Instance.TypedKeys = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Aggregations<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddAggregation<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Collapse(Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? value)
	{
		Instance.Collapse = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Collapse(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Collapse<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<T>> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor DocvalueFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.DocvalueFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor DocvalueFields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.DocvalueFields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor DocvalueFields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor DocvalueFields<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns detailed information about score computation as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Ext(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Ext = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Ext()
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Ext(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddExt(string key, object value)
	{
		Instance.Ext ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Ext.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Fields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Fields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Fields<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The starting document offset, which must be non-negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Highlight(Elastic.Clients.Elasticsearch.Core.Search.Highlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Highlight(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Highlight<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<T>> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor IndicesBoost(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>? value)
	{
		Instance.IndicesBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor IndicesBoost()
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor IndicesBoost(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble>? action)
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddIndicesBoost(Elastic.Clients.Elasticsearch.IndexName key, double value)
	{
		Instance.IndicesBoost ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>();
		Instance.IndicesBoost.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>(key, value));
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Knn(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.KnnSearch>? value)
	{
		Instance.Knn = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Knn(params Elastic.Clients.Elasticsearch.KnnSearch[] values)
	{
		Instance.Knn = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Knn(params System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.KnnSearch>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.KnnSearchDescriptor.Build(action));
		}

		Instance.Knn = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Knn<T>(params System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.KnnSearch>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.KnnSearchDescriptor<T>.Build(action));
		}

		Instance.Knn = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum <c>_score</c> for matching documents.
	/// Documents with a lower <c>_score</c> are not included in search results and results collected by aggregations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor MinScore(double? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Pit(Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReference? value)
	{
		Instance.Pit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Pit(System.Action<Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor> action)
	{
		Instance.Pit = Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor PostFilter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.PostFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor PostFilter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.PostFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor PostFilter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.PostFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to return detailed timing information about the execution of individual components in a search request.
	/// NOTE: This is a debugging tool and adds significant overhead to search execution.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Profile(bool? value = true)
	{
		Instance.Profile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Rank(Elastic.Clients.Elasticsearch.Rank? value)
	{
		Instance.Rank = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Rank(System.Action<Elastic.Clients.Elasticsearch.RankDescriptor> action)
	{
		Instance.Rank = Elastic.Clients.Elasticsearch.RankDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Rescore(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.Rescore>? value)
	{
		Instance.Rescore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Rescore(params Elastic.Clients.Elasticsearch.Core.Search.Rescore[] values)
	{
		Instance.Rescore = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Rescore(params System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.Rescore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor.Build(action));
		}

		Instance.Rescore = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Rescore<T>(params System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.Rescore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<T>.Build(action));
		}

		Instance.Rescore = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Retriever(Elastic.Clients.Elasticsearch.Retriever? value)
	{
		Instance.Retriever = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Retriever(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Retriever<T>(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor RuntimeMappings<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddRuntimeMapping<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor ScriptFields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddScriptField(string key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor AddScriptField(string key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SearchAfter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.SearchAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SearchAfter(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.SearchAfter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns sequence number and primary term of the last modification of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SeqNoPrimaryTerm(bool? value = true)
	{
		Instance.SeqNoPrimaryTerm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of hits to return, which must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> property.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Slice(Elastic.Clients.Elasticsearch.SlicedScroll? value)
	{
		Instance.Slice = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Slice(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Slice<T>(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<T>> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Sort<T>(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Source<T>(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<T>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Stats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Stats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Stats(params string[] values)
	{
		Instance.Stats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor StoredFields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Suggest(Elastic.Clients.Elasticsearch.Core.Search.Suggester? value)
	{
		Instance.Suggest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Suggest()
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Suggest(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor>? action)
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Suggest<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<T>>? action)
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of documents to collect for each shard.
	/// If a query reaches this limit, Elasticsearch terminates the query early.
	/// Elasticsearch collects documents before sorting.
	/// </para>
	/// <para>
	/// IMPORTANT: Use with caution.
	/// Elasticsearch applies this property to each shard handling the request.
	/// When possible, let Elasticsearch perform early termination automatically.
	/// Avoid specifying this property for requests that target data streams with backing indices across multiple data tiers.
	/// </para>
	/// <para>
	/// If set to <c>0</c> (default), the query does not terminate early.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor TerminateAfter(long? value)
	{
		Instance.TerminateAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period of time to wait for a response from each shard.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// Defaults to no timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Timeout(string? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, calculate and return document scores, even if the scores are not used for sorting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor TrackScores(bool? value = true)
	{
		Instance.TrackScores = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor TrackTotalHits(Elastic.Clients.Elasticsearch.Core.Search.TrackHits? value)
	{
		Instance.TrackTotalHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor TrackTotalHits(System.Func<Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory, Elastic.Clients.Elasticsearch.Core.Search.TrackHits> action)
	{
		Instance.TrackTotalHits = Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns the document version as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Version(bool? value = true)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SearchRequest Build(System.Action<Elastic.Clients.Elasticsearch.SearchRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.SearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.SearchRequestDescriptor(new Elastic.Clients.Elasticsearch.SearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Run a search.
/// </para>
/// <para>
/// Get search hits that match the query defined in the request.
/// You can provide search queries using the <c>q</c> query string parameter or the request body.
/// If both are specified, only the query parameter is used.
/// </para>
/// <para>
/// If the Elasticsearch security features are enabled, you must have the read index privilege for the target data stream, index, or alias. For cross-cluster search, refer to the documentation about configuring CCS privileges.
/// To search a point in time (PIT) for an alias, you must have the <c>read</c> index privilege for the alias's data streams or indices.
/// </para>
/// <para>
/// <strong>Search slicing</strong>
/// </para>
/// <para>
/// When paging through a large number of documents, it can be helpful to split the search into multiple slices to consume them independently with the <c>slice</c> and <c>pit</c> properties.
/// By default the splitting is done first on the shards, then locally on each shard.
/// The local splitting partitions the shard into contiguous ranges based on Lucene document IDs.
/// </para>
/// <para>
/// For instance if the number of shards is equal to 2 and you request 4 slices, the slices 0 and 2 are assigned to the first shard and the slices 1 and 3 are assigned to the second shard.
/// </para>
/// <para>
/// IMPORTANT: The same point-in-time ID should be used for all slices.
/// If different PIT IDs are used, slices can overlap and miss documents.
/// This situation can occur because the splitting criterion is based on Lucene document IDs, which are not stable across changes to the index.
/// </para>
/// </summary>
public readonly partial struct SearchRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.SearchRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SearchRequestDescriptor(Elastic.Clients.Elasticsearch.SearchRequest instance)
	{
		Instance = instance;
	}

	public SearchRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.SearchRequest(indices);
	}

	public SearchRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.SearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.SearchRequest instance) => new Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SearchRequest(Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of data streams, indices, and aliases to search.
	/// It supports wildcards (<c>*</c>).
	/// To search all data streams and indices, omit this parameter or use <c>*</c> or <c>_all</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> and there are shard request timeouts or shard failures, the request returns partial results.
	/// If <c>false</c>, it returns an error with no partial results.
	/// </para>
	/// <para>
	/// To override the default behavior, you can set the <c>search.default_allow_partial_results</c> cluster setting to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AllowPartialSearchResults(bool? value = true)
	{
		Instance.AllowPartialSearchResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analyzer to use for the query string.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, wildcard and prefix queries are analyzed.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AnalyzeWildcard(bool? value = true)
	{
		Instance.AnalyzeWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of shard results that should be reduced at once on the coordinating node.
	/// If the potential number of shards in the request can be large, this value should be used as a protection mechanism to reduce the memory overhead per search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> BatchedReduceSize(long? value)
	{
		Instance.BatchedReduceSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, network round-trips between the coordinating node and the remote clusters are minimized when running cross-cluster search (CCS) requests.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> CcsMinimizeRoundtrips(bool? value = true)
	{
		Instance.CcsMinimizeRoundtrips = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The default operator for the query string query: <c>AND</c> or <c>OR</c>.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> DefaultOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.DefaultOperator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to use as a default when no field prefix is given in the query string.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Df(string? value)
	{
		Instance.Df = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// It supports comma-separated values such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// It supports comma-separated values such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Should this request force synthetic _source?
	/// Use this to test if the mapping supports synthetic _source and to get a sense of the worst case performance.
	/// Fetches with this enabled will be slower the enabling synthetic source natively in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> ForceSyntheticSource(bool? value = true)
	{
		Instance.ForceSyntheticSource = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.16.0'.")]
	/// <summary>
	/// <para>
	/// If <c>true</c>, concrete, expanded or aliased indices will be ignored when frozen.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> IgnoreThrottled(bool? value = true)
	{
		Instance.IgnoreThrottled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if it targets a missing or closed index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes the score contribution from any named queries.
	/// </para>
	/// <para>
	/// This functionality reruns each named query on every hit in a search response.
	/// Typically, this adds a small overhead to a request.
	/// However, using computationally expensive named queries on a large number of hits may add significant overhead.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> IncludeNamedQueriesScore(bool? value = true)
	{
		Instance.IncludeNamedQueriesScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, format-based query failures (such as providing text to a numeric field) in the query string will be ignored.
	/// This parameter can be used only when the <c>q</c> query string parameter is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Lenient(bool? value = true)
	{
		Instance.Lenient = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of concurrent shard requests per node that the search runs concurrently.
	/// This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> MaxConcurrentShardRequests(int? value)
	{
		Instance.MaxConcurrentShardRequests = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The nodes and shards used for the search.
	/// By default, Elasticsearch selects from eligible nodes and shards using adaptive replica selection, accounting for allocation awareness.
	/// Valid values are:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>_only_local</c> to run the search only on shards on the local node.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_local</c> to, if possible, run the search on shards on the local node, or if not, select shards using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_only_nodes:&lt;node-id>,&lt;node-id></c> to run the search on only the specified nodes IDs. If suitable shards exist on more than one selected node, use shards on those nodes using the default method. If none of the specified nodes are available, select shards from any available node using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_prefer_nodes:&lt;node-id>,&lt;node-id></c> to if possible, run the search on the specified nodes IDs. If not, select shards using the default method.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>_shards:&lt;shard>,&lt;shard></c> to run the search only on the specified shards. You can combine this value with other <c>preference</c> values. However, the <c>_shards</c> value must come first. For example: <c>_shards:2,3|_local</c>.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>&lt;custom-string></c> (any string that does not start with <c>_</c>) to route searches with the same <c>&lt;custom-string></c> to the same shards in the same order.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Preference(string? value)
	{
		Instance.Preference = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A threshold that enforces a pre-filter roundtrip to prefilter search shards based on query rewriting if the number of shards the search request expands to exceeds the threshold.
	/// This filter roundtrip can limit the number of shards significantly if for instance a shard can not match any documents based on its rewrite method (if date filters are mandatory to match but the shard bounds and the query are disjoint).
	/// When unspecified, the pre-filter phase is executed if any of these conditions is met:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// The request targets more than 128 shards.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// The request targets one or more read-only index.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// The primary sort of the query targets an indexed field.
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> PreFilterShardSize(long? value)
	{
		Instance.PreFilterShardSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query in the Lucene query string syntax.
	/// Query parameter searches do not support the full Elasticsearch Query DSL but are handy for testing.
	/// </para>
	/// <para>
	/// IMPORTANT: This parameter overrides the query parameter in the request body.
	/// If both parameters are specified, documents matching the query request body parameter are not returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> QueryLuceneSyntax(string? value)
	{
		Instance.QueryLuceneSyntax = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the caching of search results is enabled for requests where <c>size</c> is <c>0</c>.
	/// It defaults to index level settings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> RequestCache(bool? value = true)
	{
		Instance.RequestCache = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether <c>hits.total</c> should be rendered as an integer or an object in the rest search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> RestTotalHitsAsInt(bool? value = true)
	{
		Instance.RestTotalHitsAsInt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A custom value that is used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to retain the search context for scrolling.
	/// By default, this value cannot exceed <c>1d</c> (24 hours).
	/// You can change this limit by using the <c>search.max_keep_alive</c> cluster-level setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Scroll(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Scroll = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how distributed term frequencies are calculated for relevance scoring.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SearchType(Elastic.Clients.Elasticsearch.SearchType? value)
	{
		Instance.SearchType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SourceExcludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SourceExcludes(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SourceIncludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SourceIncludes(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SuggestField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.SuggestField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SuggestField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.SuggestField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The suggest mode.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SuggestMode(Elastic.Clients.Elasticsearch.SuggestMode? value)
	{
		Instance.SuggestMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of suggestions to return.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SuggestSize(long? value)
	{
		Instance.SuggestSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source text for which the suggestions should be returned.
	/// This parameter can be used only when the <c>suggest_field</c> and <c>suggest_text</c> query string parameters are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SuggestText(string? value)
	{
		Instance.SuggestText = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, aggregation and suggester names are be prefixed by their respective types in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> TypedKeys(bool? value = true)
	{
		Instance.TypedKeys = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the aggregations that are run as part of the search request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Collapse(Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? value)
	{
		Instance.Collapse = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Collapses search results the values of the specified field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Collapse(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<TDocument>> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> DocvalueFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.DocvalueFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> DocvalueFields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.DocvalueFields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns doc values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> DocvalueFields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns detailed information about score computation as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Ext(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Ext = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Ext()
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Ext(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddExt(string key, object value)
	{
		Instance.Ext ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Ext.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Fields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of wildcard (<c>*</c>) field patterns.
	/// The request returns values for field names matching these patterns in the <c>hits.fields</c> property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Fields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The starting document offset, which must be non-negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Highlight(Elastic.Clients.Elasticsearch.Core.Search.Highlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the highlighter to use for retrieving highlighted snippets from one or more fields in your search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Highlight(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<TDocument>> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> IndicesBoost(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>? value)
	{
		Instance.IndicesBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> IndicesBoost()
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boost the <c>_score</c> of documents from specified indices.
	/// The boost value is the factor by which scores are multiplied.
	/// A boost value greater than <c>1.0</c> increases the score.
	/// A boost value between <c>0</c> and <c>1.0</c> decreases the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> IndicesBoost(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble>? action)
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddIndicesBoost(Elastic.Clients.Elasticsearch.IndexName key, double value)
	{
		Instance.IndicesBoost ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>();
		Instance.IndicesBoost.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>(key, value));
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Knn(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.KnnSearch>? value)
	{
		Instance.Knn = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Knn(params Elastic.Clients.Elasticsearch.KnnSearch[] values)
	{
		Instance.Knn = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Knn(params System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.KnnSearch>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>.Build(action));
		}

		Instance.Knn = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum <c>_score</c> for matching documents.
	/// Documents with a lower <c>_score</c> are not included in search results and results collected by aggregations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> MinScore(double? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Pit(Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReference? value)
	{
		Instance.Pit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the search to a point in time (PIT).
	/// If you provide a PIT, you cannot specify an <c>&lt;index></c> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Pit(System.Action<Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor> action)
	{
		Instance.Pit = Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> PostFilter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.PostFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use the <c>post_filter</c> parameter to filter search results.
	/// The search hits are filtered after the aggregations are calculated.
	/// A post filter has no impact on the aggregation results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> PostFilter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.PostFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to return detailed timing information about the execution of individual components in a search request.
	/// NOTE: This is a debugging tool and adds significant overhead to search execution.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Profile(bool? value = true)
	{
		Instance.Profile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Rank(Elastic.Clients.Elasticsearch.Rank? value)
	{
		Instance.Rank = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Reciprocal Rank Fusion (RRF) to use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Rank(System.Action<Elastic.Clients.Elasticsearch.RankDescriptor> action)
	{
		Instance.Rank = Elastic.Clients.Elasticsearch.RankDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Rescore(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.Rescore>? value)
	{
		Instance.Rescore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Rescore(params Elastic.Clients.Elasticsearch.Core.Search.Rescore[] values)
	{
		Instance.Rescore = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Can be used to improve precision by reordering just the top (for example 100 - 500) documents returned by the <c>query</c> and <c>post_filter</c> phases.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Rescore(params System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.Rescore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>.Build(action));
		}

		Instance.Rescore = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Retriever(Elastic.Clients.Elasticsearch.Retriever? value)
	{
		Instance.Retriever = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A retriever is a specification to describe top documents returned from a search.
	/// A retriever replaces other elements of the search API that also return top documents such as <c>query</c> and <c>knn</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Retriever(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields in the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> ScriptFields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddScriptField(string key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> AddScriptField(string key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SearchAfter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.SearchAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Used to retrieve the next page of hits using a set of sort values from the previous page.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SearchAfter(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.SearchAfter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns sequence number and primary term of the last modification of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SeqNoPrimaryTerm(bool? value = true)
	{
		Instance.SeqNoPrimaryTerm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of hits to return, which must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> property.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Slice(Elastic.Clients.Elasticsearch.SlicedScroll? value)
	{
		Instance.Slice = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Split a scrolled search into multiple slices that can be consumed independently.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Slice(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<TDocument>> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of &lt;field>:&lt;direction> pairs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source fields that are returned for matching documents.
	/// These fields are returned in the <c>hits._source</c> property of the search response.
	/// If the <c>stored_fields</c> property is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// Otherwise, it defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Stats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Stats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The stats groups to associate with the search.
	/// Each group maintains a statistics aggregation for its associated searches.
	/// You can retrieve these stats using the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Stats(params string[] values)
	{
		Instance.Stats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> property defaults to <c>false</c>.
	/// You can pass <c>_source: true</c> to return both source fields and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> StoredFields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Suggest(Elastic.Clients.Elasticsearch.Core.Search.Suggester? value)
	{
		Instance.Suggest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Suggest()
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines a suggester that provides similar looking terms based on a provided text.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Suggest(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>>? action)
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of documents to collect for each shard.
	/// If a query reaches this limit, Elasticsearch terminates the query early.
	/// Elasticsearch collects documents before sorting.
	/// </para>
	/// <para>
	/// IMPORTANT: Use with caution.
	/// Elasticsearch applies this property to each shard handling the request.
	/// When possible, let Elasticsearch perform early termination automatically.
	/// Avoid specifying this property for requests that target data streams with backing indices across multiple data tiers.
	/// </para>
	/// <para>
	/// If set to <c>0</c> (default), the query does not terminate early.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> TerminateAfter(long? value)
	{
		Instance.TerminateAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period of time to wait for a response from each shard.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// Defaults to no timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Timeout(string? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, calculate and return document scores, even if the scores are not used for sorting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> TrackScores(bool? value = true)
	{
		Instance.TrackScores = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> TrackTotalHits(Elastic.Clients.Elasticsearch.Core.Search.TrackHits? value)
	{
		Instance.TrackTotalHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately.
	/// If <c>true</c>, the exact number of hits is returned at the cost of some performance.
	/// If <c>false</c>, the  response does not include the total number of hits matching the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> TrackTotalHits(System.Func<Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory, Elastic.Clients.Elasticsearch.Core.Search.TrackHits> action)
	{
		Instance.TrackTotalHits = Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request returns the document version as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Version(bool? value = true)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SearchRequest Build(System.Action<Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.SearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.SearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}