// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SearchApplication;

public sealed partial class PutSearchApplicationRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c>, this request cannot replace or update existing Search Applications.
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }
}

/// <summary>
/// <para>
/// Create or update a search application.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.SearchApplication.Json.PutSearchApplicationRequestConverter))]
public sealed partial class PutSearchApplicationRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutSearchApplicationRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("name", name))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutSearchApplicationRequest(Elastic.Clients.Elasticsearch.Name name, Elastic.Clients.Elasticsearch.SearchApplication.SearchApplicationParameters searchApplication) : base(r => r.Required("name", name))
	{
		SearchApplication = searchApplication;
	}
#if NET7_0_OR_GREATER
	public PutSearchApplicationRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutSearchApplicationRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SearchApplicationPut;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "search_application.put";

	/// <summary>
	/// <para>
	/// The name of the search application to be created or updated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, this request cannot replace or update existing Search Applications.
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.SearchApplication.SearchApplicationParameters SearchApplication { get; set; }
}

/// <summary>
/// <para>
/// Create or update a search application.
/// </para>
/// </summary>
public readonly partial struct PutSearchApplicationRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutSearchApplicationRequestDescriptor(Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequest instance)
	{
		Instance = instance;
	}

	public PutSearchApplicationRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequest(name);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutSearchApplicationRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor(Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequest instance) => new Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequest(Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the search application to be created or updated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, this request cannot replace or update existing Search Applications.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor Create(bool? value = true)
	{
		Instance.Create = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor SearchApplication(Elastic.Clients.Elasticsearch.SearchApplication.SearchApplicationParameters value)
	{
		Instance.SearchApplication = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor SearchApplication(System.Action<Elastic.Clients.Elasticsearch.SearchApplication.SearchApplicationParametersDescriptor> action)
	{
		Instance.SearchApplication = Elastic.Clients.Elasticsearch.SearchApplication.SearchApplicationParametersDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequest Build(System.Action<Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor(new Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PutSearchApplicationRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}