// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SearchApplication;

public sealed partial class PostBehavioralAnalyticsEventRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Whether the response type has to include more details
	/// </para>
	/// </summary>
	public bool? Debug { get => Q<bool?>("debug"); set => Q("debug", value); }
}

/// <summary>
/// <para>
/// Create a behavioral analytics collection event.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.SearchApplication.Json.PostBehavioralAnalyticsEventRequestConverter))]
public sealed partial class PostBehavioralAnalyticsEventRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PostBehavioralAnalyticsEventRequest(Elastic.Clients.Elasticsearch.Name collectionName, Elastic.Clients.Elasticsearch.SearchApplication.EventType eventType) : base(r => r.Required("collection_name", collectionName).Required("event_type", eventType))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PostBehavioralAnalyticsEventRequest(Elastic.Clients.Elasticsearch.Name collectionName, Elastic.Clients.Elasticsearch.SearchApplication.EventType eventType, object payload) : base(r => r.Required("collection_name", collectionName).Required("event_type", eventType))
	{
		Payload = payload;
	}
#if NET7_0_OR_GREATER
	public PostBehavioralAnalyticsEventRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PostBehavioralAnalyticsEventRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SearchApplicationPostBehavioralAnalyticsEvent;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "search_application.post_behavioral_analytics_event";

	/// <summary>
	/// <para>
	/// The name of the behavioral analytics collection.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name CollectionName { get => P<Elastic.Clients.Elasticsearch.Name>("collection_name"); set => PR("collection_name", value); }

	/// <summary>
	/// <para>
	/// The analytics event type.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.SearchApplication.EventType EventType { get => P<Elastic.Clients.Elasticsearch.SearchApplication.EventType>("event_type"); set => PR("event_type", value); }

	/// <summary>
	/// <para>
	/// Whether the response type has to include more details
	/// </para>
	/// </summary>
	public bool? Debug { get => Q<bool?>("debug"); set => Q("debug", value); }
	public
#if NET7_0_OR_GREATER
	required
#endif
	object Payload { get; set; }
}

/// <summary>
/// <para>
/// Create a behavioral analytics collection event.
/// </para>
/// </summary>
public readonly partial struct PostBehavioralAnalyticsEventRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PostBehavioralAnalyticsEventRequestDescriptor(Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequest instance)
	{
		Instance = instance;
	}

	public PostBehavioralAnalyticsEventRequestDescriptor(Elastic.Clients.Elasticsearch.Name collectionName, Elastic.Clients.Elasticsearch.SearchApplication.EventType eventType)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequest(collectionName, eventType);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PostBehavioralAnalyticsEventRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor(Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequest instance) => new Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequest(Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the behavioral analytics collection.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor CollectionName(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.CollectionName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analytics event type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor EventType(Elastic.Clients.Elasticsearch.SearchApplication.EventType value)
	{
		Instance.EventType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether the response type has to include more details
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor Debug(bool? value = true)
	{
		Instance.Debug = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor Payload(object value)
	{
		Instance.Payload = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequest Build(System.Action<Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor(new Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.PostBehavioralAnalyticsEventRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}