// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SearchApplication;

public sealed partial class GetBehavioralAnalyticsRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get behavioral analytics collections.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.SearchApplication.Json.GetBehavioralAnalyticsRequestConverter))]
public sealed partial class GetBehavioralAnalyticsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestParameters>
{
	public GetBehavioralAnalyticsRequest(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? name) : base(r => r.Optional("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public GetBehavioralAnalyticsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetBehavioralAnalyticsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetBehavioralAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SearchApplicationGetBehavioralAnalytics;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "search_application.get_behavioral_analytics";

	/// <summary>
	/// <para>
	/// A list of analytics collections to limit the returned information
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? Name { get => P<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>?>("name"); set => PO("name", value); }
}

/// <summary>
/// <para>
/// Get behavioral analytics collections.
/// </para>
/// </summary>
public readonly partial struct GetBehavioralAnalyticsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetBehavioralAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequest instance)
	{
		Instance = instance;
	}

	public GetBehavioralAnalyticsRequestDescriptor(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? name)
	{
		Instance = new Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequest(name);
	}

	public GetBehavioralAnalyticsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequest instance) => new Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequest(Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A list of analytics collections to limit the returned information
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor Name(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of analytics collections to limit the returned information
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor Name(params Elastic.Clients.Elasticsearch.Name[] values)
	{
		Instance.Name = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequest Build(System.Action<Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor(new Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SearchApplication.GetBehavioralAnalyticsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}