// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

public sealed partial class ScrollRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If true, the API response’s hit.total property is returned as an integer. If false, the API response’s hit.total property is returned as an object.
	/// </para>
	/// </summary>
	public bool? RestTotalHitsAsInt { get => Q<bool?>("rest_total_hits_as_int"); set => Q("rest_total_hits_as_int", value); }
}

/// <summary>
/// <para>
/// Run a scrolling search.
/// </para>
/// <para>
/// IMPORTANT: The scroll API is no longer recommend for deep pagination. If you need to preserve the index state while paging through more than 10,000 hits, use the <c>search_after</c> parameter with a point in time (PIT).
/// </para>
/// <para>
/// The scroll API gets large sets of results from a single scrolling search request.
/// To get the necessary scroll ID, submit a search API request that includes an argument for the <c>scroll</c> query parameter.
/// The <c>scroll</c> parameter indicates how long Elasticsearch should retain the search context for the request.
/// The search response returns a scroll ID in the <c>_scroll_id</c> response body parameter.
/// You can then use the scroll ID with the scroll API to retrieve the next batch of results for the request.
/// If the Elasticsearch security features are enabled, the access to the results of a specific scroll ID is restricted to the user or API key that submitted the search.
/// </para>
/// <para>
/// You can also use the scroll API to specify a new scroll parameter that extends or shortens the retention period for the search context.
/// </para>
/// <para>
/// IMPORTANT: Results from a scrolling search reflect the state of the index at the time of the initial search request. Subsequent indexing or document changes only affect later search and scroll requests.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ScrollRequestConverter))]
public sealed partial class ScrollRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.ScrollRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScrollRequest(Elastic.Clients.Elasticsearch.ScrollId scrollId)
	{
		ScrollId = scrollId;
	}
#if NET7_0_OR_GREATER
	public ScrollRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ScrollRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ScrollRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.NoNamespaceScroll;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "scroll";

	/// <summary>
	/// <para>
	/// If true, the API response’s hit.total property is returned as an integer. If false, the API response’s hit.total property is returned as an object.
	/// </para>
	/// </summary>
	public bool? RestTotalHitsAsInt { get => Q<bool?>("rest_total_hits_as_int"); set => Q("rest_total_hits_as_int", value); }

	/// <summary>
	/// <para>
	/// The period to retain the search context for scrolling.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Scroll { get; set; }

	/// <summary>
	/// <para>
	/// The scroll ID of the search.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ScrollId ScrollId { get; set; }
}

/// <summary>
/// <para>
/// Run a scrolling search.
/// </para>
/// <para>
/// IMPORTANT: The scroll API is no longer recommend for deep pagination. If you need to preserve the index state while paging through more than 10,000 hits, use the <c>search_after</c> parameter with a point in time (PIT).
/// </para>
/// <para>
/// The scroll API gets large sets of results from a single scrolling search request.
/// To get the necessary scroll ID, submit a search API request that includes an argument for the <c>scroll</c> query parameter.
/// The <c>scroll</c> parameter indicates how long Elasticsearch should retain the search context for the request.
/// The search response returns a scroll ID in the <c>_scroll_id</c> response body parameter.
/// You can then use the scroll ID with the scroll API to retrieve the next batch of results for the request.
/// If the Elasticsearch security features are enabled, the access to the results of a specific scroll ID is restricted to the user or API key that submitted the search.
/// </para>
/// <para>
/// You can also use the scroll API to specify a new scroll parameter that extends or shortens the retention period for the search context.
/// </para>
/// <para>
/// IMPORTANT: Results from a scrolling search reflect the state of the index at the time of the initial search request. Subsequent indexing or document changes only affect later search and scroll requests.
/// </para>
/// </summary>
public readonly partial struct ScrollRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.ScrollRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScrollRequestDescriptor(Elastic.Clients.Elasticsearch.ScrollRequest instance)
	{
		Instance = instance;
	}

	public ScrollRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.ScrollRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.ScrollRequestDescriptor(Elastic.Clients.Elasticsearch.ScrollRequest instance) => new Elastic.Clients.Elasticsearch.ScrollRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.ScrollRequest(Elastic.Clients.Elasticsearch.ScrollRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If true, the API response’s hit.total property is returned as an integer. If false, the API response’s hit.total property is returned as an object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor RestTotalHitsAsInt(bool? value = true)
	{
		Instance.RestTotalHitsAsInt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to retain the search context for scrolling.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor Scroll(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Scroll = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The scroll ID of the search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor ScrollId(Elastic.Clients.Elasticsearch.ScrollId value)
	{
		Instance.ScrollId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.ScrollRequest Build(System.Action<Elastic.Clients.Elasticsearch.ScrollRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.ScrollRequestDescriptor(new Elastic.Clients.Elasticsearch.ScrollRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScrollRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}