// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

public sealed partial class ScriptsPainlessExecuteRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Run a script.
/// </para>
/// <para>
/// Runs a script and returns a result.
/// Use this API to build and test scripts, such as when defining a script for a runtime field.
/// This API requires very few dependencies and is especially useful if you don't have permissions to write documents on a cluster.
/// </para>
/// <para>
/// The API uses several <em>contexts</em>, which control how scripts are run, what variables are available at runtime, and what the return type is.
/// </para>
/// <para>
/// Each context requires a script, but additional parameters depend on the context you're using for that script.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ScriptsPainlessExecuteRequestConverter))]
public sealed partial class ScriptsPainlessExecuteRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestParameters>
{
#if NET7_0_OR_GREATER
	public ScriptsPainlessExecuteRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ScriptsPainlessExecuteRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ScriptsPainlessExecuteRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.NoNamespaceScriptsPainlessExecute;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "scripts_painless_execute";

	/// <summary>
	/// <para>
	/// The context that the script should run in.
	/// NOTE: Result ordering in the field contexts is not guaranteed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContext? Context { get; set; }

	/// <summary>
	/// <para>
	/// Additional parameters for the <c>context</c>.
	/// NOTE: This parameter is required for all contexts except <c>painless_test</c>, which is the default if no value is provided for <c>context</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup? ContextSetup { get; set; }

	/// <summary>
	/// <para>
	/// The Painless script to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Script? Script { get; set; }
}

/// <summary>
/// <para>
/// Run a script.
/// </para>
/// <para>
/// Runs a script and returns a result.
/// Use this API to build and test scripts, such as when defining a script for a runtime field.
/// This API requires very few dependencies and is especially useful if you don't have permissions to write documents on a cluster.
/// </para>
/// <para>
/// The API uses several <em>contexts</em>, which control how scripts are run, what variables are available at runtime, and what the return type is.
/// </para>
/// <para>
/// Each context requires a script, but additional parameters depend on the context you're using for that script.
/// </para>
/// </summary>
public readonly partial struct ScriptsPainlessExecuteRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptsPainlessExecuteRequestDescriptor(Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest instance)
	{
		Instance = instance;
	}

	public ScriptsPainlessExecuteRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor(Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest instance) => new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest(Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The context that the script should run in.
	/// NOTE: Result ordering in the field contexts is not guaranteed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor Context(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContext? value)
	{
		Instance.Context = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional parameters for the <c>context</c>.
	/// NOTE: This parameter is required for all contexts except <c>painless_test</c>, which is the default if no value is provided for <c>context</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor ContextSetup(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup? value)
	{
		Instance.ContextSetup = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional parameters for the <c>context</c>.
	/// NOTE: This parameter is required for all contexts except <c>painless_test</c>, which is the default if no value is provided for <c>context</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor ContextSetup(System.Action<Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor> action)
	{
		Instance.ContextSetup = Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional parameters for the <c>context</c>.
	/// NOTE: This parameter is required for all contexts except <c>painless_test</c>, which is the default if no value is provided for <c>context</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor ContextSetup<T>(System.Action<Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<T>> action)
	{
		Instance.ContextSetup = Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Painless script to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Painless script to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Painless script to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest Build(System.Action<Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor(new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Run a script.
/// </para>
/// <para>
/// Runs a script and returns a result.
/// Use this API to build and test scripts, such as when defining a script for a runtime field.
/// This API requires very few dependencies and is especially useful if you don't have permissions to write documents on a cluster.
/// </para>
/// <para>
/// The API uses several <em>contexts</em>, which control how scripts are run, what variables are available at runtime, and what the return type is.
/// </para>
/// <para>
/// Each context requires a script, but additional parameters depend on the context you're using for that script.
/// </para>
/// </summary>
public readonly partial struct ScriptsPainlessExecuteRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ScriptsPainlessExecuteRequestDescriptor(Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest instance)
	{
		Instance = instance;
	}

	public ScriptsPainlessExecuteRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest instance) => new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest(Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The context that the script should run in.
	/// NOTE: Result ordering in the field contexts is not guaranteed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> Context(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContext? value)
	{
		Instance.Context = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional parameters for the <c>context</c>.
	/// NOTE: This parameter is required for all contexts except <c>painless_test</c>, which is the default if no value is provided for <c>context</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> ContextSetup(Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetup? value)
	{
		Instance.ContextSetup = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional parameters for the <c>context</c>.
	/// NOTE: This parameter is required for all contexts except <c>painless_test</c>, which is the default if no value is provided for <c>context</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> ContextSetup(System.Action<Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument>> action)
	{
		Instance.ContextSetup = Elastic.Clients.Elasticsearch.Core.ScriptsPainlessExecute.PainlessContextSetupDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Painless script to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> Script(Elastic.Clients.Elasticsearch.Script? value)
	{
		Instance.Script = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Painless script to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> Script()
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Painless script to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> Script(System.Action<Elastic.Clients.Elasticsearch.ScriptDescriptor>? action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.ScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest Build(System.Action<Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ScriptsPainlessExecuteRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}