// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup;

public sealed partial class PutJobRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Create a rollup job.
/// </para>
/// <para>
/// WARNING: From 8.15.0, calling this API in a cluster with no rollup usage will fail with a message about the deprecation and planned removal of rollup features. A cluster needs to contain either a rollup job or a rollup index in order for this API to be allowed to run.
/// </para>
/// <para>
/// The rollup job configuration contains all the details about how the job should run, when it indexes documents, and what future queries will be able to run against the rollup index.
/// </para>
/// <para>
/// There are three main sections to the job configuration: the logistical details about the job (for example, the cron schedule), the fields that are used for grouping, and what metrics to collect for each group.
/// </para>
/// <para>
/// Jobs are created in a <c>STOPPED</c> state. You can start them with the start rollup jobs API.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Rollup.Json.PutJobRequestConverter))]
public sealed partial class PutJobRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Rollup.PutJobRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutJobRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutJobRequest(Elastic.Clients.Elasticsearch.Id id, string cron, Elastic.Clients.Elasticsearch.Rollup.Groupings groups, string indexPattern, int pageSize, Elastic.Clients.Elasticsearch.IndexName rollupIndex) : base(r => r.Required("id", id))
	{
		Cron = cron;
		Groups = groups;
		IndexPattern = indexPattern;
		PageSize = pageSize;
		RollupIndex = rollupIndex;
	}
#if NET7_0_OR_GREATER
	public PutJobRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.RollupPutJob;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "rollup.put_job";

	/// <summary>
	/// <para>
	/// Identifier for the rollup job. This can be any alphanumeric string and uniquely identifies the
	/// data that is associated with the rollup job. The ID is persistent; it is stored with the rolled
	/// up data. If you create a job, let it run for a while, then delete the job, the data that the job
	/// rolled up is still be associated with this job ID. You cannot create a new job with the same ID
	/// since that could lead to problems with mismatched job configurations.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// A cron string which defines the intervals when the rollup job should be executed. When the interval
	/// triggers, the indexer attempts to rollup the data in the index pattern. The cron pattern is unrelated
	/// to the time interval of the data being rolled up. For example, you may wish to create hourly rollups
	/// of your document but to only run the indexer on a daily basis at midnight, as defined by the cron. The
	/// cron pattern is defined just like a Watcher cron schedule.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Cron { get; set; }

	/// <summary>
	/// <para>
	/// Defines the grouping fields and aggregations that are defined for this rollup job. These fields will then be
	/// available later for aggregating into buckets. These aggs and fields can be used in any combination. Think of
	/// the groups configuration as defining a set of tools that can later be used in aggregations to partition the
	/// data. Unlike raw data, we have to think ahead to which fields and aggregations might be used. Rollups provide
	/// enough flexibility that you simply need to determine which fields are needed, not in what order they are needed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Rollup.Groupings Groups { get; set; }
	public System.Collections.Generic.IDictionary<string, System.Collections.Generic.ICollection<string>>? Headers { get; set; }

	/// <summary>
	/// <para>
	/// The index or index pattern to roll up. Supports wildcard-style patterns (<c>logstash-*</c>). The job attempts to
	/// rollup the entire index or index-pattern.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string IndexPattern { get; set; }

	/// <summary>
	/// <para>
	/// Defines the metrics to collect for each grouping tuple. By default, only the doc_counts are collected for each
	/// group. To make rollup useful, you will often add metrics like averages, mins, maxes, etc. Metrics are defined
	/// on a per-field basis and for each field you configure which metric should be collected.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Rollup.FieldMetric>? Metrics { get; set; }

	/// <summary>
	/// <para>
	/// The number of bucket results that are processed on each iteration of the rollup indexer. A larger value tends
	/// to execute faster, but requires more memory during processing. This value has no effect on how the data is
	/// rolled up; it is merely used for tweaking the speed or memory cost of the indexer.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int PageSize { get; set; }

	/// <summary>
	/// <para>
	/// The index that contains the rollup results. The index can be shared with other rollup jobs. The data is stored so that it doesn’t interfere with unrelated jobs.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName RollupIndex { get; set; }

	/// <summary>
	/// <para>
	/// Time to wait for the request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get; set; }
}

/// <summary>
/// <para>
/// Create a rollup job.
/// </para>
/// <para>
/// WARNING: From 8.15.0, calling this API in a cluster with no rollup usage will fail with a message about the deprecation and planned removal of rollup features. A cluster needs to contain either a rollup job or a rollup index in order for this API to be allowed to run.
/// </para>
/// <para>
/// The rollup job configuration contains all the details about how the job should run, when it indexes documents, and what future queries will be able to run against the rollup index.
/// </para>
/// <para>
/// There are three main sections to the job configuration: the logistical details about the job (for example, the cron schedule), the fields that are used for grouping, and what metrics to collect for each group.
/// </para>
/// <para>
/// Jobs are created in a <c>STOPPED</c> state. You can start them with the start rollup jobs API.
/// </para>
/// </summary>
public readonly partial struct PutJobRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Rollup.PutJobRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutJobRequestDescriptor(Elastic.Clients.Elasticsearch.Rollup.PutJobRequest instance)
	{
		Instance = instance;
	}

	public PutJobRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequest(id);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutJobRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor(Elastic.Clients.Elasticsearch.Rollup.PutJobRequest instance) => new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.PutJobRequest(Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the rollup job. This can be any alphanumeric string and uniquely identifies the
	/// data that is associated with the rollup job. The ID is persistent; it is stored with the rolled
	/// up data. If you create a job, let it run for a while, then delete the job, the data that the job
	/// rolled up is still be associated with this job ID. You cannot create a new job with the same ID
	/// since that could lead to problems with mismatched job configurations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A cron string which defines the intervals when the rollup job should be executed. When the interval
	/// triggers, the indexer attempts to rollup the data in the index pattern. The cron pattern is unrelated
	/// to the time interval of the data being rolled up. For example, you may wish to create hourly rollups
	/// of your document but to only run the indexer on a daily basis at midnight, as defined by the cron. The
	/// cron pattern is defined just like a Watcher cron schedule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Cron(string value)
	{
		Instance.Cron = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the grouping fields and aggregations that are defined for this rollup job. These fields will then be
	/// available later for aggregating into buckets. These aggs and fields can be used in any combination. Think of
	/// the groups configuration as defining a set of tools that can later be used in aggregations to partition the
	/// data. Unlike raw data, we have to think ahead to which fields and aggregations might be used. Rollups provide
	/// enough flexibility that you simply need to determine which fields are needed, not in what order they are needed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Groups(Elastic.Clients.Elasticsearch.Rollup.Groupings value)
	{
		Instance.Groups = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the grouping fields and aggregations that are defined for this rollup job. These fields will then be
	/// available later for aggregating into buckets. These aggs and fields can be used in any combination. Think of
	/// the groups configuration as defining a set of tools that can later be used in aggregations to partition the
	/// data. Unlike raw data, we have to think ahead to which fields and aggregations might be used. Rollups provide
	/// enough flexibility that you simply need to determine which fields are needed, not in what order they are needed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Groups()
	{
		Instance.Groups = Elastic.Clients.Elasticsearch.Rollup.GroupingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the grouping fields and aggregations that are defined for this rollup job. These fields will then be
	/// available later for aggregating into buckets. These aggs and fields can be used in any combination. Think of
	/// the groups configuration as defining a set of tools that can later be used in aggregations to partition the
	/// data. Unlike raw data, we have to think ahead to which fields and aggregations might be used. Rollups provide
	/// enough flexibility that you simply need to determine which fields are needed, not in what order they are needed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Groups(System.Action<Elastic.Clients.Elasticsearch.Rollup.GroupingsDescriptor>? action)
	{
		Instance.Groups = Elastic.Clients.Elasticsearch.Rollup.GroupingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the grouping fields and aggregations that are defined for this rollup job. These fields will then be
	/// available later for aggregating into buckets. These aggs and fields can be used in any combination. Think of
	/// the groups configuration as defining a set of tools that can later be used in aggregations to partition the
	/// data. Unlike raw data, we have to think ahead to which fields and aggregations might be used. Rollups provide
	/// enough flexibility that you simply need to determine which fields are needed, not in what order they are needed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Groups<T>(System.Action<Elastic.Clients.Elasticsearch.Rollup.GroupingsDescriptor<T>>? action)
	{
		Instance.Groups = Elastic.Clients.Elasticsearch.Rollup.GroupingsDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Headers(System.Collections.Generic.IDictionary<string, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Headers = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Headers()
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Headers(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString>? action)
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor AddHeader(string key, System.Collections.Generic.ICollection<string> value)
	{
		Instance.Headers ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Headers.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor AddHeader(string key, params string[] values)
	{
		Instance.Headers ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Headers.Add(key, [.. values]);
		return this;
	}

	/// <summary>
	/// <para>
	/// The index or index pattern to roll up. Supports wildcard-style patterns (<c>logstash-*</c>). The job attempts to
	/// rollup the entire index or index-pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor IndexPattern(string value)
	{
		Instance.IndexPattern = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the metrics to collect for each grouping tuple. By default, only the doc_counts are collected for each
	/// group. To make rollup useful, you will often add metrics like averages, mins, maxes, etc. Metrics are defined
	/// on a per-field basis and for each field you configure which metric should be collected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Metrics(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Rollup.FieldMetric>? value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the metrics to collect for each grouping tuple. By default, only the doc_counts are collected for each
	/// group. To make rollup useful, you will often add metrics like averages, mins, maxes, etc. Metrics are defined
	/// on a per-field basis and for each field you configure which metric should be collected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Metrics(params Elastic.Clients.Elasticsearch.Rollup.FieldMetric[] values)
	{
		Instance.Metrics = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the metrics to collect for each grouping tuple. By default, only the doc_counts are collected for each
	/// group. To make rollup useful, you will often add metrics like averages, mins, maxes, etc. Metrics are defined
	/// on a per-field basis and for each field you configure which metric should be collected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Metrics(params System.Action<Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Rollup.FieldMetric>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor.Build(action));
		}

		Instance.Metrics = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the metrics to collect for each grouping tuple. By default, only the doc_counts are collected for each
	/// group. To make rollup useful, you will often add metrics like averages, mins, maxes, etc. Metrics are defined
	/// on a per-field basis and for each field you configure which metric should be collected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Metrics<T>(params System.Action<Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Rollup.FieldMetric>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<T>.Build(action));
		}

		Instance.Metrics = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of bucket results that are processed on each iteration of the rollup indexer. A larger value tends
	/// to execute faster, but requires more memory during processing. This value has no effect on how the data is
	/// rolled up; it is merely used for tweaking the speed or memory cost of the indexer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor PageSize(int value)
	{
		Instance.PageSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The index that contains the rollup results. The index can be shared with other rollup jobs. The data is stored so that it doesn’t interfere with unrelated jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor RollupIndex(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.RollupIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Time to wait for the request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.PutJobRequest Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor(new Elastic.Clients.Elasticsearch.Rollup.PutJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create a rollup job.
/// </para>
/// <para>
/// WARNING: From 8.15.0, calling this API in a cluster with no rollup usage will fail with a message about the deprecation and planned removal of rollup features. A cluster needs to contain either a rollup job or a rollup index in order for this API to be allowed to run.
/// </para>
/// <para>
/// The rollup job configuration contains all the details about how the job should run, when it indexes documents, and what future queries will be able to run against the rollup index.
/// </para>
/// <para>
/// There are three main sections to the job configuration: the logistical details about the job (for example, the cron schedule), the fields that are used for grouping, and what metrics to collect for each group.
/// </para>
/// <para>
/// Jobs are created in a <c>STOPPED</c> state. You can start them with the start rollup jobs API.
/// </para>
/// </summary>
public readonly partial struct PutJobRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Rollup.PutJobRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutJobRequestDescriptor(Elastic.Clients.Elasticsearch.Rollup.PutJobRequest instance)
	{
		Instance = instance;
	}

	public PutJobRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequest(id);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutJobRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Rollup.PutJobRequest instance) => new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.PutJobRequest(Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the rollup job. This can be any alphanumeric string and uniquely identifies the
	/// data that is associated with the rollup job. The ID is persistent; it is stored with the rolled
	/// up data. If you create a job, let it run for a while, then delete the job, the data that the job
	/// rolled up is still be associated with this job ID. You cannot create a new job with the same ID
	/// since that could lead to problems with mismatched job configurations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A cron string which defines the intervals when the rollup job should be executed. When the interval
	/// triggers, the indexer attempts to rollup the data in the index pattern. The cron pattern is unrelated
	/// to the time interval of the data being rolled up. For example, you may wish to create hourly rollups
	/// of your document but to only run the indexer on a daily basis at midnight, as defined by the cron. The
	/// cron pattern is defined just like a Watcher cron schedule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Cron(string value)
	{
		Instance.Cron = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the grouping fields and aggregations that are defined for this rollup job. These fields will then be
	/// available later for aggregating into buckets. These aggs and fields can be used in any combination. Think of
	/// the groups configuration as defining a set of tools that can later be used in aggregations to partition the
	/// data. Unlike raw data, we have to think ahead to which fields and aggregations might be used. Rollups provide
	/// enough flexibility that you simply need to determine which fields are needed, not in what order they are needed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Groups(Elastic.Clients.Elasticsearch.Rollup.Groupings value)
	{
		Instance.Groups = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the grouping fields and aggregations that are defined for this rollup job. These fields will then be
	/// available later for aggregating into buckets. These aggs and fields can be used in any combination. Think of
	/// the groups configuration as defining a set of tools that can later be used in aggregations to partition the
	/// data. Unlike raw data, we have to think ahead to which fields and aggregations might be used. Rollups provide
	/// enough flexibility that you simply need to determine which fields are needed, not in what order they are needed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Groups()
	{
		Instance.Groups = Elastic.Clients.Elasticsearch.Rollup.GroupingsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the grouping fields and aggregations that are defined for this rollup job. These fields will then be
	/// available later for aggregating into buckets. These aggs and fields can be used in any combination. Think of
	/// the groups configuration as defining a set of tools that can later be used in aggregations to partition the
	/// data. Unlike raw data, we have to think ahead to which fields and aggregations might be used. Rollups provide
	/// enough flexibility that you simply need to determine which fields are needed, not in what order they are needed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Groups(System.Action<Elastic.Clients.Elasticsearch.Rollup.GroupingsDescriptor<TDocument>>? action)
	{
		Instance.Groups = Elastic.Clients.Elasticsearch.Rollup.GroupingsDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Headers(System.Collections.Generic.IDictionary<string, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Headers = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Headers()
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Headers(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString>? action)
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> AddHeader(string key, System.Collections.Generic.ICollection<string> value)
	{
		Instance.Headers ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Headers.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> AddHeader(string key, params string[] values)
	{
		Instance.Headers ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Headers.Add(key, [.. values]);
		return this;
	}

	/// <summary>
	/// <para>
	/// The index or index pattern to roll up. Supports wildcard-style patterns (<c>logstash-*</c>). The job attempts to
	/// rollup the entire index or index-pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> IndexPattern(string value)
	{
		Instance.IndexPattern = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the metrics to collect for each grouping tuple. By default, only the doc_counts are collected for each
	/// group. To make rollup useful, you will often add metrics like averages, mins, maxes, etc. Metrics are defined
	/// on a per-field basis and for each field you configure which metric should be collected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Metrics(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Rollup.FieldMetric>? value)
	{
		Instance.Metrics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the metrics to collect for each grouping tuple. By default, only the doc_counts are collected for each
	/// group. To make rollup useful, you will often add metrics like averages, mins, maxes, etc. Metrics are defined
	/// on a per-field basis and for each field you configure which metric should be collected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Metrics(params Elastic.Clients.Elasticsearch.Rollup.FieldMetric[] values)
	{
		Instance.Metrics = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the metrics to collect for each grouping tuple. By default, only the doc_counts are collected for each
	/// group. To make rollup useful, you will often add metrics like averages, mins, maxes, etc. Metrics are defined
	/// on a per-field basis and for each field you configure which metric should be collected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Metrics(params System.Action<Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Rollup.FieldMetric>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Rollup.FieldMetricDescriptor<TDocument>.Build(action));
		}

		Instance.Metrics = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of bucket results that are processed on each iteration of the rollup indexer. A larger value tends
	/// to execute faster, but requires more memory during processing. This value has no effect on how the data is
	/// rolled up; it is merely used for tweaking the speed or memory cost of the indexer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> PageSize(int value)
	{
		Instance.PageSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The index that contains the rollup results. The index can be shared with other rollup jobs. The data is stored so that it doesn’t interfere with unrelated jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> RollupIndex(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.RollupIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Time to wait for the request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.PutJobRequest Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Rollup.PutJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.PutJobRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}