// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup;

public sealed partial class GetRollupCapsRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get the rollup job capabilities.
/// Get the capabilities of any rollup jobs that have been configured for a specific index or index pattern.
/// </para>
/// <para>
/// This API is useful because a rollup job is often configured to rollup only a subset of fields from the source index.
/// Furthermore, only certain aggregations can be configured for various fields, leading to a limited subset of functionality depending on that configuration.
/// This API enables you to inspect an index and determine:
/// </para>
/// <list type="number">
/// <item>
/// <para>
/// Does this index have associated rollup data somewhere in the cluster?
/// </para>
/// </item>
/// <item>
/// <para>
/// If yes to the first question, what fields were rolled up, what aggregations can be performed, and where does the data live?
/// </para>
/// </item>
/// </list>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Rollup.Json.GetRollupCapsRequestConverter))]
public sealed partial class GetRollupCapsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestParameters>
{
	public GetRollupCapsRequest(Elastic.Clients.Elasticsearch.Id? id) : base(r => r.Optional("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public GetRollupCapsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetRollupCapsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetRollupCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.RollupGetRollupCaps;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "rollup.get_rollup_caps";

	/// <summary>
	/// <para>
	/// Index, indices or index-pattern to return rollup capabilities for.
	/// <c>_all</c> may be used to fetch rollup capabilities from all jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? Id { get => P<Elastic.Clients.Elasticsearch.Id?>("id"); set => PO("id", value); }
}

/// <summary>
/// <para>
/// Get the rollup job capabilities.
/// Get the capabilities of any rollup jobs that have been configured for a specific index or index pattern.
/// </para>
/// <para>
/// This API is useful because a rollup job is often configured to rollup only a subset of fields from the source index.
/// Furthermore, only certain aggregations can be configured for various fields, leading to a limited subset of functionality depending on that configuration.
/// This API enables you to inspect an index and determine:
/// </para>
/// <list type="number">
/// <item>
/// <para>
/// Does this index have associated rollup data somewhere in the cluster?
/// </para>
/// </item>
/// <item>
/// <para>
/// If yes to the first question, what fields were rolled up, what aggregations can be performed, and where does the data live?
/// </para>
/// </item>
/// </list>
/// </summary>
public readonly partial struct GetRollupCapsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetRollupCapsRequestDescriptor(Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest instance)
	{
		Instance = instance;
	}

	public GetRollupCapsRequestDescriptor(Elastic.Clients.Elasticsearch.Id? id)
	{
		Instance = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest(id);
	}

	public GetRollupCapsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor(Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest instance) => new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest(Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Index, indices or index-pattern to return rollup capabilities for.
	/// <c>_all</c> may be used to fetch rollup capabilities from all jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor(new Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.GetRollupCapsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}