// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Rollup;

public sealed partial class DeleteJobRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Delete a rollup job.
/// </para>
/// <para>
/// A job must be stopped before it can be deleted.
/// If you attempt to delete a started job, an error occurs.
/// Similarly, if you attempt to delete a nonexistent job, an exception occurs.
/// </para>
/// <para>
/// IMPORTANT: When you delete a job, you remove only the process that is actively monitoring and rolling up data.
/// The API does not delete any previously rolled up data.
/// This is by design; a user may wish to roll up a static data set.
/// Because the data set is static, after it has been fully rolled up there is no need to keep the indexing rollup job around (as there will be no new data).
/// Thus the job can be deleted, leaving behind the rolled up data for analysis.
/// If you wish to also remove the rollup data and the rollup index contains the data for only a single job, you can delete the whole rollup index.
/// If the rollup index stores data from several jobs, you must issue a delete-by-query that targets the rollup job's identifier in the rollup index. For example:
/// </para>
/// <code>
/// POST my_rollup_index/_delete_by_query
/// {
///   "query": {
///     "term": {
///       "_rollup.id": "the_rollup_job_id"
///     }
///   }
/// }
/// </code>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Rollup.Json.DeleteJobRequestConverter))]
public sealed partial class DeleteJobRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteJobRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public DeleteJobRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DeleteJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.RollupDeleteJob;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => false;

	internal override string OperationName => "rollup.delete_job";

	/// <summary>
	/// <para>
	/// Identifier for the job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }
}

/// <summary>
/// <para>
/// Delete a rollup job.
/// </para>
/// <para>
/// A job must be stopped before it can be deleted.
/// If you attempt to delete a started job, an error occurs.
/// Similarly, if you attempt to delete a nonexistent job, an exception occurs.
/// </para>
/// <para>
/// IMPORTANT: When you delete a job, you remove only the process that is actively monitoring and rolling up data.
/// The API does not delete any previously rolled up data.
/// This is by design; a user may wish to roll up a static data set.
/// Because the data set is static, after it has been fully rolled up there is no need to keep the indexing rollup job around (as there will be no new data).
/// Thus the job can be deleted, leaving behind the rolled up data for analysis.
/// If you wish to also remove the rollup data and the rollup index contains the data for only a single job, you can delete the whole rollup index.
/// If the rollup index stores data from several jobs, you must issue a delete-by-query that targets the rollup job's identifier in the rollup index. For example:
/// </para>
/// <code>
/// POST my_rollup_index/_delete_by_query
/// {
///   "query": {
///     "term": {
///       "_rollup.id": "the_rollup_job_id"
///     }
///   }
/// }
/// </code>
/// </summary>
public readonly partial struct DeleteJobRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteJobRequestDescriptor(Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest instance)
	{
		Instance = instance;
	}

	public DeleteJobRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest(id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DeleteJobRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor(Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest instance) => new Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest(Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest Build(System.Action<Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor(new Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Rollup.DeleteJobRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}