// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

public sealed partial class ReindexRethrottleRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The throttle for this request in sub-requests per second.
	/// It can be either <c>-1</c> to turn off throttling or any decimal number like <c>1.7</c> or <c>12</c> to throttle to that level.
	/// </para>
	/// </summary>
	public float? RequestsPerSecond { get => Q<float?>("requests_per_second"); set => Q("requests_per_second", value); }
}

/// <summary>
/// <para>
/// Throttle a reindex operation.
/// </para>
/// <para>
/// Change the number of requests per second for a particular reindex operation.
/// For example:
/// </para>
/// <code>
/// POST _reindex/r1A2WoRbTwKZ516z6NEs5A:36619/_rethrottle?requests_per_second=-1
/// </code>
/// <para>
/// Rethrottling that speeds up the query takes effect immediately.
/// Rethrottling that slows down the query will take effect after completing the current batch.
/// This behavior prevents scroll timeouts.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ReindexRethrottleRequestConverter))]
public sealed partial class ReindexRethrottleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.ReindexRethrottleRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReindexRethrottleRequest(Elastic.Clients.Elasticsearch.Id taskId) : base(r => r.Required("task_id", taskId))
	{
	}
#if NET7_0_OR_GREATER
	public ReindexRethrottleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ReindexRethrottleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.NoNamespaceReindexRethrottle;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "reindex_rethrottle";

	/// <summary>
	/// <para>
	/// The task identifier, which can be found by using the tasks API.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id TaskId { get => P<Elastic.Clients.Elasticsearch.Id>("task_id"); set => PR("task_id", value); }

	/// <summary>
	/// <para>
	/// The throttle for this request in sub-requests per second.
	/// It can be either <c>-1</c> to turn off throttling or any decimal number like <c>1.7</c> or <c>12</c> to throttle to that level.
	/// </para>
	/// </summary>
	public float? RequestsPerSecond { get => Q<float?>("requests_per_second"); set => Q("requests_per_second", value); }
}

/// <summary>
/// <para>
/// Throttle a reindex operation.
/// </para>
/// <para>
/// Change the number of requests per second for a particular reindex operation.
/// For example:
/// </para>
/// <code>
/// POST _reindex/r1A2WoRbTwKZ516z6NEs5A:36619/_rethrottle?requests_per_second=-1
/// </code>
/// <para>
/// Rethrottling that speeds up the query takes effect immediately.
/// Rethrottling that slows down the query will take effect after completing the current batch.
/// This behavior prevents scroll timeouts.
/// </para>
/// </summary>
public readonly partial struct ReindexRethrottleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.ReindexRethrottleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReindexRethrottleRequestDescriptor(Elastic.Clients.Elasticsearch.ReindexRethrottleRequest instance)
	{
		Instance = instance;
	}

	public ReindexRethrottleRequestDescriptor(Elastic.Clients.Elasticsearch.Id taskId)
	{
		Instance = new Elastic.Clients.Elasticsearch.ReindexRethrottleRequest(taskId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public ReindexRethrottleRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor(Elastic.Clients.Elasticsearch.ReindexRethrottleRequest instance) => new Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.ReindexRethrottleRequest(Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The task identifier, which can be found by using the tasks API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor TaskId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.TaskId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The throttle for this request in sub-requests per second.
	/// It can be either <c>-1</c> to turn off throttling or any decimal number like <c>1.7</c> or <c>12</c> to throttle to that level.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor RequestsPerSecond(float? value)
	{
		Instance.RequestsPerSecond = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.ReindexRethrottleRequest Build(System.Action<Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor(new Elastic.Clients.Elasticsearch.ReindexRethrottleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ReindexRethrottleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}