// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ReindexResponseConverter))]
public sealed partial class ReindexResponse : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ReindexResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ReindexResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of scroll responses that were pulled back by the reindex.
	/// </para>
	/// </summary>
	public long? Batches { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were successfully created.
	/// </para>
	/// </summary>
	public long? Created { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were successfully deleted.
	/// </para>
	/// </summary>
	public long? Deleted { get; set; }

	/// <summary>
	/// <para>
	/// If there were any unrecoverable errors during the process, it is an array of those failures.
	/// If this array is not empty, the request ended because of those failures.
	/// Reindex is implemented using batches and any failure causes the entire process to end but all failures in the current batch are collected into the array.
	/// You can use the <c>conflicts</c> option to prevent the reindex from ending on version conflicts.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.BulkIndexByScrollFailure>? Failures { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were ignored because the script used for the reindex returned a <c>noop</c> value for <c>ctx.op</c>.
	/// </para>
	/// </summary>
	public long? Noops { get; set; }

	/// <summary>
	/// <para>
	/// The number of requests per second effectively run during the reindex.
	/// </para>
	/// </summary>
	public float? RequestsPerSecond { get; set; }

	/// <summary>
	/// <para>
	/// The number of retries attempted by reindex.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Retries? Retries { get; set; }
	public int? SliceId { get; set; }
	public Elastic.Clients.Elasticsearch.TaskId? Task { get; set; }

	/// <summary>
	/// <para>
	/// The number of milliseconds the request slept to conform to <c>requests_per_second</c>.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? ThrottledMillis { get; set; }

	/// <summary>
	/// <para>
	/// This field should always be equal to zero in a reindex response.
	/// It has meaning only when using the task API, where it indicates the next time (in milliseconds since epoch) that a throttled request will be run again in order to conform to <c>requests_per_second</c>.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? ThrottledUntilMillis { get; set; }

	/// <summary>
	/// <para>
	/// If any of the requests that ran during the reindex timed out, it is <c>true</c>.
	/// </para>
	/// </summary>
	public bool? TimedOut { get; set; }

	/// <summary>
	/// <para>
	/// The total milliseconds the entire operation took.
	/// </para>
	/// </summary>
	public System.TimeSpan? Took { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were successfully processed.
	/// </para>
	/// </summary>
	public long? Total { get; set; }

	/// <summary>
	/// <para>
	/// The number of documents that were successfully updated.
	/// That is to say, a document with the same ID already existed before the reindex updated it.
	/// </para>
	/// </summary>
	public long? Updated { get; set; }

	/// <summary>
	/// <para>
	/// The number of version conflicts that occurred.
	/// </para>
	/// </summary>
	public long? VersionConflicts { get; set; }
}