// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

public sealed partial class RankEvalRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// Search operation type
	/// </para>
	/// </summary>
	public string? SearchType { get => Q<string?>("search_type"); set => Q("search_type", value); }
}

/// <summary>
/// <para>
/// Evaluate ranked search results.
/// </para>
/// <para>
/// Evaluate the quality of ranked search results over a set of typical search queries.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.RankEvalRequestConverter))]
public sealed partial class RankEvalRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.RankEvalRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequest(Elastic.Clients.Elasticsearch.Indices? indices) : base(r => r.Optional("index", indices))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequest(Elastic.Clients.Elasticsearch.Indices? indices, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem> requests) : base(r => r.Optional("index", indices))
	{
		Requests = requests;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequest(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem> requests)
	{
		Requests = requests;
	}
#if NET7_0_OR_GREATER
	public RankEvalRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RankEvalRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RankEvalRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.NoNamespaceRankEval;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "rank_eval";

	/// <summary>
	/// <para>
	/// A  comma-separated list of data streams, indices, and index aliases used to limit the request.
	/// Wildcard (<c>*</c>) expressions are supported.
	/// To target all data streams and indices in a cluster, omit this parameter or use <c>_all</c> or <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? Indices { get => P<Elastic.Clients.Elasticsearch.Indices?>("index"); set => PO("index", value); }

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// Search operation type
	/// </para>
	/// </summary>
	public string? SearchType { get => Q<string?>("search_type"); set => Q("search_type", value); }

	/// <summary>
	/// <para>
	/// Definition of the evaluation metric to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetric? Metric { get; set; }

	/// <summary>
	/// <para>
	/// A set of typical search requests, together with their provided ratings.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem> Requests { get; set; }
}

/// <summary>
/// <para>
/// Evaluate ranked search results.
/// </para>
/// <para>
/// Evaluate the quality of ranked search results over a set of typical search queries.
/// </para>
/// </summary>
public readonly partial struct RankEvalRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.RankEvalRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequestDescriptor(Elastic.Clients.Elasticsearch.RankEvalRequest instance)
	{
		Instance = instance;
	}

	public RankEvalRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.RankEvalRequest(indices);
#pragma warning restore CS0618
	}

	public RankEvalRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.RankEvalRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor(Elastic.Clients.Elasticsearch.RankEvalRequest instance) => new Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.RankEvalRequest(Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A  comma-separated list of data streams, indices, and index aliases used to limit the request.
	/// Wildcard (<c>*</c>) expressions are supported.
	/// To target all data streams and indices in a cluster, omit this parameter or use <c>_all</c> or <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Search operation type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor SearchType(string? value)
	{
		Instance.SearchType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Definition of the evaluation metric to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Metric(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetric? value)
	{
		Instance.Metric = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Definition of the evaluation metric to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Metric()
	{
		Instance.Metric = Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Definition of the evaluation metric to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Metric(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricDescriptor>? action)
	{
		Instance.Metric = Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A set of typical search requests, together with their provided ratings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Requests(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem> value)
	{
		Instance.Requests = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A set of typical search requests, together with their provided ratings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Requests(params Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem[] values)
	{
		Instance.Requests = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A set of typical search requests, together with their provided ratings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Requests(params System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor.Build(action));
		}

		Instance.Requests = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A set of typical search requests, together with their provided ratings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Requests<T>(params System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<T>.Build(action));
		}

		Instance.Requests = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.RankEvalRequest Build(System.Action<Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor(new Elastic.Clients.Elasticsearch.RankEvalRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Evaluate ranked search results.
/// </para>
/// <para>
/// Evaluate the quality of ranked search results over a set of typical search queries.
/// </para>
/// </summary>
public readonly partial struct RankEvalRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.RankEvalRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RankEvalRequestDescriptor(Elastic.Clients.Elasticsearch.RankEvalRequest instance)
	{
		Instance = instance;
	}

	public RankEvalRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.RankEvalRequest(indices);
#pragma warning restore CS0618
	}

	public RankEvalRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.RankEvalRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.RankEvalRequest instance) => new Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.RankEvalRequest(Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A  comma-separated list of data streams, indices, and index aliases used to limit the request.
	/// Wildcard (<c>*</c>) expressions are supported.
	/// To target all data streams and indices in a cluster, omit this parameter or use <c>_all</c> or <c>*</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Search operation type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> SearchType(string? value)
	{
		Instance.SearchType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Definition of the evaluation metric to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> Metric(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetric? value)
	{
		Instance.Metric = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Definition of the evaluation metric to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> Metric()
	{
		Instance.Metric = Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Definition of the evaluation metric to calculate.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> Metric(System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricDescriptor>? action)
	{
		Instance.Metric = Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalMetricDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A set of typical search requests, together with their provided ratings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> Requests(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem> value)
	{
		Instance.Requests = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A set of typical search requests, together with their provided ratings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> Requests(params Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem[] values)
	{
		Instance.Requests = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A set of typical search requests, together with their provided ratings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> Requests(params System.Action<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItem>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.RankEval.RankEvalRequestItemDescriptor<TDocument>.Build(action));
		}

		Instance.Requests = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.RankEvalRequest Build(System.Action<Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.RankEvalRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.RankEvalRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}