// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules;

public sealed partial class TestRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Test a query ruleset.
/// Evaluate match criteria against a query ruleset to identify the rules that would match that criteria.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryRules.Json.TestRequestConverter))]
public sealed partial class TestRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.QueryRules.TestRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TestRequest(Elastic.Clients.Elasticsearch.Id rulesetId) : base(r => r.Required("ruleset_id", rulesetId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TestRequest(Elastic.Clients.Elasticsearch.Id rulesetId, System.Collections.Generic.IDictionary<string, object> matchCriteria) : base(r => r.Required("ruleset_id", rulesetId))
	{
		MatchCriteria = matchCriteria;
	}
#if NET7_0_OR_GREATER
	public TestRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TestRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.QueryRulesTest;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "query_rules.test";

	/// <summary>
	/// <para>
	/// The unique identifier of the query ruleset to be created or updated
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id RulesetId { get => P<Elastic.Clients.Elasticsearch.Id>("ruleset_id"); set => PR("ruleset_id", value); }

	/// <summary>
	/// <para>
	/// The match criteria to apply to rules in the given query ruleset.
	/// Match criteria should match the keys defined in the <c>criteria.metadata</c> field of the rule.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IDictionary<string, object> MatchCriteria { get; set; }
}

/// <summary>
/// <para>
/// Test a query ruleset.
/// Evaluate match criteria against a query ruleset to identify the rules that would match that criteria.
/// </para>
/// </summary>
public readonly partial struct TestRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryRules.TestRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TestRequestDescriptor(Elastic.Clients.Elasticsearch.QueryRules.TestRequest instance)
	{
		Instance = instance;
	}

	public TestRequestDescriptor(Elastic.Clients.Elasticsearch.Id rulesetId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.QueryRules.TestRequest(rulesetId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public TestRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor(Elastic.Clients.Elasticsearch.QueryRules.TestRequest instance) => new Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryRules.TestRequest(Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the query ruleset to be created or updated
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor RulesetId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.RulesetId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The match criteria to apply to rules in the given query ruleset.
	/// Match criteria should match the keys defined in the <c>criteria.metadata</c> field of the rule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor MatchCriteria(System.Collections.Generic.IDictionary<string, object> value)
	{
		Instance.MatchCriteria = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The match criteria to apply to rules in the given query ruleset.
	/// Match criteria should match the keys defined in the <c>criteria.metadata</c> field of the rule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor MatchCriteria()
	{
		Instance.MatchCriteria = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The match criteria to apply to rules in the given query ruleset.
	/// Match criteria should match the keys defined in the <c>criteria.metadata</c> field of the rule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor MatchCriteria(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.MatchCriteria = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor AddMatchCriterion(string key, object value)
	{
		Instance.MatchCriteria ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.MatchCriteria.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryRules.TestRequest Build(System.Action<Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor(new Elastic.Clients.Elasticsearch.QueryRules.TestRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.TestRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}