// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules;

public sealed partial class PutRuleRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Create or update a query rule.
/// Create or update a query rule within a query ruleset.
/// </para>
/// <para>
/// IMPORTANT: Due to limitations within pinned queries, you can only pin documents using ids or docs, but cannot use both in single rule.
/// It is advised to use one or the other in query rulesets, to avoid errors.
/// Additionally, pinned queries have a maximum limit of 100 pinned hits.
/// If multiple matching rules pin more than 100 documents, only the first 100 documents are pinned in the order they are specified in the ruleset.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryRules.Json.PutRuleRequestConverter))]
public sealed partial class PutRuleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutRuleRequest(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId) : base(r => r.Required("ruleset_id", rulesetId).Required("rule_id", ruleId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutRuleRequest(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId, Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActions actions, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria> criteria, Elastic.Clients.Elasticsearch.QueryRules.QueryRuleType type) : base(r => r.Required("ruleset_id", rulesetId).Required("rule_id", ruleId))
	{
		Actions = actions;
		Criteria = criteria;
		Type = type;
	}
#if NET7_0_OR_GREATER
	public PutRuleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutRuleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.QueryRulesPutRule;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "query_rules.put_rule";

	/// <summary>
	/// <para>
	/// The unique identifier of the query rule within the specified ruleset to be created or updated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id RuleId { get => P<Elastic.Clients.Elasticsearch.Id>("rule_id"); set => PR("rule_id", value); }

	/// <summary>
	/// <para>
	/// The unique identifier of the query ruleset containing the rule to be created or updated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id RulesetId { get => P<Elastic.Clients.Elasticsearch.Id>("ruleset_id"); set => PR("ruleset_id", value); }

	/// <summary>
	/// <para>
	/// The actions to take when the rule is matched.
	/// The format of this action depends on the rule type.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActions Actions { get; set; }

	/// <summary>
	/// <para>
	/// The criteria that must be met for the rule to be applied.
	/// If multiple criteria are specified for a rule, all criteria must be met for the rule to be applied.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria> Criteria { get; set; }
	public int? Priority { get; set; }

	/// <summary>
	/// <para>
	/// The type of rule.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryRules.QueryRuleType Type { get; set; }
}

/// <summary>
/// <para>
/// Create or update a query rule.
/// Create or update a query rule within a query ruleset.
/// </para>
/// <para>
/// IMPORTANT: Due to limitations within pinned queries, you can only pin documents using ids or docs, but cannot use both in single rule.
/// It is advised to use one or the other in query rulesets, to avoid errors.
/// Additionally, pinned queries have a maximum limit of 100 pinned hits.
/// If multiple matching rules pin more than 100 documents, only the first 100 documents are pinned in the order they are specified in the ruleset.
/// </para>
/// </summary>
public readonly partial struct PutRuleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutRuleRequestDescriptor(Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest instance)
	{
		Instance = instance;
	}

	public PutRuleRequestDescriptor(Elastic.Clients.Elasticsearch.Id rulesetId, Elastic.Clients.Elasticsearch.Id ruleId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest(rulesetId, ruleId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutRuleRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor(Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest instance) => new Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest(Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the query rule within the specified ruleset to be created or updated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor RuleId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.RuleId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The unique identifier of the query ruleset containing the rule to be created or updated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor RulesetId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.RulesetId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The actions to take when the rule is matched.
	/// The format of this action depends on the rule type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Actions(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActions value)
	{
		Instance.Actions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The actions to take when the rule is matched.
	/// The format of this action depends on the rule type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Actions()
	{
		Instance.Actions = Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActionsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The actions to take when the rule is matched.
	/// The format of this action depends on the rule type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Actions(System.Action<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActionsDescriptor>? action)
	{
		Instance.Actions = Elastic.Clients.Elasticsearch.QueryRules.QueryRuleActionsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The criteria that must be met for the rule to be applied.
	/// If multiple criteria are specified for a rule, all criteria must be met for the rule to be applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Criteria(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria> value)
	{
		Instance.Criteria = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The criteria that must be met for the rule to be applied.
	/// If multiple criteria are specified for a rule, all criteria must be met for the rule to be applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Criteria(params Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria[] values)
	{
		Instance.Criteria = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The criteria that must be met for the rule to be applied.
	/// If multiple criteria are specified for a rule, all criteria must be met for the rule to be applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Criteria(params System.Action<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteria>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleCriteriaDescriptor.Build(action));
		}

		Instance.Criteria = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Priority(int? value)
	{
		Instance.Priority = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of rule.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Type(Elastic.Clients.Elasticsearch.QueryRules.QueryRuleType value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest Build(System.Action<Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor(new Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.PutRuleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}