// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules;

public sealed partial class ListRulesetsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The offset from the first result to fetch.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// The maximum number of results to retrieve.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }
}

/// <summary>
/// <para>
/// Get all query rulesets.
/// Get summarized information about the query rulesets.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryRules.Json.ListRulesetsRequestConverter))]
public sealed partial class ListRulesetsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestParameters>
{
#if NET7_0_OR_GREATER
	public ListRulesetsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ListRulesetsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ListRulesetsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.QueryRulesListRulesets;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "query_rules.list_rulesets";

	/// <summary>
	/// <para>
	/// The offset from the first result to fetch.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// The maximum number of results to retrieve.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }
}

/// <summary>
/// <para>
/// Get all query rulesets.
/// Get summarized information about the query rulesets.
/// </para>
/// </summary>
public readonly partial struct ListRulesetsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ListRulesetsRequestDescriptor(Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest instance)
	{
		Instance = instance;
	}

	public ListRulesetsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor(Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest instance) => new Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest(Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The offset from the first result to fetch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of results to retrieve.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest Build(System.Action<Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor(new Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.ListRulesetsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}