// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryRules;

public sealed partial class GetRulesetRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get a query ruleset.
/// Get details about a query ruleset.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryRules.Json.GetRulesetRequestConverter))]
public sealed partial class GetRulesetRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetRulesetRequest(Elastic.Clients.Elasticsearch.Id rulesetId) : base(r => r.Required("ruleset_id", rulesetId))
	{
	}
#if NET7_0_OR_GREATER
	public GetRulesetRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetRulesetRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.QueryRulesGetRuleset;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "query_rules.get_ruleset";

	/// <summary>
	/// <para>
	/// The unique identifier of the query ruleset
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id RulesetId { get => P<Elastic.Clients.Elasticsearch.Id>("ruleset_id"); set => PR("ruleset_id", value); }
}

/// <summary>
/// <para>
/// Get a query ruleset.
/// Get details about a query ruleset.
/// </para>
/// </summary>
public readonly partial struct GetRulesetRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetRulesetRequestDescriptor(Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest instance)
	{
		Instance = instance;
	}

	public GetRulesetRequestDescriptor(Elastic.Clients.Elasticsearch.Id rulesetId)
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest(rulesetId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetRulesetRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor(Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest instance) => new Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest(Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the query ruleset
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor RulesetId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.RulesetId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest Build(System.Action<Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor(new Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryRules.GetRulesetRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}