// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

public sealed partial class PutScriptRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// It can also be set to <c>-1</c> to indicate that the request should never timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// It can also be set to <c>-1</c> to indicate that the request should never timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Create or update a script or search template.
/// Creates or updates a stored script or search template.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.PutScriptRequestConverter))]
public sealed partial class PutScriptRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.PutScriptRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutScriptRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}

	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutScriptRequest(Elastic.Clients.Elasticsearch.Id id, Elastic.Clients.Elasticsearch.Name? context) : base(r => r.Required("id", id).Optional("context", context))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutScriptRequest(Elastic.Clients.Elasticsearch.Id id, Elastic.Clients.Elasticsearch.StoredScript script) : base(r => r.Required("id", id))
	{
		Script = script;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutScriptRequest(Elastic.Clients.Elasticsearch.Id id, Elastic.Clients.Elasticsearch.Name? context, Elastic.Clients.Elasticsearch.StoredScript script) : base(r => r.Required("id", id).Optional("context", context))
	{
		Script = script;
	}
#if NET7_0_OR_GREATER
	public PutScriptRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutScriptRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.NoNamespacePutScript;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "put_script";

	/// <summary>
	/// <para>
	/// The context in which the script or search template should run.
	/// To prevent errors, the API immediately compiles the script or template in this context.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Name? Context { get => P<Elastic.Clients.Elasticsearch.Name?>("context"); set => PO("context", value); }

	/// <summary>
	/// <para>
	/// The identifier for the stored script or search template.
	/// It must be unique within the cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// It can also be set to <c>-1</c> to indicate that the request should never timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// It can also be set to <c>-1</c> to indicate that the request should never timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// The script or search template, its parameters, and its language.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.StoredScript Script { get; set; }
}

/// <summary>
/// <para>
/// Create or update a script or search template.
/// Creates or updates a stored script or search template.
/// </para>
/// </summary>
public readonly partial struct PutScriptRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.PutScriptRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutScriptRequestDescriptor(Elastic.Clients.Elasticsearch.PutScriptRequest instance)
	{
		Instance = instance;
	}

	public PutScriptRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.PutScriptRequest(id);
#pragma warning restore CS0618
	}

	public PutScriptRequestDescriptor(Elastic.Clients.Elasticsearch.Id id, Elastic.Clients.Elasticsearch.Name? context)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.PutScriptRequest(id, context);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutScriptRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor(Elastic.Clients.Elasticsearch.PutScriptRequest instance) => new Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.PutScriptRequest(Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The context in which the script or search template should run.
	/// To prevent errors, the API immediately compiles the script or template in this context.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor Context(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Context = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The identifier for the stored script or search template.
	/// It must be unique within the cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// It can also be set to <c>-1</c> to indicate that the request should never timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// It can also be set to <c>-1</c> to indicate that the request should never timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The script or search template, its parameters, and its language.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor Script(Elastic.Clients.Elasticsearch.StoredScript value)
	{
		Instance.Script = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The script or search template, its parameters, and its language.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor Script(System.Action<Elastic.Clients.Elasticsearch.StoredScriptDescriptor> action)
	{
		Instance.Script = Elastic.Clients.Elasticsearch.StoredScriptDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.PutScriptRequest Build(System.Action<Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor(new Elastic.Clients.Elasticsearch.PutScriptRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PutScriptRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}