// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class ValidateDetectorRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Validate an anomaly detection job.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.ValidateDetectorRequestConverter))]
public sealed partial class ValidateDetectorRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ValidateDetectorRequest(Elastic.Clients.Elasticsearch.MachineLearning.Detector detector)
	{
		Detector = detector;
	}
#if NET7_0_OR_GREATER
	public ValidateDetectorRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ValidateDetectorRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ValidateDetectorRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningValidateDetector;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.validate_detector";

	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.Detector Detector { get; set; }
}

/// <summary>
/// <para>
/// Validate an anomaly detection job.
/// </para>
/// </summary>
public readonly partial struct ValidateDetectorRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ValidateDetectorRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest instance)
	{
		Instance = instance;
	}

	public ValidateDetectorRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest(Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor Detector(Elastic.Clients.Elasticsearch.MachineLearning.Detector value)
	{
		Instance.Detector = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor Detector()
	{
		Instance.Detector = Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor Detector(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor>? action)
	{
		Instance.Detector = Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor Detector<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor<T>>? action)
	{
		Instance.Detector = Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Validate an anomaly detection job.
/// </para>
/// </summary>
public readonly partial struct ValidateDetectorRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ValidateDetectorRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest instance)
	{
		Instance = instance;
	}

	public ValidateDetectorRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest(Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> Detector(Elastic.Clients.Elasticsearch.MachineLearning.Detector value)
	{
		Instance.Detector = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> Detector()
	{
		Instance.Detector = Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> Detector(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor<TDocument>>? action)
	{
		Instance.Detector = Elastic.Clients.Elasticsearch.MachineLearning.DetectorDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ValidateDetectorRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}