// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class UpgradeJobSnapshotRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Controls the time to wait for the request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// When true, the API won’t respond until the upgrade is complete.
	/// Otherwise, it responds as soon as the upgrade task is assigned to a node.
	/// </para>
	/// </summary>
	public bool? WaitForCompletion { get => Q<bool?>("wait_for_completion"); set => Q("wait_for_completion", value); }
}

/// <summary>
/// <para>
/// Upgrade a snapshot.
/// Upgrade an anomaly detection model snapshot to the latest major version.
/// Over time, older snapshot formats are deprecated and removed. Anomaly
/// detection jobs support only snapshots that are from the current or previous
/// major version.
/// This API provides a means to upgrade a snapshot to the current major version.
/// This aids in preparing the cluster for an upgrade to the next major version.
/// Only one snapshot per anomaly detection job can be upgraded at a time and the
/// upgraded snapshot cannot be the current snapshot of the anomaly detection
/// job.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.UpgradeJobSnapshotRequestConverter))]
public sealed partial class UpgradeJobSnapshotRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpgradeJobSnapshotRequest(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId) : base(r => r.Required("job_id", jobId).Required("snapshot_id", snapshotId))
	{
	}
#if NET7_0_OR_GREATER
	public UpgradeJobSnapshotRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpgradeJobSnapshotRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningUpgradeJobSnapshot;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "ml.upgrade_job_snapshot";

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id JobId { get => P<Elastic.Clients.Elasticsearch.Id>("job_id"); set => PR("job_id", value); }

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the model snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id SnapshotId { get => P<Elastic.Clients.Elasticsearch.Id>("snapshot_id"); set => PR("snapshot_id", value); }

	/// <summary>
	/// <para>
	/// Controls the time to wait for the request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// When true, the API won’t respond until the upgrade is complete.
	/// Otherwise, it responds as soon as the upgrade task is assigned to a node.
	/// </para>
	/// </summary>
	public bool? WaitForCompletion { get => Q<bool?>("wait_for_completion"); set => Q("wait_for_completion", value); }
}

/// <summary>
/// <para>
/// Upgrade a snapshot.
/// Upgrade an anomaly detection model snapshot to the latest major version.
/// Over time, older snapshot formats are deprecated and removed. Anomaly
/// detection jobs support only snapshots that are from the current or previous
/// major version.
/// This API provides a means to upgrade a snapshot to the current major version.
/// This aids in preparing the cluster for an upgrade to the next major version.
/// Only one snapshot per anomaly detection job can be upgraded at a time and the
/// upgraded snapshot cannot be the current snapshot of the anomaly detection
/// job.
/// </para>
/// </summary>
public readonly partial struct UpgradeJobSnapshotRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpgradeJobSnapshotRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest instance)
	{
		Instance = instance;
	}

	public UpgradeJobSnapshotRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id snapshotId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest(jobId, snapshotId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpgradeJobSnapshotRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest(Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the model snapshot.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor SnapshotId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.SnapshotId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls the time to wait for the request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When true, the API won’t respond until the upgrade is complete.
	/// Otherwise, it responds as soon as the upgrade task is assigned to a node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor WaitForCompletion(bool? value = true)
	{
		Instance.WaitForCompletion = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpgradeJobSnapshotRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}