// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class UpdateJobRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Update an anomaly detection job.
/// Updates certain properties of an anomaly detection job.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.UpdateJobRequestConverter))]
public sealed partial class UpdateJobRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateJobRequest(Elastic.Clients.Elasticsearch.Id jobId) : base(r => r.Required("job_id", jobId))
	{
	}
#if NET7_0_OR_GREATER
	public UpdateJobRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdateJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningUpdateJob;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.update_job";

	/// <summary>
	/// <para>
	/// Identifier for the job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id JobId { get => P<Elastic.Clients.Elasticsearch.Id>("job_id"); set => PR("job_id", value); }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies whether this job can open when
	/// there is insufficient machine learning node capacity for it to be
	/// immediately assigned to a node. If <c>false</c> and a machine learning node
	/// with capacity to run the job cannot immediately be found, the open
	/// anomaly detection jobs API returns an error. However, this is also
	/// subject to the cluster-wide <c>xpack.ml.max_lazy_ml_nodes</c> setting. If this
	/// option is set to <c>true</c>, the open anomaly detection jobs API does not
	/// return an error and the job waits in the opening state until sufficient
	/// machine learning node capacity is available.
	/// </para>
	/// </summary>
	public bool? AllowLazyOpen { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisMemoryLimit? AnalysisLimits { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. The time between each periodic persistence
	/// of the model.
	/// The default value is a randomized value between 3 to 4 hours, which
	/// avoids all jobs persisting at exactly the same time. The smallest allowed
	/// value is 1 hour.
	/// For very large models (several GB), persistence could take 10-20 minutes,
	/// so do not set the value too low.
	/// If the job is open when you make the update, you must stop the datafeed,
	/// close the job, then reopen the job and restart the datafeed for the
	/// changes to take effect.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? BackgroundPersistInterval { get; set; }
	public System.Collections.Generic.ICollection<string>? CategorizationFilters { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. Contains custom meta data about the job.
	/// For example, it can contain custom URL information as shown in Adding
	/// custom URLs to machine learning results.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? CustomSettings { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option, which affects the automatic removal of old
	/// model snapshots for this job. It specifies a period of time (in days)
	/// after which only the first snapshot per day is retained. This period is
	/// relative to the timestamp of the most recent snapshot for this job. Valid
	/// values range from 0 to <c>model_snapshot_retention_days</c>. For jobs created
	/// before version 7.8.0, the default value matches
	/// <c>model_snapshot_retention_days</c>.
	/// </para>
	/// </summary>
	public long? DailyModelSnapshotRetentionAfterDays { get; set; }

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// An array of detector update objects.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate>? Detectors { get; set; }

	/// <summary>
	/// <para>
	/// A list of job groups. A job can belong to no groups or many.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Groups { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig? ModelPlotConfig { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? ModelPruneWindow { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option, which affects the automatic removal of old
	/// model snapshots for this job. It specifies the maximum period of time (in
	/// days) that snapshots are retained. This period is relative to the
	/// timestamp of the most recent snapshot for this job.
	/// </para>
	/// </summary>
	public long? ModelSnapshotRetentionDays { get; set; }

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization? PerPartitionCategorization { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. The period over which adjustments to the
	/// score are applied, as new data is seen.
	/// </para>
	/// </summary>
	public long? RenormalizationWindowDays { get; set; }

	/// <summary>
	/// <para>
	/// Advanced configuration option. The period of time (in days) that results
	/// are retained. Age is calculated relative to the timestamp of the latest
	/// bucket result. If this property has a non-null value, once per day at
	/// 00:30 (server time), results that are the specified number of days older
	/// than the latest bucket result are deleted from Elasticsearch. The default
	/// value is null, which means all results are retained.
	/// </para>
	/// </summary>
	public long? ResultsRetentionDays { get; set; }
}

/// <summary>
/// <para>
/// Update an anomaly detection job.
/// Updates certain properties of an anomaly detection job.
/// </para>
/// </summary>
public readonly partial struct UpdateJobRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateJobRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest instance)
	{
		Instance = instance;
	}

	public UpdateJobRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest(jobId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateJobRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest(Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies whether this job can open when
	/// there is insufficient machine learning node capacity for it to be
	/// immediately assigned to a node. If <c>false</c> and a machine learning node
	/// with capacity to run the job cannot immediately be found, the open
	/// anomaly detection jobs API returns an error. However, this is also
	/// subject to the cluster-wide <c>xpack.ml.max_lazy_ml_nodes</c> setting. If this
	/// option is set to <c>true</c>, the open anomaly detection jobs API does not
	/// return an error and the job waits in the opening state until sufficient
	/// machine learning node capacity is available.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor AllowLazyOpen(bool? value = true)
	{
		Instance.AllowLazyOpen = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor AnalysisLimits(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisMemoryLimit? value)
	{
		Instance.AnalysisLimits = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor AnalysisLimits(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AnalysisMemoryLimitDescriptor> action)
	{
		Instance.AnalysisLimits = Elastic.Clients.Elasticsearch.MachineLearning.AnalysisMemoryLimitDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. The time between each periodic persistence
	/// of the model.
	/// The default value is a randomized value between 3 to 4 hours, which
	/// avoids all jobs persisting at exactly the same time. The smallest allowed
	/// value is 1 hour.
	/// For very large models (several GB), persistence could take 10-20 minutes,
	/// so do not set the value too low.
	/// If the job is open when you make the update, you must stop the datafeed,
	/// close the job, then reopen the job and restart the datafeed for the
	/// changes to take effect.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor BackgroundPersistInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.BackgroundPersistInterval = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor CategorizationFilters(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.CategorizationFilters = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor CategorizationFilters(params string[] values)
	{
		Instance.CategorizationFilters = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Contains custom meta data about the job.
	/// For example, it can contain custom URL information as shown in Adding
	/// custom URLs to machine learning results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor CustomSettings(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.CustomSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Contains custom meta data about the job.
	/// For example, it can contain custom URL information as shown in Adding
	/// custom URLs to machine learning results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor CustomSettings()
	{
		Instance.CustomSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Contains custom meta data about the job.
	/// For example, it can contain custom URL information as shown in Adding
	/// custom URLs to machine learning results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor CustomSettings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.CustomSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor AddCustomSetting(string key, object value)
	{
		Instance.CustomSettings ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.CustomSettings.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option, which affects the automatic removal of old
	/// model snapshots for this job. It specifies a period of time (in days)
	/// after which only the first snapshot per day is retained. This period is
	/// relative to the timestamp of the most recent snapshot for this job. Valid
	/// values range from 0 to <c>model_snapshot_retention_days</c>. For jobs created
	/// before version 7.8.0, the default value matches
	/// <c>model_snapshot_retention_days</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor DailyModelSnapshotRetentionAfterDays(long? value)
	{
		Instance.DailyModelSnapshotRetentionAfterDays = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of detector update objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor Detectors(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate>? value)
	{
		Instance.Detectors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of detector update objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor Detectors(params Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate[] values)
	{
		Instance.Detectors = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of detector update objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor Detectors(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor.Build(action));
		}

		Instance.Detectors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of detector update objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor Detectors<T>(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<T>.Build(action));
		}

		Instance.Detectors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of job groups. A job can belong to no groups or many.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor Groups(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Groups = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of job groups. A job can belong to no groups or many.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor Groups(params string[] values)
	{
		Instance.Groups = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor ModelPlotConfig(Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig? value)
	{
		Instance.ModelPlotConfig = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor ModelPlotConfig()
	{
		Instance.ModelPlotConfig = Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor ModelPlotConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor>? action)
	{
		Instance.ModelPlotConfig = Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor ModelPlotConfig<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<T>>? action)
	{
		Instance.ModelPlotConfig = Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor ModelPruneWindow(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.ModelPruneWindow = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option, which affects the automatic removal of old
	/// model snapshots for this job. It specifies the maximum period of time (in
	/// days) that snapshots are retained. This period is relative to the
	/// timestamp of the most recent snapshot for this job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor ModelSnapshotRetentionDays(long? value)
	{
		Instance.ModelSnapshotRetentionDays = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor PerPartitionCategorization(Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization? value)
	{
		Instance.PerPartitionCategorization = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor PerPartitionCategorization()
	{
		Instance.PerPartitionCategorization = Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor PerPartitionCategorization(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor>? action)
	{
		Instance.PerPartitionCategorization = Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. The period over which adjustments to the
	/// score are applied, as new data is seen.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor RenormalizationWindowDays(long? value)
	{
		Instance.RenormalizationWindowDays = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. The period of time (in days) that results
	/// are retained. Age is calculated relative to the timestamp of the latest
	/// bucket result. If this property has a non-null value, once per day at
	/// 00:30 (server time), results that are the specified number of days older
	/// than the latest bucket result are deleted from Elasticsearch. The default
	/// value is null, which means all results are retained.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor ResultsRetentionDays(long? value)
	{
		Instance.ResultsRetentionDays = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Update an anomaly detection job.
/// Updates certain properties of an anomaly detection job.
/// </para>
/// </summary>
public readonly partial struct UpdateJobRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateJobRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest instance)
	{
		Instance = instance;
	}

	public UpdateJobRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest(jobId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateJobRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest(Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Specifies whether this job can open when
	/// there is insufficient machine learning node capacity for it to be
	/// immediately assigned to a node. If <c>false</c> and a machine learning node
	/// with capacity to run the job cannot immediately be found, the open
	/// anomaly detection jobs API returns an error. However, this is also
	/// subject to the cluster-wide <c>xpack.ml.max_lazy_ml_nodes</c> setting. If this
	/// option is set to <c>true</c>, the open anomaly detection jobs API does not
	/// return an error and the job waits in the opening state until sufficient
	/// machine learning node capacity is available.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> AllowLazyOpen(bool? value = true)
	{
		Instance.AllowLazyOpen = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> AnalysisLimits(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisMemoryLimit? value)
	{
		Instance.AnalysisLimits = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> AnalysisLimits(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AnalysisMemoryLimitDescriptor> action)
	{
		Instance.AnalysisLimits = Elastic.Clients.Elasticsearch.MachineLearning.AnalysisMemoryLimitDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. The time between each periodic persistence
	/// of the model.
	/// The default value is a randomized value between 3 to 4 hours, which
	/// avoids all jobs persisting at exactly the same time. The smallest allowed
	/// value is 1 hour.
	/// For very large models (several GB), persistence could take 10-20 minutes,
	/// so do not set the value too low.
	/// If the job is open when you make the update, you must stop the datafeed,
	/// close the job, then reopen the job and restart the datafeed for the
	/// changes to take effect.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> BackgroundPersistInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.BackgroundPersistInterval = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> CategorizationFilters(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.CategorizationFilters = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> CategorizationFilters(params string[] values)
	{
		Instance.CategorizationFilters = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Contains custom meta data about the job.
	/// For example, it can contain custom URL information as shown in Adding
	/// custom URLs to machine learning results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> CustomSettings(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.CustomSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Contains custom meta data about the job.
	/// For example, it can contain custom URL information as shown in Adding
	/// custom URLs to machine learning results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> CustomSettings()
	{
		Instance.CustomSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. Contains custom meta data about the job.
	/// For example, it can contain custom URL information as shown in Adding
	/// custom URLs to machine learning results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> CustomSettings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.CustomSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> AddCustomSetting(string key, object value)
	{
		Instance.CustomSettings ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.CustomSettings.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option, which affects the automatic removal of old
	/// model snapshots for this job. It specifies a period of time (in days)
	/// after which only the first snapshot per day is retained. This period is
	/// relative to the timestamp of the most recent snapshot for this job. Valid
	/// values range from 0 to <c>model_snapshot_retention_days</c>. For jobs created
	/// before version 7.8.0, the default value matches
	/// <c>model_snapshot_retention_days</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> DailyModelSnapshotRetentionAfterDays(long? value)
	{
		Instance.DailyModelSnapshotRetentionAfterDays = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of detector update objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> Detectors(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate>? value)
	{
		Instance.Detectors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of detector update objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> Detectors(params Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate[] values)
	{
		Instance.Detectors = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of detector update objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> Detectors(params System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdate>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.MachineLearning.DetectorUpdateDescriptor<TDocument>.Build(action));
		}

		Instance.Detectors = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of job groups. A job can belong to no groups or many.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> Groups(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Groups = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of job groups. A job can belong to no groups or many.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> Groups(params string[] values)
	{
		Instance.Groups = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> ModelPlotConfig(Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfig? value)
	{
		Instance.ModelPlotConfig = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> ModelPlotConfig()
	{
		Instance.ModelPlotConfig = Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> ModelPlotConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument>>? action)
	{
		Instance.ModelPlotConfig = Elastic.Clients.Elasticsearch.MachineLearning.ModelPlotConfigDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> ModelPruneWindow(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.ModelPruneWindow = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option, which affects the automatic removal of old
	/// model snapshots for this job. It specifies the maximum period of time (in
	/// days) that snapshots are retained. This period is relative to the
	/// timestamp of the most recent snapshot for this job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> ModelSnapshotRetentionDays(long? value)
	{
		Instance.ModelSnapshotRetentionDays = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> PerPartitionCategorization(Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorization? value)
	{
		Instance.PerPartitionCategorization = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> PerPartitionCategorization()
	{
		Instance.PerPartitionCategorization = Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings related to how categorization interacts with partition fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> PerPartitionCategorization(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor>? action)
	{
		Instance.PerPartitionCategorization = Elastic.Clients.Elasticsearch.MachineLearning.PerPartitionCategorizationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. The period over which adjustments to the
	/// score are applied, as new data is seen.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> RenormalizationWindowDays(long? value)
	{
		Instance.RenormalizationWindowDays = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Advanced configuration option. The period of time (in days) that results
	/// are retained. Age is calculated relative to the timestamp of the latest
	/// bucket result. If this property has a non-null value, once per day at
	/// 00:30 (server time), results that are the specified number of days older
	/// than the latest bucket result are deleted from Elasticsearch. The default
	/// value is null, which means all results are retained.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> ResultsRetentionDays(long? value)
	{
		Instance.ResultsRetentionDays = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateJobRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}