// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class UpdateDatafeedRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c>, wildcard indices expressions that resolve into no concrete indices are ignored. This includes the
	/// <c>_all</c> string or when no indices are specified.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument determines
	/// whether wildcard expressions match hidden data streams. Supports comma-separated values.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, concrete, expanded or aliased indices are ignored when frozen.
	/// </para>
	/// </summary>
	[System.Obsolete("Deprecated in '7.16.0'.")]
	public bool? IgnoreThrottled { get => Q<bool?>("ignore_throttled"); set => Q("ignore_throttled", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, unavailable indices (missing or closed) are ignored.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }
}

/// <summary>
/// <para>
/// Update a datafeed.
/// You must stop and start the datafeed for the changes to be applied.
/// When Elasticsearch security features are enabled, your datafeed remembers which roles the user who updated it had at
/// the time of the update and runs the query using those same roles. If you provide secondary authorization headers,
/// those credentials are used instead.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.UpdateDatafeedRequestConverter))]
public sealed partial class UpdateDatafeedRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateDatafeedRequest(Elastic.Clients.Elasticsearch.Id datafeedId) : base(r => r.Required("datafeed_id", datafeedId))
	{
	}
#if NET7_0_OR_GREATER
	public UpdateDatafeedRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdateDatafeedRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningUpdateDatafeed;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.update_datafeed";

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the datafeed.
	/// This identifier can contain lowercase alphanumeric characters (a-z and 0-9), hyphens, and underscores.
	/// It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id DatafeedId { get => P<Elastic.Clients.Elasticsearch.Id>("datafeed_id"); set => PR("datafeed_id", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, wildcard indices expressions that resolve into no concrete indices are ignored. This includes the
	/// <c>_all</c> string or when no indices are specified.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument determines
	/// whether wildcard expressions match hidden data streams. Supports comma-separated values.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, concrete, expanded or aliased indices are ignored when frozen.
	/// </para>
	/// </summary>
	[System.Obsolete("Deprecated in '7.16.0'.")]
	public bool? IgnoreThrottled { get => Q<bool?>("ignore_throttled"); set => Q("ignore_throttled", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, unavailable indices (missing or closed) are ignored.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// If set, the datafeed performs aggregation searches. Support for aggregations is limited and should be used only
	/// with low cardinality data.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? Aggregations { get; set; }

	/// <summary>
	/// <para>
	/// Datafeeds might search over long time periods, for several months or years. This search is split into time
	/// chunks in order to ensure the load on Elasticsearch is managed. Chunking configuration controls how the size of
	/// these time chunks are calculated; it is an advanced configuration option.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig? ChunkingConfig { get; set; }

	/// <summary>
	/// <para>
	/// Specifies whether the datafeed checks for missing data and the size of the window. The datafeed can optionally
	/// search over indices that have already been read in an effort to determine whether any data has subsequently been
	/// added to the index. If missing data is found, it is a good indication that the <c>query_delay</c> is set too low and
	/// the data is being indexed after the datafeed has passed that moment in time. This check runs only on real-time
	/// datafeeds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DelayedDataCheckConfig? DelayedDataCheckConfig { get; set; }

	/// <summary>
	/// <para>
	/// The interval at which scheduled queries are made while the datafeed runs in real time. The default value is
	/// either the bucket span for short bucket spans, or, for longer bucket spans, a sensible fraction of the bucket
	/// span. When <c>frequency</c> is shorter than the bucket span, interim results for the last (partial) bucket are
	/// written then eventually overwritten by the full bucket results. If the datafeed uses aggregations, this value
	/// must be divisible by the interval of the date histogram aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Frequency { get; set; }

	/// <summary>
	/// <para>
	/// An array of index names. Wildcards are supported. If any of the indices are in remote clusters, the machine
	/// learning nodes must have the <c>remote_cluster_client</c> role.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Indices { get; set; }

	/// <summary>
	/// <para>
	/// Specifies index expansion options that are used during search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndicesOptions? IndicesOptions { get; set; }
	public Elastic.Clients.Elasticsearch.Id? JobId { get; set; }

	/// <summary>
	/// <para>
	/// If a real-time datafeed has never seen any data (including during any initial training period), it automatically
	/// stops and closes the associated job after this many real-time searches return no documents. In other words,
	/// it stops after <c>frequency</c> times <c>max_empty_searches</c> of real-time operation. If not set, a datafeed with no
	/// end time that sees no data remains started until it is explicitly stopped. By default, it is not set.
	/// </para>
	/// </summary>
	public int? MaxEmptySearches { get; set; }

	/// <summary>
	/// <para>
	/// The Elasticsearch query domain-specific language (DSL). This value corresponds to the query object in an
	/// Elasticsearch search POST body. All the options that are supported by Elasticsearch can be used, as this
	/// object is passed verbatim to Elasticsearch. Note that if you change the query, the analyzed data is also
	/// changed. Therefore, the time required to learn might be long and the understandability of the results is
	/// unpredictable. If you want to make significant changes to the source data, it is recommended that you
	/// clone the job and datafeed and make the amendments in the clone. Let both run in parallel and close one
	/// when you are satisfied with the results of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }

	/// <summary>
	/// <para>
	/// The number of seconds behind real time that data is queried. For example, if data from 10:04 a.m. might
	/// not be searchable in Elasticsearch until 10:06 a.m., set this property to 120 seconds. The default
	/// value is randomly selected between <c>60s</c> and <c>120s</c>. This randomness improves the query performance
	/// when there are multiple jobs running on the same node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? QueryDelay { get; set; }

	/// <summary>
	/// <para>
	/// Specifies runtime fields for the datafeed search.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? RuntimeMappings { get; set; }

	/// <summary>
	/// <para>
	/// Specifies scripts that evaluate custom expressions and returns script fields to the datafeed.
	/// The detector configuration objects in a job can contain functions that use these script fields.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? ScriptFields { get; set; }

	/// <summary>
	/// <para>
	/// The size parameter that is used in Elasticsearch searches when the datafeed does not use aggregations.
	/// The maximum value is the value of <c>index.max_result_window</c>.
	/// </para>
	/// </summary>
	public int? ScrollSize { get; set; }
}

/// <summary>
/// <para>
/// Update a datafeed.
/// You must stop and start the datafeed for the changes to be applied.
/// When Elasticsearch security features are enabled, your datafeed remembers which roles the user who updated it had at
/// the time of the update and runs the query using those same roles. If you provide secondary authorization headers,
/// those credentials are used instead.
/// </para>
/// </summary>
public readonly partial struct UpdateDatafeedRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest instance)
	{
		Instance = instance;
	}

	public UpdateDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.Id datafeedId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest(datafeedId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateDatafeedRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the datafeed.
	/// This identifier can contain lowercase alphanumeric characters (a-z and 0-9), hyphens, and underscores.
	/// It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor DatafeedId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.DatafeedId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, wildcard indices expressions that resolve into no concrete indices are ignored. This includes the
	/// <c>_all</c> string or when no indices are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument determines
	/// whether wildcard expressions match hidden data streams. Supports comma-separated values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument determines
	/// whether wildcard expressions match hidden data streams. Supports comma-separated values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	[System.Obsolete("Deprecated in '7.16.0'.")]
	/// <summary>
	/// <para>
	/// If <c>true</c>, concrete, expanded or aliased indices are ignored when frozen.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor IgnoreThrottled(bool? value = true)
	{
		Instance.IgnoreThrottled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, unavailable indices (missing or closed) are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If set, the datafeed performs aggregation searches. Support for aggregations is limited and should be used only
	/// with low cardinality data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If set, the datafeed performs aggregation searches. Support for aggregations is limited and should be used only
	/// with low cardinality data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If set, the datafeed performs aggregation searches. Support for aggregations is limited and should be used only
	/// with low cardinality data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If set, the datafeed performs aggregation searches. Support for aggregations is limited and should be used only
	/// with low cardinality data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Aggregations<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddAggregation<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Datafeeds might search over long time periods, for several months or years. This search is split into time
	/// chunks in order to ensure the load on Elasticsearch is managed. Chunking configuration controls how the size of
	/// these time chunks are calculated; it is an advanced configuration option.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor ChunkingConfig(Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig? value)
	{
		Instance.ChunkingConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Datafeeds might search over long time periods, for several months or years. This search is split into time
	/// chunks in order to ensure the load on Elasticsearch is managed. Chunking configuration controls how the size of
	/// these time chunks are calculated; it is an advanced configuration option.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor ChunkingConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor> action)
	{
		Instance.ChunkingConfig = Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the datafeed checks for missing data and the size of the window. The datafeed can optionally
	/// search over indices that have already been read in an effort to determine whether any data has subsequently been
	/// added to the index. If missing data is found, it is a good indication that the <c>query_delay</c> is set too low and
	/// the data is being indexed after the datafeed has passed that moment in time. This check runs only on real-time
	/// datafeeds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor DelayedDataCheckConfig(Elastic.Clients.Elasticsearch.MachineLearning.DelayedDataCheckConfig? value)
	{
		Instance.DelayedDataCheckConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the datafeed checks for missing data and the size of the window. The datafeed can optionally
	/// search over indices that have already been read in an effort to determine whether any data has subsequently been
	/// added to the index. If missing data is found, it is a good indication that the <c>query_delay</c> is set too low and
	/// the data is being indexed after the datafeed has passed that moment in time. This check runs only on real-time
	/// datafeeds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor DelayedDataCheckConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DelayedDataCheckConfigDescriptor> action)
	{
		Instance.DelayedDataCheckConfig = Elastic.Clients.Elasticsearch.MachineLearning.DelayedDataCheckConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The interval at which scheduled queries are made while the datafeed runs in real time. The default value is
	/// either the bucket span for short bucket spans, or, for longer bucket spans, a sensible fraction of the bucket
	/// span. When <c>frequency</c> is shorter than the bucket span, interim results for the last (partial) bucket are
	/// written then eventually overwritten by the full bucket results. If the datafeed uses aggregations, this value
	/// must be divisible by the interval of the date histogram aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Frequency(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Frequency = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of index names. Wildcards are supported. If any of the indices are in remote clusters, the machine
	/// learning nodes must have the <c>remote_cluster_client</c> role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Indices(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of index names. Wildcards are supported. If any of the indices are in remote clusters, the machine
	/// learning nodes must have the <c>remote_cluster_client</c> role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Indices(params string[] values)
	{
		Instance.Indices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies index expansion options that are used during search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor IndicesOptions(Elastic.Clients.Elasticsearch.IndicesOptions? value)
	{
		Instance.IndicesOptions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies index expansion options that are used during search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor IndicesOptions()
	{
		Instance.IndicesOptions = Elastic.Clients.Elasticsearch.IndicesOptionsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies index expansion options that are used during search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor IndicesOptions(System.Action<Elastic.Clients.Elasticsearch.IndicesOptionsDescriptor>? action)
	{
		Instance.IndicesOptions = Elastic.Clients.Elasticsearch.IndicesOptionsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If a real-time datafeed has never seen any data (including during any initial training period), it automatically
	/// stops and closes the associated job after this many real-time searches return no documents. In other words,
	/// it stops after <c>frequency</c> times <c>max_empty_searches</c> of real-time operation. If not set, a datafeed with no
	/// end time that sees no data remains started until it is explicitly stopped. By default, it is not set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor MaxEmptySearches(int? value)
	{
		Instance.MaxEmptySearches = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query domain-specific language (DSL). This value corresponds to the query object in an
	/// Elasticsearch search POST body. All the options that are supported by Elasticsearch can be used, as this
	/// object is passed verbatim to Elasticsearch. Note that if you change the query, the analyzed data is also
	/// changed. Therefore, the time required to learn might be long and the understandability of the results is
	/// unpredictable. If you want to make significant changes to the source data, it is recommended that you
	/// clone the job and datafeed and make the amendments in the clone. Let both run in parallel and close one
	/// when you are satisfied with the results of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query domain-specific language (DSL). This value corresponds to the query object in an
	/// Elasticsearch search POST body. All the options that are supported by Elasticsearch can be used, as this
	/// object is passed verbatim to Elasticsearch. Note that if you change the query, the analyzed data is also
	/// changed. Therefore, the time required to learn might be long and the understandability of the results is
	/// unpredictable. If you want to make significant changes to the source data, it is recommended that you
	/// clone the job and datafeed and make the amendments in the clone. Let both run in parallel and close one
	/// when you are satisfied with the results of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query domain-specific language (DSL). This value corresponds to the query object in an
	/// Elasticsearch search POST body. All the options that are supported by Elasticsearch can be used, as this
	/// object is passed verbatim to Elasticsearch. Note that if you change the query, the analyzed data is also
	/// changed. Therefore, the time required to learn might be long and the understandability of the results is
	/// unpredictable. If you want to make significant changes to the source data, it is recommended that you
	/// clone the job and datafeed and make the amendments in the clone. Let both run in parallel and close one
	/// when you are satisfied with the results of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of seconds behind real time that data is queried. For example, if data from 10:04 a.m. might
	/// not be searchable in Elasticsearch until 10:06 a.m., set this property to 120 seconds. The default
	/// value is randomly selected between <c>60s</c> and <c>120s</c>. This randomness improves the query performance
	/// when there are multiple jobs running on the same node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor QueryDelay(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.QueryDelay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies runtime fields for the datafeed search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies runtime fields for the datafeed search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies runtime fields for the datafeed search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies runtime fields for the datafeed search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor RuntimeMappings<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddRuntimeMapping<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies scripts that evaluate custom expressions and returns script fields to the datafeed.
	/// The detector configuration objects in a job can contain functions that use these script fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor ScriptFields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies scripts that evaluate custom expressions and returns script fields to the datafeed.
	/// The detector configuration objects in a job can contain functions that use these script fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies scripts that evaluate custom expressions and returns script fields to the datafeed.
	/// The detector configuration objects in a job can contain functions that use these script fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddScriptField(string key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor AddScriptField(string key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// The size parameter that is used in Elasticsearch searches when the datafeed does not use aggregations.
	/// The maximum value is the value of <c>index.max_result_window</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor ScrollSize(int? value)
	{
		Instance.ScrollSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Update a datafeed.
/// You must stop and start the datafeed for the changes to be applied.
/// When Elasticsearch security features are enabled, your datafeed remembers which roles the user who updated it had at
/// the time of the update and runs the query using those same roles. If you provide secondary authorization headers,
/// those credentials are used instead.
/// </para>
/// </summary>
public readonly partial struct UpdateDatafeedRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest instance)
	{
		Instance = instance;
	}

	public UpdateDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.Id datafeedId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest(datafeedId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateDatafeedRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the datafeed.
	/// This identifier can contain lowercase alphanumeric characters (a-z and 0-9), hyphens, and underscores.
	/// It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> DatafeedId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.DatafeedId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, wildcard indices expressions that resolve into no concrete indices are ignored. This includes the
	/// <c>_all</c> string or when no indices are specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument determines
	/// whether wildcard expressions match hidden data streams. Supports comma-separated values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument determines
	/// whether wildcard expressions match hidden data streams. Supports comma-separated values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	[System.Obsolete("Deprecated in '7.16.0'.")]
	/// <summary>
	/// <para>
	/// If <c>true</c>, concrete, expanded or aliased indices are ignored when frozen.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> IgnoreThrottled(bool? value = true)
	{
		Instance.IgnoreThrottled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, unavailable indices (missing or closed) are ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If set, the datafeed performs aggregation searches. Support for aggregations is limited and should be used only
	/// with low cardinality data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If set, the datafeed performs aggregation searches. Support for aggregations is limited and should be used only
	/// with low cardinality data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If set, the datafeed performs aggregation searches. Support for aggregations is limited and should be used only
	/// with low cardinality data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Datafeeds might search over long time periods, for several months or years. This search is split into time
	/// chunks in order to ensure the load on Elasticsearch is managed. Chunking configuration controls how the size of
	/// these time chunks are calculated; it is an advanced configuration option.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> ChunkingConfig(Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfig? value)
	{
		Instance.ChunkingConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Datafeeds might search over long time periods, for several months or years. This search is split into time
	/// chunks in order to ensure the load on Elasticsearch is managed. Chunking configuration controls how the size of
	/// these time chunks are calculated; it is an advanced configuration option.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> ChunkingConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor> action)
	{
		Instance.ChunkingConfig = Elastic.Clients.Elasticsearch.MachineLearning.ChunkingConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the datafeed checks for missing data and the size of the window. The datafeed can optionally
	/// search over indices that have already been read in an effort to determine whether any data has subsequently been
	/// added to the index. If missing data is found, it is a good indication that the <c>query_delay</c> is set too low and
	/// the data is being indexed after the datafeed has passed that moment in time. This check runs only on real-time
	/// datafeeds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> DelayedDataCheckConfig(Elastic.Clients.Elasticsearch.MachineLearning.DelayedDataCheckConfig? value)
	{
		Instance.DelayedDataCheckConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the datafeed checks for missing data and the size of the window. The datafeed can optionally
	/// search over indices that have already been read in an effort to determine whether any data has subsequently been
	/// added to the index. If missing data is found, it is a good indication that the <c>query_delay</c> is set too low and
	/// the data is being indexed after the datafeed has passed that moment in time. This check runs only on real-time
	/// datafeeds.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> DelayedDataCheckConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DelayedDataCheckConfigDescriptor> action)
	{
		Instance.DelayedDataCheckConfig = Elastic.Clients.Elasticsearch.MachineLearning.DelayedDataCheckConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The interval at which scheduled queries are made while the datafeed runs in real time. The default value is
	/// either the bucket span for short bucket spans, or, for longer bucket spans, a sensible fraction of the bucket
	/// span. When <c>frequency</c> is shorter than the bucket span, interim results for the last (partial) bucket are
	/// written then eventually overwritten by the full bucket results. If the datafeed uses aggregations, this value
	/// must be divisible by the interval of the date histogram aggregation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Frequency(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Frequency = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of index names. Wildcards are supported. If any of the indices are in remote clusters, the machine
	/// learning nodes must have the <c>remote_cluster_client</c> role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Indices(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of index names. Wildcards are supported. If any of the indices are in remote clusters, the machine
	/// learning nodes must have the <c>remote_cluster_client</c> role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Indices(params string[] values)
	{
		Instance.Indices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies index expansion options that are used during search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> IndicesOptions(Elastic.Clients.Elasticsearch.IndicesOptions? value)
	{
		Instance.IndicesOptions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies index expansion options that are used during search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> IndicesOptions()
	{
		Instance.IndicesOptions = Elastic.Clients.Elasticsearch.IndicesOptionsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies index expansion options that are used during search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> IndicesOptions(System.Action<Elastic.Clients.Elasticsearch.IndicesOptionsDescriptor>? action)
	{
		Instance.IndicesOptions = Elastic.Clients.Elasticsearch.IndicesOptionsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> JobId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If a real-time datafeed has never seen any data (including during any initial training period), it automatically
	/// stops and closes the associated job after this many real-time searches return no documents. In other words,
	/// it stops after <c>frequency</c> times <c>max_empty_searches</c> of real-time operation. If not set, a datafeed with no
	/// end time that sees no data remains started until it is explicitly stopped. By default, it is not set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> MaxEmptySearches(int? value)
	{
		Instance.MaxEmptySearches = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query domain-specific language (DSL). This value corresponds to the query object in an
	/// Elasticsearch search POST body. All the options that are supported by Elasticsearch can be used, as this
	/// object is passed verbatim to Elasticsearch. Note that if you change the query, the analyzed data is also
	/// changed. Therefore, the time required to learn might be long and the understandability of the results is
	/// unpredictable. If you want to make significant changes to the source data, it is recommended that you
	/// clone the job and datafeed and make the amendments in the clone. Let both run in parallel and close one
	/// when you are satisfied with the results of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query domain-specific language (DSL). This value corresponds to the query object in an
	/// Elasticsearch search POST body. All the options that are supported by Elasticsearch can be used, as this
	/// object is passed verbatim to Elasticsearch. Note that if you change the query, the analyzed data is also
	/// changed. Therefore, the time required to learn might be long and the understandability of the results is
	/// unpredictable. If you want to make significant changes to the source data, it is recommended that you
	/// clone the job and datafeed and make the amendments in the clone. Let both run in parallel and close one
	/// when you are satisfied with the results of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of seconds behind real time that data is queried. For example, if data from 10:04 a.m. might
	/// not be searchable in Elasticsearch until 10:06 a.m., set this property to 120 seconds. The default
	/// value is randomly selected between <c>60s</c> and <c>120s</c>. This randomness improves the query performance
	/// when there are multiple jobs running on the same node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> QueryDelay(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.QueryDelay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies runtime fields for the datafeed search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies runtime fields for the datafeed search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies runtime fields for the datafeed search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies scripts that evaluate custom expressions and returns script fields to the datafeed.
	/// The detector configuration objects in a job can contain functions that use these script fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> ScriptFields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies scripts that evaluate custom expressions and returns script fields to the datafeed.
	/// The detector configuration objects in a job can contain functions that use these script fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies scripts that evaluate custom expressions and returns script fields to the datafeed.
	/// The detector configuration objects in a job can contain functions that use these script fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> AddScriptField(string key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> AddScriptField(string key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// The size parameter that is used in Elasticsearch searches when the datafeed does not use aggregations.
	/// The maximum value is the value of <c>index.max_result_window</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> ScrollSize(int? value)
	{
		Instance.ScrollSize = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDatafeedRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}