// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class UpdateDataFrameAnalyticsRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Update a data frame analytics job.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.UpdateDataFrameAnalyticsRequestConverter))]
public sealed partial class UpdateDataFrameAnalyticsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public UpdateDataFrameAnalyticsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdateDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningUpdateDataFrameAnalytics;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.update_data_frame_analytics";

	/// <summary>
	/// <para>
	/// Identifier for the data frame analytics job. This identifier can contain
	/// lowercase alphanumeric characters (a-z and 0-9), hyphens, and
	/// underscores. It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// Specifies whether this job can start when there is insufficient machine
	/// learning node capacity for it to be immediately assigned to a node.
	/// </para>
	/// </summary>
	public bool? AllowLazyStart { get; set; }

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of threads to be used by the analysis. Using more
	/// threads may decrease the time necessary to complete the analysis at the
	/// cost of using more CPU. Note that the process may use additional threads
	/// for operational functionality other than the analysis itself.
	/// </para>
	/// </summary>
	public int? MaxNumThreads { get; set; }

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are permitted for
	/// analytical processing. If your <c>elasticsearch.yml</c> file contains an
	/// <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try
	/// to create data frame analytics jobs that have <c>model_memory_limit</c> values
	/// greater than that setting.
	/// </para>
	/// </summary>
	public string? ModelMemoryLimit { get; set; }
}

/// <summary>
/// <para>
/// Update a data frame analytics job.
/// </para>
/// </summary>
public readonly partial struct UpdateDataFrameAnalyticsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest instance)
	{
		Instance = instance;
	}

	public UpdateDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest(id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateDataFrameAnalyticsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the data frame analytics job. This identifier can contain
	/// lowercase alphanumeric characters (a-z and 0-9), hyphens, and
	/// underscores. It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether this job can start when there is insufficient machine
	/// learning node capacity for it to be immediately assigned to a node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor AllowLazyStart(bool? value = true)
	{
		Instance.AllowLazyStart = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of threads to be used by the analysis. Using more
	/// threads may decrease the time necessary to complete the analysis at the
	/// cost of using more CPU. Note that the process may use additional threads
	/// for operational functionality other than the analysis itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor MaxNumThreads(int? value)
	{
		Instance.MaxNumThreads = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are permitted for
	/// analytical processing. If your <c>elasticsearch.yml</c> file contains an
	/// <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try
	/// to create data frame analytics jobs that have <c>model_memory_limit</c> values
	/// greater than that setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor ModelMemoryLimit(string? value)
	{
		Instance.ModelMemoryLimit = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.UpdateDataFrameAnalyticsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}