// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class StartDatafeedRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Start datafeeds.
/// </para>
/// <para>
/// A datafeed must be started in order to retrieve data from Elasticsearch. A datafeed can be started and stopped
/// multiple times throughout its lifecycle.
/// </para>
/// <para>
/// Before you can start a datafeed, the anomaly detection job must be open. Otherwise, an error occurs.
/// </para>
/// <para>
/// If you restart a stopped datafeed, it continues processing input data from the next millisecond after it was stopped.
/// If new data was indexed for that exact millisecond between stopping and starting, it will be ignored.
/// </para>
/// <para>
/// When Elasticsearch security features are enabled, your datafeed remembers which roles the last user to create or
/// update it had at the time of creation or update and runs the query using those same roles. If you provided secondary
/// authorization headers when you created or updated the datafeed, those credentials are used instead.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.StartDatafeedRequestConverter))]
public sealed partial class StartDatafeedRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StartDatafeedRequest(Elastic.Clients.Elasticsearch.Id datafeedId) : base(r => r.Required("datafeed_id", datafeedId))
	{
	}
#if NET7_0_OR_GREATER
	public StartDatafeedRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal StartDatafeedRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningStartDatafeed;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.start_datafeed";

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the datafeed. This identifier can contain lowercase
	/// alphanumeric characters (a-z and 0-9), hyphens, and underscores. It must start and end with alphanumeric
	/// characters.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id DatafeedId { get => P<Elastic.Clients.Elasticsearch.Id>("datafeed_id"); set => PR("datafeed_id", value); }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? End { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? Start { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>timeout</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get; set; }
}

/// <summary>
/// <para>
/// Start datafeeds.
/// </para>
/// <para>
/// A datafeed must be started in order to retrieve data from Elasticsearch. A datafeed can be started and stopped
/// multiple times throughout its lifecycle.
/// </para>
/// <para>
/// Before you can start a datafeed, the anomaly detection job must be open. Otherwise, an error occurs.
/// </para>
/// <para>
/// If you restart a stopped datafeed, it continues processing input data from the next millisecond after it was stopped.
/// If new data was indexed for that exact millisecond between stopping and starting, it will be ignored.
/// </para>
/// <para>
/// When Elasticsearch security features are enabled, your datafeed remembers which roles the last user to create or
/// update it had at the time of creation or update and runs the query using those same roles. If you provided secondary
/// authorization headers when you created or updated the datafeed, those credentials are used instead.
/// </para>
/// </summary>
public readonly partial struct StartDatafeedRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StartDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest instance)
	{
		Instance = instance;
	}

	public StartDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.Id datafeedId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest(datafeedId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public StartDatafeedRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest(Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the datafeed. This identifier can contain lowercase
	/// alphanumeric characters (a-z and 0-9), hyphens, and underscores. It must start and end with alphanumeric
	/// characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor DatafeedId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.DatafeedId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor End(System.DateTimeOffset? value)
	{
		Instance.End = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor Start(System.DateTimeOffset? value)
	{
		Instance.Start = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>timeout</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.StartDatafeedRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}