// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class PutTrainedModelVocabularyRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Create a trained model vocabulary.
/// This API is supported only for natural language processing (NLP) models.
/// The vocabulary is stored in the index as described in <c>inference_config.*.vocabulary</c> of the trained model definition.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.PutTrainedModelVocabularyRequestConverter))]
public sealed partial class PutTrainedModelVocabularyRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutTrainedModelVocabularyRequest(Elastic.Clients.Elasticsearch.Id modelId) : base(r => r.Required("model_id", modelId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutTrainedModelVocabularyRequest(Elastic.Clients.Elasticsearch.Id modelId, System.Collections.Generic.ICollection<string> vocabulary) : base(r => r.Required("model_id", modelId))
	{
		Vocabulary = vocabulary;
	}
#if NET7_0_OR_GREATER
	public PutTrainedModelVocabularyRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutTrainedModelVocabularyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningPutTrainedModelVocabulary;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.put_trained_model_vocabulary";

	/// <summary>
	/// <para>
	/// The unique identifier of the trained model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id ModelId { get => P<Elastic.Clients.Elasticsearch.Id>("model_id"); set => PR("model_id", value); }

	/// <summary>
	/// <para>
	/// The optional model merges if required by the tokenizer.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Merges { get; set; }

	/// <summary>
	/// <para>
	/// The optional vocabulary value scores if required by the tokenizer.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<double>? Scores { get; set; }

	/// <summary>
	/// <para>
	/// The model vocabulary, which must not be empty.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Vocabulary { get; set; }
}

/// <summary>
/// <para>
/// Create a trained model vocabulary.
/// This API is supported only for natural language processing (NLP) models.
/// The vocabulary is stored in the index as described in <c>inference_config.*.vocabulary</c> of the trained model definition.
/// </para>
/// </summary>
public readonly partial struct PutTrainedModelVocabularyRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutTrainedModelVocabularyRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest instance)
	{
		Instance = instance;
	}

	public PutTrainedModelVocabularyRequestDescriptor(Elastic.Clients.Elasticsearch.Id modelId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest(modelId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutTrainedModelVocabularyRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the trained model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor ModelId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The optional model merges if required by the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor Merges(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Merges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The optional model merges if required by the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor Merges(params string[] values)
	{
		Instance.Merges = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The optional vocabulary value scores if required by the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor Scores(System.Collections.Generic.ICollection<double>? value)
	{
		Instance.Scores = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The optional vocabulary value scores if required by the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor Scores(params double[] values)
	{
		Instance.Scores = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The model vocabulary, which must not be empty.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor Vocabulary(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Vocabulary = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The model vocabulary, which must not be empty.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor Vocabulary(params string[] values)
	{
		Instance.Vocabulary = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelVocabularyRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}