// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.PutTrainedModelResponseConverter))]
public sealed partial class PutTrainedModelResponse : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutTrainedModelResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutTrainedModelResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? CompressedDefinition { get; set; }

	/// <summary>
	/// <para>
	/// Information on the creator of the trained model.
	/// </para>
	/// </summary>
	public string? CreatedBy { get; set; }

	/// <summary>
	/// <para>
	/// The time when the trained model was created.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? CreateTime { get; set; }

	/// <summary>
	/// <para>
	/// Any field map described in the inference configuration takes precedence.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, string>? DefaultFieldMap { get; set; }

	/// <summary>
	/// <para>
	/// The free-text description of the trained model.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The estimated heap usage in bytes to keep the trained model in memory.
	/// </para>
	/// </summary>
	public int? EstimatedHeapMemoryUsageBytes { get; set; }

	/// <summary>
	/// <para>
	/// The estimated number of operations to use the trained model.
	/// </para>
	/// </summary>
	public int? EstimatedOperations { get; set; }

	/// <summary>
	/// <para>
	/// True if the full model definition is present.
	/// </para>
	/// </summary>
	public bool? FullyDefined { get; set; }

	/// <summary>
	/// <para>
	/// The default configuration for inference. This can be either a regression, classification, or one of the many NLP focused configurations. It must match the underlying definition.trained_model's target_type. For pre-packaged models such as ELSER the config is not required.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigCreate? InferenceConfig { get; set; }

	/// <summary>
	/// <para>
	/// The input field names for the model definition.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelConfigInput Input { get; set; }

	/// <summary>
	/// <para>
	/// The license level of the trained model.
	/// </para>
	/// </summary>
	public string? LicenseLevel { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelLocation? Location { get; set; }

	/// <summary>
	/// <para>
	/// An object containing metadata about the trained model. For example, models created by data frame analytics contain analysis_config and input objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelConfigMetadata? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the trained model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ModelId { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.ModelPackageConfig? ModelPackage { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? ModelSizeBytes { get; set; }

	/// <summary>
	/// <para>
	/// The model type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelType? ModelType { get; set; }
	public string? PlatformArchitecture { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.TrainedModelPrefixStrings? PrefixStrings { get; set; }

	/// <summary>
	/// <para>
	/// A comma delimited string of tags. A trained model can have many tags, or none.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> Tags { get; set; }

	/// <summary>
	/// <para>
	/// The Elasticsearch version number in which the trained model was created.
	/// </para>
	/// </summary>
	public string? Version { get; set; }
}