// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class PutTrainedModelAliasRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies whether the alias gets reassigned to the specified trained
	/// model if it is already assigned to a different model. If the alias is
	/// already assigned and this parameter is false, the API returns an error.
	/// </para>
	/// </summary>
	public bool? Reassign { get => Q<bool?>("reassign"); set => Q("reassign", value); }
}

/// <summary>
/// <para>
/// Create or update a trained model alias.
/// A trained model alias is a logical name used to reference a single trained
/// model.
/// You can use aliases instead of trained model identifiers to make it easier to
/// reference your models. For example, you can use aliases in inference
/// aggregations and processors.
/// An alias must be unique and refer to only a single trained model. However,
/// you can have multiple aliases for each trained model.
/// If you use this API to update an alias such that it references a different
/// trained model ID and the model uses a different type of data frame analytics,
/// an error occurs. For example, this situation occurs if you have a trained
/// model for regression analysis and a trained model for classification
/// analysis; you cannot reassign an alias from one type of trained model to
/// another.
/// If you use this API to update an alias and there are very few input fields in
/// common between the old and new trained models for the model alias, the API
/// returns a warning.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.PutTrainedModelAliasRequestConverter))]
public sealed partial class PutTrainedModelAliasRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutTrainedModelAliasRequest(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias) : base(r => r.Required("model_id", modelId).Required("model_alias", modelAlias))
	{
	}
#if NET7_0_OR_GREATER
	public PutTrainedModelAliasRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutTrainedModelAliasRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningPutTrainedModelAlias;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => false;

	internal override string OperationName => "ml.put_trained_model_alias";

	/// <summary>
	/// <para>
	/// The alias to create or update. This value cannot end in numbers.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name ModelAlias { get => P<Elastic.Clients.Elasticsearch.Name>("model_alias"); set => PR("model_alias", value); }

	/// <summary>
	/// <para>
	/// The identifier for the trained model that the alias refers to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id ModelId { get => P<Elastic.Clients.Elasticsearch.Id>("model_id"); set => PR("model_id", value); }

	/// <summary>
	/// <para>
	/// Specifies whether the alias gets reassigned to the specified trained
	/// model if it is already assigned to a different model. If the alias is
	/// already assigned and this parameter is false, the API returns an error.
	/// </para>
	/// </summary>
	public bool? Reassign { get => Q<bool?>("reassign"); set => Q("reassign", value); }
}

/// <summary>
/// <para>
/// Create or update a trained model alias.
/// A trained model alias is a logical name used to reference a single trained
/// model.
/// You can use aliases instead of trained model identifiers to make it easier to
/// reference your models. For example, you can use aliases in inference
/// aggregations and processors.
/// An alias must be unique and refer to only a single trained model. However,
/// you can have multiple aliases for each trained model.
/// If you use this API to update an alias such that it references a different
/// trained model ID and the model uses a different type of data frame analytics,
/// an error occurs. For example, this situation occurs if you have a trained
/// model for regression analysis and a trained model for classification
/// analysis; you cannot reassign an alias from one type of trained model to
/// another.
/// If you use this API to update an alias and there are very few input fields in
/// common between the old and new trained models for the model alias, the API
/// returns a warning.
/// </para>
/// </summary>
public readonly partial struct PutTrainedModelAliasRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutTrainedModelAliasRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest instance)
	{
		Instance = instance;
	}

	public PutTrainedModelAliasRequestDescriptor(Elastic.Clients.Elasticsearch.Id modelId, Elastic.Clients.Elasticsearch.Name modelAlias)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest(modelId, modelAlias);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutTrainedModelAliasRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest(Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The alias to create or update. This value cannot end in numbers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor ModelAlias(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.ModelAlias = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The identifier for the trained model that the alias refers to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor ModelId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the alias gets reassigned to the specified trained
	/// model if it is already assigned to a different model. If the alias is
	/// already assigned and this parameter is false, the API returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor Reassign(bool? value = true)
	{
		Instance.Reassign = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutTrainedModelAliasRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}