// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class PutDataFrameAnalyticsRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Create a data frame analytics job.
/// This API creates a data frame analytics job that performs an analysis on the
/// source indices and stores the outcome in a destination index.
/// By default, the query used in the source configuration is <c>{"match_all": {}}</c>.
/// </para>
/// <para>
/// If the destination index does not exist, it is created automatically when you start the job.
/// </para>
/// <para>
/// If you supply only a subset of the regression or classification parameters, hyperparameter optimization occurs. It determines a value for each of the undefined parameters.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.PutDataFrameAnalyticsRequestConverter))]
public sealed partial class PutDataFrameAnalyticsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Id id, Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis analysis, Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestination dest, Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSource source) : base(r => r.Required("id", id))
	{
		Analysis = analysis;
		Dest = dest;
		Source = source;
	}
#if NET7_0_OR_GREATER
	public PutDataFrameAnalyticsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningPutDataFrameAnalytics;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.put_data_frame_analytics";

	/// <summary>
	/// <para>
	/// Identifier for the data frame analytics job. This identifier can contain
	/// lowercase alphanumeric characters (a-z and 0-9), hyphens, and
	/// underscores. It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// Specifies whether this job can start when there is insufficient machine
	/// learning node capacity for it to be immediately assigned to a node. If
	/// set to <c>false</c> and a machine learning node with capacity to run the job
	/// cannot be immediately found, the API returns an error. If set to <c>true</c>,
	/// the API does not return an error; the job waits in the <c>starting</c> state
	/// until sufficient machine learning node capacity is available. This
	/// behavior is also affected by the cluster-wide
	/// <c>xpack.ml.max_lazy_ml_nodes</c> setting.
	/// </para>
	/// </summary>
	public bool? AllowLazyStart { get; set; }

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis Analysis { get; set; }

	/// <summary>
	/// <para>
	/// Specifies <c>includes</c> and/or <c>excludes</c> patterns to select which fields
	/// will be included in the analysis. The patterns specified in <c>excludes</c>
	/// are applied last, therefore <c>excludes</c> takes precedence. In other words,
	/// if the same field is specified in both <c>includes</c> and <c>excludes</c>, then
	/// the field will not be included in the analysis. If <c>analyzed_fields</c> is
	/// not set, only the relevant fields will be included. For example, all the
	/// numeric fields for outlier detection.
	/// The supported fields vary for each type of analysis. Outlier detection
	/// requires numeric or <c>boolean</c> data to analyze. The algorithms don’t
	/// support missing values therefore fields that have data types other than
	/// numeric or boolean are ignored. Documents where included fields contain
	/// missing values, null values, or an array are also ignored. Therefore the
	/// <c>dest</c> index may contain documents that don’t have an outlier score.
	/// Regression supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the regression analysis.
	/// Classification supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the classification analysis.
	/// Classification analysis can be improved by mapping ordinal variable
	/// values to a single number. For example, in case of age ranges, you can
	/// model the values as <c>0-14 = 0</c>, <c>15-24 = 1</c>, <c>25-34 = 2</c>, and so on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFields? AnalyzedFields { get; set; }

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The destination configuration.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestination Dest { get; set; }
	public System.Collections.Generic.IDictionary<string, System.Collections.Generic.ICollection<string>>? Headers { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of threads to be used by the analysis. Using more
	/// threads may decrease the time necessary to complete the analysis at the
	/// cost of using more CPU. Note that the process may use additional threads
	/// for operational functionality other than the analysis itself.
	/// </para>
	/// </summary>
	public int? MaxNumThreads { get; set; }
	public System.Collections.Generic.IDictionary<string, object>? Meta { get; set; }

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are permitted for
	/// analytical processing. If your <c>elasticsearch.yml</c> file contains an
	/// <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try
	/// to create data frame analytics jobs that have <c>model_memory_limit</c> values
	/// greater than that setting.
	/// </para>
	/// </summary>
	public string? ModelMemoryLimit { get; set; }

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSource Source { get; set; }
	public string? Version { get; set; }
}

/// <summary>
/// <para>
/// Create a data frame analytics job.
/// This API creates a data frame analytics job that performs an analysis on the
/// source indices and stores the outcome in a destination index.
/// By default, the query used in the source configuration is <c>{"match_all": {}}</c>.
/// </para>
/// <para>
/// If the destination index does not exist, it is created automatically when you start the job.
/// </para>
/// <para>
/// If you supply only a subset of the regression or classification parameters, hyperparameter optimization occurs. It determines a value for each of the undefined parameters.
/// </para>
/// </summary>
public readonly partial struct PutDataFrameAnalyticsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest instance)
	{
		Instance = instance;
	}

	public PutDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest(id);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutDataFrameAnalyticsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the data frame analytics job. This identifier can contain
	/// lowercase alphanumeric characters (a-z and 0-9), hyphens, and
	/// underscores. It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether this job can start when there is insufficient machine
	/// learning node capacity for it to be immediately assigned to a node. If
	/// set to <c>false</c> and a machine learning node with capacity to run the job
	/// cannot be immediately found, the API returns an error. If set to <c>true</c>,
	/// the API does not return an error; the job waits in the <c>starting</c> state
	/// until sufficient machine learning node capacity is available. This
	/// behavior is also affected by the cluster-wide
	/// <c>xpack.ml.max_lazy_ml_nodes</c> setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor AllowLazyStart(bool? value = true)
	{
		Instance.AllowLazyStart = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Analysis(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis value)
	{
		Instance.Analysis = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Analysis(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor> action)
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Analysis<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<T>> action)
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies <c>includes</c> and/or <c>excludes</c> patterns to select which fields
	/// will be included in the analysis. The patterns specified in <c>excludes</c>
	/// are applied last, therefore <c>excludes</c> takes precedence. In other words,
	/// if the same field is specified in both <c>includes</c> and <c>excludes</c>, then
	/// the field will not be included in the analysis. If <c>analyzed_fields</c> is
	/// not set, only the relevant fields will be included. For example, all the
	/// numeric fields for outlier detection.
	/// The supported fields vary for each type of analysis. Outlier detection
	/// requires numeric or <c>boolean</c> data to analyze. The algorithms don’t
	/// support missing values therefore fields that have data types other than
	/// numeric or boolean are ignored. Documents where included fields contain
	/// missing values, null values, or an array are also ignored. Therefore the
	/// <c>dest</c> index may contain documents that don’t have an outlier score.
	/// Regression supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the regression analysis.
	/// Classification supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the classification analysis.
	/// Classification analysis can be improved by mapping ordinal variable
	/// values to a single number. For example, in case of age ranges, you can
	/// model the values as <c>0-14 = 0</c>, <c>15-24 = 1</c>, <c>25-34 = 2</c>, and so on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor AnalyzedFields(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFields? value)
	{
		Instance.AnalyzedFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies <c>includes</c> and/or <c>excludes</c> patterns to select which fields
	/// will be included in the analysis. The patterns specified in <c>excludes</c>
	/// are applied last, therefore <c>excludes</c> takes precedence. In other words,
	/// if the same field is specified in both <c>includes</c> and <c>excludes</c>, then
	/// the field will not be included in the analysis. If <c>analyzed_fields</c> is
	/// not set, only the relevant fields will be included. For example, all the
	/// numeric fields for outlier detection.
	/// The supported fields vary for each type of analysis. Outlier detection
	/// requires numeric or <c>boolean</c> data to analyze. The algorithms don’t
	/// support missing values therefore fields that have data types other than
	/// numeric or boolean are ignored. Documents where included fields contain
	/// missing values, null values, or an array are also ignored. Therefore the
	/// <c>dest</c> index may contain documents that don’t have an outlier score.
	/// Regression supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the regression analysis.
	/// Classification supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the classification analysis.
	/// Classification analysis can be improved by mapping ordinal variable
	/// values to a single number. For example, in case of age ranges, you can
	/// model the values as <c>0-14 = 0</c>, <c>15-24 = 1</c>, <c>25-34 = 2</c>, and so on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor AnalyzedFields()
	{
		Instance.AnalyzedFields = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies <c>includes</c> and/or <c>excludes</c> patterns to select which fields
	/// will be included in the analysis. The patterns specified in <c>excludes</c>
	/// are applied last, therefore <c>excludes</c> takes precedence. In other words,
	/// if the same field is specified in both <c>includes</c> and <c>excludes</c>, then
	/// the field will not be included in the analysis. If <c>analyzed_fields</c> is
	/// not set, only the relevant fields will be included. For example, all the
	/// numeric fields for outlier detection.
	/// The supported fields vary for each type of analysis. Outlier detection
	/// requires numeric or <c>boolean</c> data to analyze. The algorithms don’t
	/// support missing values therefore fields that have data types other than
	/// numeric or boolean are ignored. Documents where included fields contain
	/// missing values, null values, or an array are also ignored. Therefore the
	/// <c>dest</c> index may contain documents that don’t have an outlier score.
	/// Regression supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the regression analysis.
	/// Classification supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the classification analysis.
	/// Classification analysis can be improved by mapping ordinal variable
	/// values to a single number. For example, in case of age ranges, you can
	/// model the values as <c>0-14 = 0</c>, <c>15-24 = 1</c>, <c>25-34 = 2</c>, and so on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor AnalyzedFields(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor>? action)
	{
		Instance.AnalyzedFields = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Dest(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestination value)
	{
		Instance.Dest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Dest(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor> action)
	{
		Instance.Dest = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Dest<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor<T>> action)
	{
		Instance.Dest = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Headers(System.Collections.Generic.IDictionary<string, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Headers = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Headers()
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Headers(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString>? action)
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor AddHeader(string key, System.Collections.Generic.ICollection<string> value)
	{
		Instance.Headers ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Headers.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor AddHeader(string key, params string[] values)
	{
		Instance.Headers ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Headers.Add(key, [.. values]);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of threads to be used by the analysis. Using more
	/// threads may decrease the time necessary to complete the analysis at the
	/// cost of using more CPU. Note that the process may use additional threads
	/// for operational functionality other than the analysis itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor MaxNumThreads(int? value)
	{
		Instance.MaxNumThreads = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are permitted for
	/// analytical processing. If your <c>elasticsearch.yml</c> file contains an
	/// <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try
	/// to create data frame analytics jobs that have <c>model_memory_limit</c> values
	/// greater than that setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor ModelMemoryLimit(string? value)
	{
		Instance.ModelMemoryLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Source(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSource value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Source(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Source<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor<T>> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create a data frame analytics job.
/// This API creates a data frame analytics job that performs an analysis on the
/// source indices and stores the outcome in a destination index.
/// By default, the query used in the source configuration is <c>{"match_all": {}}</c>.
/// </para>
/// <para>
/// If the destination index does not exist, it is created automatically when you start the job.
/// </para>
/// <para>
/// If you supply only a subset of the regression or classification parameters, hyperparameter optimization occurs. It determines a value for each of the undefined parameters.
/// </para>
/// </summary>
public readonly partial struct PutDataFrameAnalyticsRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest instance)
	{
		Instance = instance;
	}

	public PutDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest(id);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutDataFrameAnalyticsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the data frame analytics job. This identifier can contain
	/// lowercase alphanumeric characters (a-z and 0-9), hyphens, and
	/// underscores. It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether this job can start when there is insufficient machine
	/// learning node capacity for it to be immediately assigned to a node. If
	/// set to <c>false</c> and a machine learning node with capacity to run the job
	/// cannot be immediately found, the API returns an error. If set to <c>true</c>,
	/// the API does not return an error; the job waits in the <c>starting</c> state
	/// until sufficient machine learning node capacity is available. This
	/// behavior is also affected by the cluster-wide
	/// <c>xpack.ml.max_lazy_ml_nodes</c> setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> AllowLazyStart(bool? value = true)
	{
		Instance.AllowLazyStart = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Analysis(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis value)
	{
		Instance.Analysis = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Analysis(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument>> action)
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies <c>includes</c> and/or <c>excludes</c> patterns to select which fields
	/// will be included in the analysis. The patterns specified in <c>excludes</c>
	/// are applied last, therefore <c>excludes</c> takes precedence. In other words,
	/// if the same field is specified in both <c>includes</c> and <c>excludes</c>, then
	/// the field will not be included in the analysis. If <c>analyzed_fields</c> is
	/// not set, only the relevant fields will be included. For example, all the
	/// numeric fields for outlier detection.
	/// The supported fields vary for each type of analysis. Outlier detection
	/// requires numeric or <c>boolean</c> data to analyze. The algorithms don’t
	/// support missing values therefore fields that have data types other than
	/// numeric or boolean are ignored. Documents where included fields contain
	/// missing values, null values, or an array are also ignored. Therefore the
	/// <c>dest</c> index may contain documents that don’t have an outlier score.
	/// Regression supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the regression analysis.
	/// Classification supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the classification analysis.
	/// Classification analysis can be improved by mapping ordinal variable
	/// values to a single number. For example, in case of age ranges, you can
	/// model the values as <c>0-14 = 0</c>, <c>15-24 = 1</c>, <c>25-34 = 2</c>, and so on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> AnalyzedFields(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFields? value)
	{
		Instance.AnalyzedFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies <c>includes</c> and/or <c>excludes</c> patterns to select which fields
	/// will be included in the analysis. The patterns specified in <c>excludes</c>
	/// are applied last, therefore <c>excludes</c> takes precedence. In other words,
	/// if the same field is specified in both <c>includes</c> and <c>excludes</c>, then
	/// the field will not be included in the analysis. If <c>analyzed_fields</c> is
	/// not set, only the relevant fields will be included. For example, all the
	/// numeric fields for outlier detection.
	/// The supported fields vary for each type of analysis. Outlier detection
	/// requires numeric or <c>boolean</c> data to analyze. The algorithms don’t
	/// support missing values therefore fields that have data types other than
	/// numeric or boolean are ignored. Documents where included fields contain
	/// missing values, null values, or an array are also ignored. Therefore the
	/// <c>dest</c> index may contain documents that don’t have an outlier score.
	/// Regression supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the regression analysis.
	/// Classification supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the classification analysis.
	/// Classification analysis can be improved by mapping ordinal variable
	/// values to a single number. For example, in case of age ranges, you can
	/// model the values as <c>0-14 = 0</c>, <c>15-24 = 1</c>, <c>25-34 = 2</c>, and so on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> AnalyzedFields()
	{
		Instance.AnalyzedFields = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies <c>includes</c> and/or <c>excludes</c> patterns to select which fields
	/// will be included in the analysis. The patterns specified in <c>excludes</c>
	/// are applied last, therefore <c>excludes</c> takes precedence. In other words,
	/// if the same field is specified in both <c>includes</c> and <c>excludes</c>, then
	/// the field will not be included in the analysis. If <c>analyzed_fields</c> is
	/// not set, only the relevant fields will be included. For example, all the
	/// numeric fields for outlier detection.
	/// The supported fields vary for each type of analysis. Outlier detection
	/// requires numeric or <c>boolean</c> data to analyze. The algorithms don’t
	/// support missing values therefore fields that have data types other than
	/// numeric or boolean are ignored. Documents where included fields contain
	/// missing values, null values, or an array are also ignored. Therefore the
	/// <c>dest</c> index may contain documents that don’t have an outlier score.
	/// Regression supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the regression analysis.
	/// Classification supports fields that are numeric, <c>boolean</c>, <c>text</c>,
	/// <c>keyword</c>, and <c>ip</c> data types. It is also tolerant of missing values.
	/// Fields that are supported are included in the analysis, other fields are
	/// ignored. Documents where included fields contain an array with two or
	/// more values are also ignored. Documents in the <c>dest</c> index that don’t
	/// contain a results field are not included in the classification analysis.
	/// Classification analysis can be improved by mapping ordinal variable
	/// values to a single number. For example, in case of age ranges, you can
	/// model the values as <c>0-14 = 0</c>, <c>15-24 = 1</c>, <c>25-34 = 2</c>, and so on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> AnalyzedFields(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor>? action)
	{
		Instance.AnalyzedFields = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Dest(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestination value)
	{
		Instance.Dest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Dest(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor<TDocument>> action)
	{
		Instance.Dest = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Headers(System.Collections.Generic.IDictionary<string, System.Collections.Generic.ICollection<string>>? value)
	{
		Instance.Headers = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Headers()
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Headers(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString>? action)
	{
		Instance.Headers = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringCollectionOfString.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> AddHeader(string key, System.Collections.Generic.ICollection<string> value)
	{
		Instance.Headers ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Headers.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> AddHeader(string key, params string[] values)
	{
		Instance.Headers ??= new System.Collections.Generic.Dictionary<string, System.Collections.Generic.ICollection<string>>();
		Instance.Headers.Add(key, [.. values]);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of threads to be used by the analysis. Using more
	/// threads may decrease the time necessary to complete the analysis at the
	/// cost of using more CPU. Note that the process may use additional threads
	/// for operational functionality other than the analysis itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> MaxNumThreads(int? value)
	{
		Instance.MaxNumThreads = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are permitted for
	/// analytical processing. If your <c>elasticsearch.yml</c> file contains an
	/// <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try
	/// to create data frame analytics jobs that have <c>model_memory_limit</c> values
	/// greater than that setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> ModelMemoryLimit(string? value)
	{
		Instance.ModelMemoryLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSource value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Source(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor<TDocument>> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutDataFrameAnalyticsRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}