// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class PutCalendarRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Create a calendar.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.PutCalendarRequestConverter))]
public sealed partial class PutCalendarRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutCalendarRequest(Elastic.Clients.Elasticsearch.Id calendarId) : base(r => r.Required("calendar_id", calendarId))
	{
	}
#if NET7_0_OR_GREATER
	public PutCalendarRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutCalendarRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningPutCalendar;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.put_calendar";

	/// <summary>
	/// <para>
	/// A string that uniquely identifies a calendar.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id CalendarId { get => P<Elastic.Clients.Elasticsearch.Id>("calendar_id"); set => PR("calendar_id", value); }

	/// <summary>
	/// <para>
	/// A description of the calendar.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// An array of anomaly detection job identifiers.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id>? JobIds { get; set; }
}

/// <summary>
/// <para>
/// Create a calendar.
/// </para>
/// </summary>
public readonly partial struct PutCalendarRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutCalendarRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest instance)
	{
		Instance = instance;
	}

	public PutCalendarRequestDescriptor(Elastic.Clients.Elasticsearch.Id calendarId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest(calendarId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutCalendarRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest(Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A string that uniquely identifies a calendar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor CalendarId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.CalendarId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the calendar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of anomaly detection job identifiers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor JobIds(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id>? value)
	{
		Instance.JobIds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of anomaly detection job identifiers.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor JobIds(params Elastic.Clients.Elasticsearch.Id[] values)
	{
		Instance.JobIds = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.PutCalendarRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}