// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning.Json;

public sealed partial class MlInfoResponseConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse>
{
	private static readonly System.Text.Json.JsonEncodedText PropDefaults = System.Text.Json.JsonEncodedText.Encode("defaults");
	private static readonly System.Text.Json.JsonEncodedText PropLimits = System.Text.Json.JsonEncodedText.Encode("limits");
	private static readonly System.Text.Json.JsonEncodedText PropNativeCode = System.Text.Json.JsonEncodedText.Encode("native_code");
	private static readonly System.Text.Json.JsonEncodedText PropUpgradeMode = System.Text.Json.JsonEncodedText.Encode("upgrade_mode");

	public override Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.Defaults> propDefaults = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.Limits> propLimits = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.MachineLearning.NativeCode> propNativeCode = default;
		LocalJsonValue<bool> propUpgradeMode = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDefaults.TryReadProperty(ref reader, options, PropDefaults, null))
			{
				continue;
			}

			if (propLimits.TryReadProperty(ref reader, options, PropLimits, null))
			{
				continue;
			}

			if (propNativeCode.TryReadProperty(ref reader, options, PropNativeCode, null))
			{
				continue;
			}

			if (propUpgradeMode.TryReadProperty(ref reader, options, PropUpgradeMode, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Defaults = propDefaults.Value,
			Limits = propLimits.Value,
			NativeCode = propNativeCode.Value,
			UpgradeMode = propUpgradeMode.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.MachineLearning.MlInfoResponse value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDefaults, value.Defaults, null, null);
		writer.WriteProperty(options, PropLimits, value.Limits, null, null);
		writer.WriteProperty(options, PropNativeCode, value.NativeCode, null, null);
		writer.WriteProperty(options, PropUpgradeMode, value.UpgradeMode, null, null);
		writer.WriteEndObject();
	}
}