// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class InferTrainedModelRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Controls the amount of time to wait for inference results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Evaluate a trained model.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.InferTrainedModelRequestConverter))]
public sealed partial class InferTrainedModelRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferTrainedModelRequest(Elastic.Clients.Elasticsearch.Id modelId) : base(r => r.Required("model_id", modelId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferTrainedModelRequest(Elastic.Clients.Elasticsearch.Id modelId, System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, object>> docs) : base(r => r.Required("model_id", modelId))
	{
		Docs = docs;
	}
#if NET7_0_OR_GREATER
	public InferTrainedModelRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferTrainedModelRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningInferTrainedModel;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.infer_trained_model";

	/// <summary>
	/// <para>
	/// The unique identifier of the trained model.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id ModelId { get => P<Elastic.Clients.Elasticsearch.Id>("model_id"); set => PR("model_id", value); }

	/// <summary>
	/// <para>
	/// Controls the amount of time to wait for inference results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// An array of objects to pass to the model for inference. The objects should contain a fields matching your
	/// configured trained model input. Typically, for NLP models, the field name is <c>text_field</c>.
	/// Currently, for NLP models, only a single value is allowed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, object>> Docs { get; set; }

	/// <summary>
	/// <para>
	/// The inference configuration updates to apply on the API call
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigUpdate? InferenceConfig { get; set; }
}

/// <summary>
/// <para>
/// Evaluate a trained model.
/// </para>
/// </summary>
public readonly partial struct InferTrainedModelRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferTrainedModelRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest instance)
	{
		Instance = instance;
	}

	public InferTrainedModelRequestDescriptor(Elastic.Clients.Elasticsearch.Id modelId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest(modelId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public InferTrainedModelRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest(Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the trained model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor ModelId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls the amount of time to wait for inference results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of objects to pass to the model for inference. The objects should contain a fields matching your
	/// configured trained model input. Typically, for NLP models, the field name is <c>text_field</c>.
	/// Currently, for NLP models, only a single value is allowed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor Docs(System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, object>> value)
	{
		Instance.Docs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of objects to pass to the model for inference. The objects should contain a fields matching your
	/// configured trained model input. Typically, for NLP models, the field name is <c>text_field</c>.
	/// Currently, for NLP models, only a single value is allowed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor Docs(params System.Collections.Generic.IDictionary<string, object>[] values)
	{
		Instance.Docs = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of objects to pass to the model for inference. The objects should contain a fields matching your
	/// configured trained model input. Typically, for NLP models, the field name is <c>text_field</c>.
	/// Currently, for NLP models, only a single value is allowed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor Docs(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, object>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action));
		}

		Instance.Docs = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The inference configuration updates to apply on the API call
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor InferenceConfig(Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigUpdate? value)
	{
		Instance.InferenceConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The inference configuration updates to apply on the API call
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor InferenceConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigUpdateDescriptor> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigUpdateDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The inference configuration updates to apply on the API call
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor InferenceConfig<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigUpdateDescriptor<T>> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigUpdateDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Evaluate a trained model.
/// </para>
/// </summary>
public readonly partial struct InferTrainedModelRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferTrainedModelRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest instance)
	{
		Instance = instance;
	}

	public InferTrainedModelRequestDescriptor(Elastic.Clients.Elasticsearch.Id modelId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest(modelId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public InferTrainedModelRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest(Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the trained model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> ModelId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.ModelId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls the amount of time to wait for inference results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of objects to pass to the model for inference. The objects should contain a fields matching your
	/// configured trained model input. Typically, for NLP models, the field name is <c>text_field</c>.
	/// Currently, for NLP models, only a single value is allowed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> Docs(System.Collections.Generic.ICollection<System.Collections.Generic.IDictionary<string, object>> value)
	{
		Instance.Docs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of objects to pass to the model for inference. The objects should contain a fields matching your
	/// configured trained model input. Typically, for NLP models, the field name is <c>text_field</c>.
	/// Currently, for NLP models, only a single value is allowed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> Docs(params System.Collections.Generic.IDictionary<string, object>[] values)
	{
		Instance.Docs = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of objects to pass to the model for inference. The objects should contain a fields matching your
	/// configured trained model input. Typically, for NLP models, the field name is <c>text_field</c>.
	/// Currently, for NLP models, only a single value is allowed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> Docs(params System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>?[] actions)
	{
		var items = new System.Collections.Generic.List<System.Collections.Generic.IDictionary<string, object>>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action));
		}

		Instance.Docs = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The inference configuration updates to apply on the API call
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> InferenceConfig(Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigUpdate? value)
	{
		Instance.InferenceConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The inference configuration updates to apply on the API call
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> InferenceConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigUpdateDescriptor<TDocument>> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.MachineLearning.InferenceConfigUpdateDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.InferTrainedModelRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}