// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class GetRecordsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Skips the specified number of records.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of records to obtain.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }
}

/// <summary>
/// <para>
/// Get anomaly records for an anomaly detection job.
/// Records contain the detailed analytical results. They describe the anomalous
/// activity that has been identified in the input data based on the detector
/// configuration.
/// There can be many anomaly records depending on the characteristics and size
/// of the input data. In practice, there are often too many to be able to
/// manually process them. The machine learning features therefore perform a
/// sophisticated aggregation of the anomaly records into buckets.
/// The number of record results depends on the number of anomalies found in each
/// bucket, which relates to the number of time series being modeled and the
/// number of detectors.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.GetRecordsRequestConverter))]
public sealed partial class GetRecordsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetRecordsRequest(Elastic.Clients.Elasticsearch.Id jobId) : base(r => r.Required("job_id", jobId))
	{
	}
#if NET7_0_OR_GREATER
	public GetRecordsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetRecordsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningGetRecords;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.get_records";

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id JobId { get => P<Elastic.Clients.Elasticsearch.Id>("job_id"); set => PR("job_id", value); }

	/// <summary>
	/// <para>
	/// Skips the specified number of records.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of records to obtain.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>desc</c> query parameter.
	/// </para>
	/// </summary>
	public bool? Desc { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? End { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>exclude_interim</c> query parameter.
	/// </para>
	/// </summary>
	public bool? ExcludeInterim { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.Page? Page { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>record_score</c> query parameter.
	/// </para>
	/// </summary>
	public double? RecordScore { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Sort { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? Start { get; set; }
}

/// <summary>
/// <para>
/// Get anomaly records for an anomaly detection job.
/// Records contain the detailed analytical results. They describe the anomalous
/// activity that has been identified in the input data based on the detector
/// configuration.
/// There can be many anomaly records depending on the characteristics and size
/// of the input data. In practice, there are often too many to be able to
/// manually process them. The machine learning features therefore perform a
/// sophisticated aggregation of the anomaly records into buckets.
/// The number of record results depends on the number of anomalies found in each
/// bucket, which relates to the number of time series being modeled and the
/// number of detectors.
/// </para>
/// </summary>
public readonly partial struct GetRecordsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetRecordsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest instance)
	{
		Instance = instance;
	}

	public GetRecordsRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest(jobId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetRecordsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest(Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Skips the specified number of records.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of records to obtain.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>desc</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Desc(bool? value = true)
	{
		Instance.Desc = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor End(System.DateTimeOffset? value)
	{
		Instance.End = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>exclude_interim</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor ExcludeInterim(bool? value = true)
	{
		Instance.ExcludeInterim = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Page(Elastic.Clients.Elasticsearch.MachineLearning.Page? value)
	{
		Instance.Page = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Page()
	{
		Instance.Page = Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Page(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor>? action)
	{
		Instance.Page = Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>record_score</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor RecordScore(double? value)
	{
		Instance.RecordScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Sort(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Sort<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Start(System.DateTimeOffset? value)
	{
		Instance.Start = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Get anomaly records for an anomaly detection job.
/// Records contain the detailed analytical results. They describe the anomalous
/// activity that has been identified in the input data based on the detector
/// configuration.
/// There can be many anomaly records depending on the characteristics and size
/// of the input data. In practice, there are often too many to be able to
/// manually process them. The machine learning features therefore perform a
/// sophisticated aggregation of the anomaly records into buckets.
/// The number of record results depends on the number of anomalies found in each
/// bucket, which relates to the number of time series being modeled and the
/// number of detectors.
/// </para>
/// </summary>
public readonly partial struct GetRecordsRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetRecordsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest instance)
	{
		Instance = instance;
	}

	public GetRecordsRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest(jobId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetRecordsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest(Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Skips the specified number of records.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of records to obtain.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>desc</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Desc(bool? value = true)
	{
		Instance.Desc = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> End(System.DateTimeOffset? value)
	{
		Instance.End = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>exclude_interim</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> ExcludeInterim(bool? value = true)
	{
		Instance.ExcludeInterim = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Page(Elastic.Clients.Elasticsearch.MachineLearning.Page? value)
	{
		Instance.Page = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Page()
	{
		Instance.Page = Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Page(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor>? action)
	{
		Instance.Page = Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>record_score</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> RecordScore(double? value)
	{
		Instance.RecordScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Sort(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Sort(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Start(System.DateTimeOffset? value)
	{
		Instance.Start = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetRecordsRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}