// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class GetOverallBucketsRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get overall bucket results.
/// </para>
/// <para>
/// Retrievs overall bucket results that summarize the bucket results of
/// multiple anomaly detection jobs.
/// </para>
/// <para>
/// The <c>overall_score</c> is calculated by combining the scores of all the
/// buckets within the overall bucket span. First, the maximum
/// <c>anomaly_score</c> per anomaly detection job in the overall bucket is
/// calculated. Then the <c>top_n</c> of those scores are averaged to result in
/// the <c>overall_score</c>. This means that you can fine-tune the
/// <c>overall_score</c> so that it is more or less sensitive to the number of
/// jobs that detect an anomaly at the same time. For example, if you set
/// <c>top_n</c> to <c>1</c>, the <c>overall_score</c> is the maximum bucket score in the
/// overall bucket. Alternatively, if you set <c>top_n</c> to the number of jobs,
/// the <c>overall_score</c> is high only when all jobs detect anomalies in that
/// overall bucket. If you set the <c>bucket_span</c> parameter (to a value
/// greater than its default), the <c>overall_score</c> is the maximum
/// <c>overall_score</c> of the overall buckets that have a span equal to the
/// jobs' largest bucket span.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.GetOverallBucketsRequestConverter))]
public sealed partial class GetOverallBucketsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetOverallBucketsRequest(Elastic.Clients.Elasticsearch.Id jobId) : base(r => r.Required("job_id", jobId))
	{
	}
#if NET7_0_OR_GREATER
	public GetOverallBucketsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetOverallBucketsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningGetOverallBuckets;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.get_overall_buckets";

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job. It can be a job identifier, a
	/// group name, a comma-separated list of jobs or groups, or a wildcard
	/// expression.
	/// </para>
	/// <para>
	/// You can summarize the bucket results for all anomaly detection jobs by
	/// using <c>_all</c> or by specifying <c>*</c> as the <c>&lt;job_id></c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id JobId { get => P<Elastic.Clients.Elasticsearch.Id>("job_id"); set => PR("job_id", value); }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>allow_no_match</c> query parameter.
	/// </para>
	/// </summary>
	public bool? AllowNoMatch { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>bucket_span</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? BucketSpan { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? End { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>exclude_interim</c> query parameter.
	/// </para>
	/// </summary>
	public bool? ExcludeInterim { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>overall_score</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<double, string>? OverallScore { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? Start { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>top_n</c> query parameter.
	/// </para>
	/// </summary>
	public int? TopN { get; set; }
}

/// <summary>
/// <para>
/// Get overall bucket results.
/// </para>
/// <para>
/// Retrievs overall bucket results that summarize the bucket results of
/// multiple anomaly detection jobs.
/// </para>
/// <para>
/// The <c>overall_score</c> is calculated by combining the scores of all the
/// buckets within the overall bucket span. First, the maximum
/// <c>anomaly_score</c> per anomaly detection job in the overall bucket is
/// calculated. Then the <c>top_n</c> of those scores are averaged to result in
/// the <c>overall_score</c>. This means that you can fine-tune the
/// <c>overall_score</c> so that it is more or less sensitive to the number of
/// jobs that detect an anomaly at the same time. For example, if you set
/// <c>top_n</c> to <c>1</c>, the <c>overall_score</c> is the maximum bucket score in the
/// overall bucket. Alternatively, if you set <c>top_n</c> to the number of jobs,
/// the <c>overall_score</c> is high only when all jobs detect anomalies in that
/// overall bucket. If you set the <c>bucket_span</c> parameter (to a value
/// greater than its default), the <c>overall_score</c> is the maximum
/// <c>overall_score</c> of the overall buckets that have a span equal to the
/// jobs' largest bucket span.
/// </para>
/// </summary>
public readonly partial struct GetOverallBucketsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetOverallBucketsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest instance)
	{
		Instance = instance;
	}

	public GetOverallBucketsRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest(jobId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetOverallBucketsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest(Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job. It can be a job identifier, a
	/// group name, a comma-separated list of jobs or groups, or a wildcard
	/// expression.
	/// </para>
	/// <para>
	/// You can summarize the bucket results for all anomaly detection jobs by
	/// using <c>_all</c> or by specifying <c>*</c> as the <c>&lt;job_id></c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>allow_no_match</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor AllowNoMatch(bool? value = true)
	{
		Instance.AllowNoMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>bucket_span</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor BucketSpan(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.BucketSpan = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor End(System.DateTimeOffset? value)
	{
		Instance.End = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>exclude_interim</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor ExcludeInterim(bool? value = true)
	{
		Instance.ExcludeInterim = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>overall_score</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor OverallScore(Elastic.Clients.Elasticsearch.Union<double, string>? value)
	{
		Instance.OverallScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor Start(System.DateTimeOffset? value)
	{
		Instance.Start = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>top_n</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor TopN(int? value)
	{
		Instance.TopN = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetOverallBucketsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}