// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class GetModelSnapshotsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Skips the specified number of snapshots.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of snapshots to obtain.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }
}

/// <summary>
/// <para>
/// Get model snapshots info.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.GetModelSnapshotsRequestConverter))]
public sealed partial class GetModelSnapshotsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetModelSnapshotsRequest(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? snapshotId) : base(r => r.Required("job_id", jobId).Optional("snapshot_id", snapshotId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetModelSnapshotsRequest(Elastic.Clients.Elasticsearch.Id jobId) : base(r => r.Required("job_id", jobId))
	{
	}
#if NET7_0_OR_GREATER
	public GetModelSnapshotsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetModelSnapshotsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningGetModelSnapshots;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.get_model_snapshots";

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id JobId { get => P<Elastic.Clients.Elasticsearch.Id>("job_id"); set => PR("job_id", value); }

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the model snapshot. You can get information for multiple
	/// snapshots by using a comma-separated list or a wildcard expression. You can get all snapshots by using <c>_all</c>,
	/// by specifying <c>*</c> as the snapshot ID, or by omitting the snapshot ID.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? SnapshotId { get => P<Elastic.Clients.Elasticsearch.Id?>("snapshot_id"); set => PO("snapshot_id", value); }

	/// <summary>
	/// <para>
	/// Skips the specified number of snapshots.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of snapshots to obtain.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>desc</c> query parameter.
	/// </para>
	/// </summary>
	public bool? Desc { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? End { get; set; }
	public Elastic.Clients.Elasticsearch.MachineLearning.Page? Page { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Sort { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? Start { get; set; }
}

/// <summary>
/// <para>
/// Get model snapshots info.
/// </para>
/// </summary>
public readonly partial struct GetModelSnapshotsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetModelSnapshotsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest instance)
	{
		Instance = instance;
	}

	public GetModelSnapshotsRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? snapshotId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest(jobId, snapshotId);
	}

	public GetModelSnapshotsRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest(jobId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetModelSnapshotsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the model snapshot. You can get information for multiple
	/// snapshots by using a comma-separated list or a wildcard expression. You can get all snapshots by using <c>_all</c>,
	/// by specifying <c>*</c> as the snapshot ID, or by omitting the snapshot ID.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor SnapshotId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.SnapshotId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Skips the specified number of snapshots.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of snapshots to obtain.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>desc</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Desc(bool? value = true)
	{
		Instance.Desc = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor End(System.DateTimeOffset? value)
	{
		Instance.End = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Page(Elastic.Clients.Elasticsearch.MachineLearning.Page? value)
	{
		Instance.Page = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Page()
	{
		Instance.Page = Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Page(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor>? action)
	{
		Instance.Page = Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Sort(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Sort<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Start(System.DateTimeOffset? value)
	{
		Instance.Start = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Get model snapshots info.
/// </para>
/// </summary>
public readonly partial struct GetModelSnapshotsRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetModelSnapshotsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest instance)
	{
		Instance = instance;
	}

	public GetModelSnapshotsRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId, Elastic.Clients.Elasticsearch.Id? snapshotId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest(jobId, snapshotId);
	}

	public GetModelSnapshotsRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest(jobId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetModelSnapshotsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest(Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the model snapshot. You can get information for multiple
	/// snapshots by using a comma-separated list or a wildcard expression. You can get all snapshots by using <c>_all</c>,
	/// by specifying <c>*</c> as the snapshot ID, or by omitting the snapshot ID.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> SnapshotId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.SnapshotId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Skips the specified number of snapshots.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of snapshots to obtain.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>desc</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Desc(bool? value = true)
	{
		Instance.Desc = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> End(System.DateTimeOffset? value)
	{
		Instance.End = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Page(Elastic.Clients.Elasticsearch.MachineLearning.Page? value)
	{
		Instance.Page = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Page()
	{
		Instance.Page = Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Page(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor>? action)
	{
		Instance.Page = Elastic.Clients.Elasticsearch.MachineLearning.PageDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Sort(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>sort</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Sort(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Start(System.DateTimeOffset? value)
	{
		Instance.Start = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetModelSnapshotsRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}