// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class GetJobsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies what to do when the request:
	/// </para>
	/// <list type="number">
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are no jobs that match.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains the _all string or no identifiers and there are no matches.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are only partial matches.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// The default value is <c>true</c>, which returns an empty <c>jobs</c> array when
	/// there are no matches and the subset of results when there are partial
	/// matches. If this parameter is <c>false</c>, the request returns a <c>404</c> status
	/// code when there are no matches or only partial matches.
	/// </para>
	/// </summary>
	public bool? AllowNoMatch { get => Q<bool?>("allow_no_match"); set => Q("allow_no_match", value); }

	/// <summary>
	/// <para>
	/// Indicates if certain fields should be removed from the configuration on
	/// retrieval. This allows the configuration to be in an acceptable format to
	/// be retrieved and then added to another cluster.
	/// </para>
	/// </summary>
	public bool? ExcludeGenerated { get => Q<bool?>("exclude_generated"); set => Q("exclude_generated", value); }
}

/// <summary>
/// <para>
/// Get anomaly detection jobs configuration info.
/// You can get information for multiple anomaly detection jobs in a single API
/// request by using a group name, a comma-separated list of jobs, or a wildcard
/// expression. You can get information for all anomaly detection jobs by using
/// <c>_all</c>, by specifying <c>*</c> as the <c>&lt;job_id></c>, or by omitting the <c>&lt;job_id></c>.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.GetJobsRequestConverter))]
public sealed partial class GetJobsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestParameters>
{
	public GetJobsRequest(Elastic.Clients.Elasticsearch.Ids? jobId) : base(r => r.Optional("job_id", jobId))
	{
	}
#if NET7_0_OR_GREATER
	public GetJobsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetJobsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetJobsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningGetJobs;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "ml.get_jobs";

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job. It can be a job identifier, a
	/// group name, or a wildcard expression. If you do not specify one of these
	/// options, the API returns information for all anomaly detection jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ids? JobId { get => P<Elastic.Clients.Elasticsearch.Ids?>("job_id"); set => PO("job_id", value); }

	/// <summary>
	/// <para>
	/// Specifies what to do when the request:
	/// </para>
	/// <list type="number">
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are no jobs that match.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains the _all string or no identifiers and there are no matches.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are only partial matches.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// The default value is <c>true</c>, which returns an empty <c>jobs</c> array when
	/// there are no matches and the subset of results when there are partial
	/// matches. If this parameter is <c>false</c>, the request returns a <c>404</c> status
	/// code when there are no matches or only partial matches.
	/// </para>
	/// </summary>
	public bool? AllowNoMatch { get => Q<bool?>("allow_no_match"); set => Q("allow_no_match", value); }

	/// <summary>
	/// <para>
	/// Indicates if certain fields should be removed from the configuration on
	/// retrieval. This allows the configuration to be in an acceptable format to
	/// be retrieved and then added to another cluster.
	/// </para>
	/// </summary>
	public bool? ExcludeGenerated { get => Q<bool?>("exclude_generated"); set => Q("exclude_generated", value); }
}

/// <summary>
/// <para>
/// Get anomaly detection jobs configuration info.
/// You can get information for multiple anomaly detection jobs in a single API
/// request by using a group name, a comma-separated list of jobs, or a wildcard
/// expression. You can get information for all anomaly detection jobs by using
/// <c>_all</c>, by specifying <c>*</c> as the <c>&lt;job_id></c>, or by omitting the <c>&lt;job_id></c>.
/// </para>
/// </summary>
public readonly partial struct GetJobsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetJobsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest instance)
	{
		Instance = instance;
	}

	public GetJobsRequestDescriptor(Elastic.Clients.Elasticsearch.Ids? jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest(jobId);
	}

	public GetJobsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest(Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job. It can be a job identifier, a
	/// group name, or a wildcard expression. If you do not specify one of these
	/// options, the API returns information for all anomaly detection jobs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Ids? value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies what to do when the request:
	/// </para>
	/// <list type="number">
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are no jobs that match.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains the _all string or no identifiers and there are no matches.
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Contains wildcard expressions and there are only partial matches.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// The default value is <c>true</c>, which returns an empty <c>jobs</c> array when
	/// there are no matches and the subset of results when there are partial
	/// matches. If this parameter is <c>false</c>, the request returns a <c>404</c> status
	/// code when there are no matches or only partial matches.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor AllowNoMatch(bool? value = true)
	{
		Instance.AllowNoMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates if certain fields should be removed from the configuration on
	/// retrieval. This allows the configuration to be in an acceptable format to
	/// be retrieved and then added to another cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor ExcludeGenerated(bool? value = true)
	{
		Instance.ExcludeGenerated = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.GetJobsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}