// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class FlushJobRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Force buffered data to be processed.
/// The flush jobs API is only applicable when sending data for analysis using
/// the post data API. Depending on the content of the buffer, then it might
/// additionally calculate new results. Both flush and close operations are
/// similar, however the flush is more efficient if you are expecting to send
/// more data for analysis. When flushing, the job remains open and is available
/// to continue analyzing data. A close operation additionally prunes and
/// persists the model state to disk and the job must be opened again before
/// analyzing further data.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.FlushJobRequestConverter))]
public sealed partial class FlushJobRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FlushJobRequest(Elastic.Clients.Elasticsearch.Id jobId) : base(r => r.Required("job_id", jobId))
	{
	}
#if NET7_0_OR_GREATER
	public FlushJobRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FlushJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningFlushJob;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.flush_job";

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id JobId { get => P<Elastic.Clients.Elasticsearch.Id>("job_id"); set => PR("job_id", value); }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>advance_time</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? AdvanceTime { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>calc_interim</c> query parameter.
	/// </para>
	/// </summary>
	public bool? CalcInterim { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? End { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>skip_time</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? SkipTime { get; set; }

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? Start { get; set; }
}

/// <summary>
/// <para>
/// Force buffered data to be processed.
/// The flush jobs API is only applicable when sending data for analysis using
/// the post data API. Depending on the content of the buffer, then it might
/// additionally calculate new results. Both flush and close operations are
/// similar, however the flush is more efficient if you are expecting to send
/// more data for analysis. When flushing, the job remains open and is available
/// to continue analyzing data. A close operation additionally prunes and
/// persists the model state to disk and the job must be opened again before
/// analyzing further data.
/// </para>
/// </summary>
public readonly partial struct FlushJobRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FlushJobRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest instance)
	{
		Instance = instance;
	}

	public FlushJobRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest(jobId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public FlushJobRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest(Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>advance_time</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor AdvanceTime(System.DateTimeOffset? value)
	{
		Instance.AdvanceTime = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>calc_interim</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor CalcInterim(bool? value = true)
	{
		Instance.CalcInterim = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>end</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor End(System.DateTimeOffset? value)
	{
		Instance.End = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>skip_time</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor SkipTime(System.DateTimeOffset? value)
	{
		Instance.SkipTime = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Refer to the description for the <c>start</c> query parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor Start(System.DateTimeOffset? value)
	{
		Instance.Start = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.FlushJobRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}