// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class ExplainDataFrameAnalyticsRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Explain data frame analytics config.
/// </para>
/// <para>
/// This API provides explanations for a data frame analytics config that either
/// exists already or one that has not been created yet. The following
/// explanations are provided:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// which fields are included or not in the analysis and why,
/// </para>
/// </item>
/// <item>
/// <para>
/// how much memory is estimated to be required. The estimate can be used when deciding the appropriate value for model_memory_limit setting later on.
/// If you have object fields or fields that are excluded via source filtering, they are not included in the explanation.
/// </para>
/// </item>
/// </list>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.ExplainDataFrameAnalyticsRequestConverter))]
public sealed partial class ExplainDataFrameAnalyticsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestParameters>
{
	public ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Id? id) : base(r => r.Optional("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public ExplainDataFrameAnalyticsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ExplainDataFrameAnalyticsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningExplainDataFrameAnalytics;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.explain_data_frame_analytics";

	/// <summary>
	/// <para>
	/// Identifier for the data frame analytics job. This identifier can contain
	/// lowercase alphanumeric characters (a-z and 0-9), hyphens, and
	/// underscores. It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? Id { get => P<Elastic.Clients.Elasticsearch.Id?>("id"); set => PO("id", value); }

	/// <summary>
	/// <para>
	/// Specifies whether this job can start when there is insufficient machine
	/// learning node capacity for it to be immediately assigned to a node.
	/// </para>
	/// </summary>
	public bool? AllowLazyStart { get; set; }

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis? Analysis { get; set; }

	/// <summary>
	/// <para>
	/// Specify includes and/or excludes patterns to select which fields will be
	/// included in the analysis. The patterns specified in excludes are applied
	/// last, therefore excludes takes precedence. In other words, if the same
	/// field is specified in both includes and excludes, then the field will not
	/// be included in the analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFields? AnalyzedFields { get; set; }

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// The destination configuration, consisting of index and optionally
	/// results_field (ml by default).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestination? Dest { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of threads to be used by the analysis. Using more
	/// threads may decrease the time necessary to complete the analysis at the
	/// cost of using more CPU. Note that the process may use additional threads
	/// for operational functionality other than the analysis itself.
	/// </para>
	/// </summary>
	public int? MaxNumThreads { get; set; }

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are permitted for
	/// analytical processing. If your <c>elasticsearch.yml</c> file contains an
	/// <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try to
	/// create data frame analytics jobs that have <c>model_memory_limit</c> values
	/// greater than that setting.
	/// </para>
	/// </summary>
	public string? ModelMemoryLimit { get; set; }

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data. It requires an
	/// index. Optionally, query and _source may be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSource? Source { get; set; }
}

/// <summary>
/// <para>
/// Explain data frame analytics config.
/// </para>
/// <para>
/// This API provides explanations for a data frame analytics config that either
/// exists already or one that has not been created yet. The following
/// explanations are provided:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// which fields are included or not in the analysis and why,
/// </para>
/// </item>
/// <item>
/// <para>
/// how much memory is estimated to be required. The estimate can be used when deciding the appropriate value for model_memory_limit setting later on.
/// If you have object fields or fields that are excluded via source filtering, they are not included in the explanation.
/// </para>
/// </item>
/// </list>
/// </summary>
public readonly partial struct ExplainDataFrameAnalyticsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExplainDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest instance)
	{
		Instance = instance;
	}

	public ExplainDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.Id? id)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(id);
	}

	public ExplainDataFrameAnalyticsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the data frame analytics job. This identifier can contain
	/// lowercase alphanumeric characters (a-z and 0-9), hyphens, and
	/// underscores. It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether this job can start when there is insufficient machine
	/// learning node capacity for it to be immediately assigned to a node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor AllowLazyStart(bool? value = true)
	{
		Instance.AllowLazyStart = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Analysis(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis? value)
	{
		Instance.Analysis = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Analysis(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor> action)
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Analysis<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<T>> action)
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify includes and/or excludes patterns to select which fields will be
	/// included in the analysis. The patterns specified in excludes are applied
	/// last, therefore excludes takes precedence. In other words, if the same
	/// field is specified in both includes and excludes, then the field will not
	/// be included in the analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor AnalyzedFields(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFields? value)
	{
		Instance.AnalyzedFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify includes and/or excludes patterns to select which fields will be
	/// included in the analysis. The patterns specified in excludes are applied
	/// last, therefore excludes takes precedence. In other words, if the same
	/// field is specified in both includes and excludes, then the field will not
	/// be included in the analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor AnalyzedFields()
	{
		Instance.AnalyzedFields = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify includes and/or excludes patterns to select which fields will be
	/// included in the analysis. The patterns specified in excludes are applied
	/// last, therefore excludes takes precedence. In other words, if the same
	/// field is specified in both includes and excludes, then the field will not
	/// be included in the analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor AnalyzedFields(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor>? action)
	{
		Instance.AnalyzedFields = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration, consisting of index and optionally
	/// results_field (ml by default).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Dest(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestination? value)
	{
		Instance.Dest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration, consisting of index and optionally
	/// results_field (ml by default).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Dest(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor> action)
	{
		Instance.Dest = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration, consisting of index and optionally
	/// results_field (ml by default).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Dest<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor<T>> action)
	{
		Instance.Dest = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of threads to be used by the analysis. Using more
	/// threads may decrease the time necessary to complete the analysis at the
	/// cost of using more CPU. Note that the process may use additional threads
	/// for operational functionality other than the analysis itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor MaxNumThreads(int? value)
	{
		Instance.MaxNumThreads = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are permitted for
	/// analytical processing. If your <c>elasticsearch.yml</c> file contains an
	/// <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try to
	/// create data frame analytics jobs that have <c>model_memory_limit</c> values
	/// greater than that setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor ModelMemoryLimit(string? value)
	{
		Instance.ModelMemoryLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data. It requires an
	/// index. Optionally, query and _source may be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Source(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSource? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data. It requires an
	/// index. Optionally, query and _source may be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Source(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data. It requires an
	/// index. Optionally, query and _source may be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Source<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor<T>> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Explain data frame analytics config.
/// </para>
/// <para>
/// This API provides explanations for a data frame analytics config that either
/// exists already or one that has not been created yet. The following
/// explanations are provided:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// which fields are included or not in the analysis and why,
/// </para>
/// </item>
/// <item>
/// <para>
/// how much memory is estimated to be required. The estimate can be used when deciding the appropriate value for model_memory_limit setting later on.
/// If you have object fields or fields that are excluded via source filtering, they are not included in the explanation.
/// </para>
/// </item>
/// </list>
/// </summary>
public readonly partial struct ExplainDataFrameAnalyticsRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExplainDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest instance)
	{
		Instance = instance;
	}

	public ExplainDataFrameAnalyticsRequestDescriptor(Elastic.Clients.Elasticsearch.Id? id)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(id);
	}

	public ExplainDataFrameAnalyticsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the data frame analytics job. This identifier can contain
	/// lowercase alphanumeric characters (a-z and 0-9), hyphens, and
	/// underscores. It must start and end with alphanumeric characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether this job can start when there is insufficient machine
	/// learning node capacity for it to be immediately assigned to a node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> AllowLazyStart(bool? value = true)
	{
		Instance.AllowLazyStart = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Analysis(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysis? value)
	{
		Instance.Analysis = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analysis configuration, which contains the information necessary to
	/// perform one of the following types of analysis: classification, outlier
	/// detection, or regression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Analysis(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument>> action)
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify includes and/or excludes patterns to select which fields will be
	/// included in the analysis. The patterns specified in excludes are applied
	/// last, therefore excludes takes precedence. In other words, if the same
	/// field is specified in both includes and excludes, then the field will not
	/// be included in the analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> AnalyzedFields(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFields? value)
	{
		Instance.AnalyzedFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify includes and/or excludes patterns to select which fields will be
	/// included in the analysis. The patterns specified in excludes are applied
	/// last, therefore excludes takes precedence. In other words, if the same
	/// field is specified in both includes and excludes, then the field will not
	/// be included in the analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> AnalyzedFields()
	{
		Instance.AnalyzedFields = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify includes and/or excludes patterns to select which fields will be
	/// included in the analysis. The patterns specified in excludes are applied
	/// last, therefore excludes takes precedence. In other words, if the same
	/// field is specified in both includes and excludes, then the field will not
	/// be included in the analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> AnalyzedFields(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor>? action)
	{
		Instance.AnalyzedFields = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalysisAnalyzedFieldsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A description of the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration, consisting of index and optionally
	/// results_field (ml by default).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Dest(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestination? value)
	{
		Instance.Dest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The destination configuration, consisting of index and optionally
	/// results_field (ml by default).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Dest(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor<TDocument>> action)
	{
		Instance.Dest = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsDestinationDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of threads to be used by the analysis. Using more
	/// threads may decrease the time necessary to complete the analysis at the
	/// cost of using more CPU. Note that the process may use additional threads
	/// for operational functionality other than the analysis itself.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> MaxNumThreads(int? value)
	{
		Instance.MaxNumThreads = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The approximate maximum amount of memory resources that are permitted for
	/// analytical processing. If your <c>elasticsearch.yml</c> file contains an
	/// <c>xpack.ml.max_model_memory_limit</c> setting, an error occurs when you try to
	/// create data frame analytics jobs that have <c>model_memory_limit</c> values
	/// greater than that setting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> ModelMemoryLimit(string? value)
	{
		Instance.ModelMemoryLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data. It requires an
	/// index. Optionally, query and _source may be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSource? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration of how to source the analysis data. It requires an
	/// index. Optionally, query and _source may be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Source(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor<TDocument>> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.MachineLearning.DataframeAnalyticsSourceDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.ExplainDataFrameAnalyticsRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}