// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class EvaluateDataFrameRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Evaluate data frame analytics.
/// </para>
/// <para>
/// The API packages together commonly used evaluation metrics for various types
/// of machine learning features. This has been designed for use on indexes
/// created by data frame analytics. Evaluation requires both a ground truth
/// field and an analytics result field to be present.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.EvaluateDataFrameRequestConverter))]
public sealed partial class EvaluateDataFrameRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EvaluateDataFrameRequest(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation evaluation, Elastic.Clients.Elasticsearch.IndexName index)
	{
		Evaluation = evaluation;
		Index = index;
	}
#if NET7_0_OR_GREATER
	public EvaluateDataFrameRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public EvaluateDataFrameRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal EvaluateDataFrameRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningEvaluateDataFrame;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.evaluate_data_frame";

	/// <summary>
	/// <para>
	/// Defines the type of evaluation you want to perform.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation Evaluation { get; set; }

	/// <summary>
	/// <para>
	/// Defines the <c>index</c> in which the evaluation will be performed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get; set; }

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }
}

/// <summary>
/// <para>
/// Evaluate data frame analytics.
/// </para>
/// <para>
/// The API packages together commonly used evaluation metrics for various types
/// of machine learning features. This has been designed for use on indexes
/// created by data frame analytics. Evaluation requires both a ground truth
/// field and an analytics result field to be present.
/// </para>
/// </summary>
public readonly partial struct EvaluateDataFrameRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EvaluateDataFrameRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest instance)
	{
		Instance = instance;
	}

	public EvaluateDataFrameRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest(Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines the type of evaluation you want to perform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor Evaluation(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation value)
	{
		Instance.Evaluation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the type of evaluation you want to perform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor Evaluation(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor> action)
	{
		Instance.Evaluation = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the type of evaluation you want to perform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor Evaluation<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<T>> action)
	{
		Instance.Evaluation = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the <c>index</c> in which the evaluation will be performed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Evaluate data frame analytics.
/// </para>
/// <para>
/// The API packages together commonly used evaluation metrics for various types
/// of machine learning features. This has been designed for use on indexes
/// created by data frame analytics. Evaluation requires both a ground truth
/// field and an analytics result field to be present.
/// </para>
/// </summary>
public readonly partial struct EvaluateDataFrameRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EvaluateDataFrameRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest instance)
	{
		Instance = instance;
	}

	public EvaluateDataFrameRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest(Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines the type of evaluation you want to perform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> Evaluation(Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluation value)
	{
		Instance.Evaluation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the type of evaluation you want to perform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> Evaluation(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument>> action)
	{
		Instance.Evaluation = Elastic.Clients.Elasticsearch.MachineLearning.DataframeEvaluationDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the <c>index</c> in which the evaluation will be performed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query clause that retrieves a subset of data from the source index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EvaluateDataFrameRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}