// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class EstimateModelMemoryRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Estimate job model memory usage.
/// </para>
/// <para>
/// Make an estimation of the memory usage for an anomaly detection job model.
/// The estimate is based on analysis configuration details for the job and cardinality
/// estimates for the fields it references.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.EstimateModelMemoryRequestConverter))]
public sealed partial class EstimateModelMemoryRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestParameters>
{
#if NET7_0_OR_GREATER
	public EstimateModelMemoryRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public EstimateModelMemoryRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal EstimateModelMemoryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningEstimateModelMemory;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.estimate_model_memory";

	/// <summary>
	/// <para>
	/// For a list of the properties that you can specify in the
	/// <c>analysis_config</c> component of the body of this API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig? AnalysisConfig { get; set; }

	/// <summary>
	/// <para>
	/// Estimates of the highest cardinality in a single bucket that is observed
	/// for influencer fields over the time period that the job analyzes data.
	/// To produce a good answer, values must be provided for all influencer
	/// fields. Providing values for fields that are not listed as <c>influencers</c>
	/// has no effect on the estimation.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, long>? MaxBucketCardinality { get; set; }

	/// <summary>
	/// <para>
	/// Estimates of the cardinality that is observed for fields over the whole
	/// time period that the job analyzes data. To produce a good answer, values
	/// must be provided for fields referenced in the <c>by_field_name</c>,
	/// <c>over_field_name</c> and <c>partition_field_name</c> of any detectors. Providing
	/// values for other fields has no effect on the estimation. It can be
	/// omitted from the request if no detectors have a <c>by_field_name</c>,
	/// <c>over_field_name</c> or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, long>? OverallCardinality { get; set; }
}

/// <summary>
/// <para>
/// Estimate job model memory usage.
/// </para>
/// <para>
/// Make an estimation of the memory usage for an anomaly detection job model.
/// The estimate is based on analysis configuration details for the job and cardinality
/// estimates for the fields it references.
/// </para>
/// </summary>
public readonly partial struct EstimateModelMemoryRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EstimateModelMemoryRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest instance)
	{
		Instance = instance;
	}

	public EstimateModelMemoryRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest(Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a list of the properties that you can specify in the
	/// <c>analysis_config</c> component of the body of this API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor AnalysisConfig(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig? value)
	{
		Instance.AnalysisConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a list of the properties that you can specify in the
	/// <c>analysis_config</c> component of the body of this API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor AnalysisConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor> action)
	{
		Instance.AnalysisConfig = Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// For a list of the properties that you can specify in the
	/// <c>analysis_config</c> component of the body of this API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor AnalysisConfig<T>(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<T>> action)
	{
		Instance.AnalysisConfig = Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the highest cardinality in a single bucket that is observed
	/// for influencer fields over the time period that the job analyzes data.
	/// To produce a good answer, values must be provided for all influencer
	/// fields. Providing values for fields that are not listed as <c>influencers</c>
	/// has no effect on the estimation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor MaxBucketCardinality(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, long>? value)
	{
		Instance.MaxBucketCardinality = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the highest cardinality in a single bucket that is observed
	/// for influencer fields over the time period that the job analyzes data.
	/// To produce a good answer, values must be provided for all influencer
	/// fields. Providing values for fields that are not listed as <c>influencers</c>
	/// has no effect on the estimation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor MaxBucketCardinality()
	{
		Instance.MaxBucketCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the highest cardinality in a single bucket that is observed
	/// for influencer fields over the time period that the job analyzes data.
	/// To produce a good answer, values must be provided for all influencer
	/// fields. Providing values for fields that are not listed as <c>influencers</c>
	/// has no effect on the estimation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor MaxBucketCardinality(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong>? action)
	{
		Instance.MaxBucketCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the highest cardinality in a single bucket that is observed
	/// for influencer fields over the time period that the job analyzes data.
	/// To produce a good answer, values must be provided for all influencer
	/// fields. Providing values for fields that are not listed as <c>influencers</c>
	/// has no effect on the estimation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor MaxBucketCardinality<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<T>>? action)
	{
		Instance.MaxBucketCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor AddMaxBucketCardinality(Elastic.Clients.Elasticsearch.Field key, long value)
	{
		Instance.MaxBucketCardinality ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, long>();
		Instance.MaxBucketCardinality.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor AddMaxBucketCardinality<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, long value)
	{
		Instance.MaxBucketCardinality ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, long>();
		Instance.MaxBucketCardinality.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the cardinality that is observed for fields over the whole
	/// time period that the job analyzes data. To produce a good answer, values
	/// must be provided for fields referenced in the <c>by_field_name</c>,
	/// <c>over_field_name</c> and <c>partition_field_name</c> of any detectors. Providing
	/// values for other fields has no effect on the estimation. It can be
	/// omitted from the request if no detectors have a <c>by_field_name</c>,
	/// <c>over_field_name</c> or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor OverallCardinality(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, long>? value)
	{
		Instance.OverallCardinality = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the cardinality that is observed for fields over the whole
	/// time period that the job analyzes data. To produce a good answer, values
	/// must be provided for fields referenced in the <c>by_field_name</c>,
	/// <c>over_field_name</c> and <c>partition_field_name</c> of any detectors. Providing
	/// values for other fields has no effect on the estimation. It can be
	/// omitted from the request if no detectors have a <c>by_field_name</c>,
	/// <c>over_field_name</c> or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor OverallCardinality()
	{
		Instance.OverallCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the cardinality that is observed for fields over the whole
	/// time period that the job analyzes data. To produce a good answer, values
	/// must be provided for fields referenced in the <c>by_field_name</c>,
	/// <c>over_field_name</c> and <c>partition_field_name</c> of any detectors. Providing
	/// values for other fields has no effect on the estimation. It can be
	/// omitted from the request if no detectors have a <c>by_field_name</c>,
	/// <c>over_field_name</c> or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor OverallCardinality(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong>? action)
	{
		Instance.OverallCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the cardinality that is observed for fields over the whole
	/// time period that the job analyzes data. To produce a good answer, values
	/// must be provided for fields referenced in the <c>by_field_name</c>,
	/// <c>over_field_name</c> and <c>partition_field_name</c> of any detectors. Providing
	/// values for other fields has no effect on the estimation. It can be
	/// omitted from the request if no detectors have a <c>by_field_name</c>,
	/// <c>over_field_name</c> or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor OverallCardinality<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<T>>? action)
	{
		Instance.OverallCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor AddOverallCardinality(Elastic.Clients.Elasticsearch.Field key, long value)
	{
		Instance.OverallCardinality ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, long>();
		Instance.OverallCardinality.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor AddOverallCardinality<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, long value)
	{
		Instance.OverallCardinality ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, long>();
		Instance.OverallCardinality.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Estimate job model memory usage.
/// </para>
/// <para>
/// Make an estimation of the memory usage for an anomaly detection job model.
/// The estimate is based on analysis configuration details for the job and cardinality
/// estimates for the fields it references.
/// </para>
/// </summary>
public readonly partial struct EstimateModelMemoryRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EstimateModelMemoryRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest instance)
	{
		Instance = instance;
	}

	public EstimateModelMemoryRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest(Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// For a list of the properties that you can specify in the
	/// <c>analysis_config</c> component of the body of this API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> AnalysisConfig(Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfig? value)
	{
		Instance.AnalysisConfig = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// For a list of the properties that you can specify in the
	/// <c>analysis_config</c> component of the body of this API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> AnalysisConfig(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument>> action)
	{
		Instance.AnalysisConfig = Elastic.Clients.Elasticsearch.MachineLearning.AnalysisConfigDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the highest cardinality in a single bucket that is observed
	/// for influencer fields over the time period that the job analyzes data.
	/// To produce a good answer, values must be provided for all influencer
	/// fields. Providing values for fields that are not listed as <c>influencers</c>
	/// has no effect on the estimation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> MaxBucketCardinality(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, long>? value)
	{
		Instance.MaxBucketCardinality = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the highest cardinality in a single bucket that is observed
	/// for influencer fields over the time period that the job analyzes data.
	/// To produce a good answer, values must be provided for all influencer
	/// fields. Providing values for fields that are not listed as <c>influencers</c>
	/// has no effect on the estimation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> MaxBucketCardinality()
	{
		Instance.MaxBucketCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the highest cardinality in a single bucket that is observed
	/// for influencer fields over the time period that the job analyzes data.
	/// To produce a good answer, values must be provided for all influencer
	/// fields. Providing values for fields that are not listed as <c>influencers</c>
	/// has no effect on the estimation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> MaxBucketCardinality(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<TDocument>>? action)
	{
		Instance.MaxBucketCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> AddMaxBucketCardinality(Elastic.Clients.Elasticsearch.Field key, long value)
	{
		Instance.MaxBucketCardinality ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, long>();
		Instance.MaxBucketCardinality.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> AddMaxBucketCardinality(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, long value)
	{
		Instance.MaxBucketCardinality ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, long>();
		Instance.MaxBucketCardinality.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the cardinality that is observed for fields over the whole
	/// time period that the job analyzes data. To produce a good answer, values
	/// must be provided for fields referenced in the <c>by_field_name</c>,
	/// <c>over_field_name</c> and <c>partition_field_name</c> of any detectors. Providing
	/// values for other fields has no effect on the estimation. It can be
	/// omitted from the request if no detectors have a <c>by_field_name</c>,
	/// <c>over_field_name</c> or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> OverallCardinality(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, long>? value)
	{
		Instance.OverallCardinality = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the cardinality that is observed for fields over the whole
	/// time period that the job analyzes data. To produce a good answer, values
	/// must be provided for fields referenced in the <c>by_field_name</c>,
	/// <c>over_field_name</c> and <c>partition_field_name</c> of any detectors. Providing
	/// values for other fields has no effect on the estimation. It can be
	/// omitted from the request if no detectors have a <c>by_field_name</c>,
	/// <c>over_field_name</c> or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> OverallCardinality()
	{
		Instance.OverallCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Estimates of the cardinality that is observed for fields over the whole
	/// time period that the job analyzes data. To produce a good answer, values
	/// must be provided for fields referenced in the <c>by_field_name</c>,
	/// <c>over_field_name</c> and <c>partition_field_name</c> of any detectors. Providing
	/// values for other fields has no effect on the estimation. It can be
	/// omitted from the request if no detectors have a <c>by_field_name</c>,
	/// <c>over_field_name</c> or <c>partition_field_name</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> OverallCardinality(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<TDocument>>? action)
	{
		Instance.OverallCardinality = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldLong<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> AddOverallCardinality(Elastic.Clients.Elasticsearch.Field key, long value)
	{
		Instance.OverallCardinality ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, long>();
		Instance.OverallCardinality.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> AddOverallCardinality(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, long value)
	{
		Instance.OverallCardinality ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, long>();
		Instance.OverallCardinality.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.EstimateModelMemoryRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}