// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class DeleteJobRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies whether annotations that have been added by the
	/// user should be deleted along with any auto-generated annotations when the job is
	/// reset.
	/// </para>
	/// </summary>
	public bool? DeleteUserAnnotations { get => Q<bool?>("delete_user_annotations"); set => Q("delete_user_annotations", value); }

	/// <summary>
	/// <para>
	/// Use to forcefully delete an opened job; this method is quicker than
	/// closing and deleting the job.
	/// </para>
	/// </summary>
	public bool? Force { get => Q<bool?>("force"); set => Q("force", value); }

	/// <summary>
	/// <para>
	/// Specifies whether the request should return immediately or wait until the
	/// job deletion completes.
	/// </para>
	/// </summary>
	public bool? WaitForCompletion { get => Q<bool?>("wait_for_completion"); set => Q("wait_for_completion", value); }
}

/// <summary>
/// <para>
/// Delete an anomaly detection job.
/// </para>
/// <para>
/// All job configuration, model state and results are deleted.
/// It is not currently possible to delete multiple jobs using wildcards or a
/// comma separated list. If you delete a job that has a datafeed, the request
/// first tries to delete the datafeed. This behavior is equivalent to calling
/// the delete datafeed API with the same timeout and force parameters as the
/// delete job request.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DeleteJobRequestConverter))]
public sealed partial class DeleteJobRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteJobRequest(Elastic.Clients.Elasticsearch.Id jobId) : base(r => r.Required("job_id", jobId))
	{
	}
#if NET7_0_OR_GREATER
	public DeleteJobRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DeleteJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningDeleteJob;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => false;

	internal override string OperationName => "ml.delete_job";

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id JobId { get => P<Elastic.Clients.Elasticsearch.Id>("job_id"); set => PR("job_id", value); }

	/// <summary>
	/// <para>
	/// Specifies whether annotations that have been added by the
	/// user should be deleted along with any auto-generated annotations when the job is
	/// reset.
	/// </para>
	/// </summary>
	public bool? DeleteUserAnnotations { get => Q<bool?>("delete_user_annotations"); set => Q("delete_user_annotations", value); }

	/// <summary>
	/// <para>
	/// Use to forcefully delete an opened job; this method is quicker than
	/// closing and deleting the job.
	/// </para>
	/// </summary>
	public bool? Force { get => Q<bool?>("force"); set => Q("force", value); }

	/// <summary>
	/// <para>
	/// Specifies whether the request should return immediately or wait until the
	/// job deletion completes.
	/// </para>
	/// </summary>
	public bool? WaitForCompletion { get => Q<bool?>("wait_for_completion"); set => Q("wait_for_completion", value); }
}

/// <summary>
/// <para>
/// Delete an anomaly detection job.
/// </para>
/// <para>
/// All job configuration, model state and results are deleted.
/// It is not currently possible to delete multiple jobs using wildcards or a
/// comma separated list. If you delete a job that has a datafeed, the request
/// first tries to delete the datafeed. This behavior is equivalent to calling
/// the delete datafeed API with the same timeout and force parameters as the
/// delete job request.
/// </para>
/// </summary>
public readonly partial struct DeleteJobRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteJobRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest instance)
	{
		Instance = instance;
	}

	public DeleteJobRequestDescriptor(Elastic.Clients.Elasticsearch.Id jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest(jobId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DeleteJobRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest(Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for the anomaly detection job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether annotations that have been added by the
	/// user should be deleted along with any auto-generated annotations when the job is
	/// reset.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor DeleteUserAnnotations(bool? value = true)
	{
		Instance.DeleteUserAnnotations = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use to forcefully delete an opened job; this method is quicker than
	/// closing and deleting the job.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor Force(bool? value = true)
	{
		Instance.Force = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the request should return immediately or wait until the
	/// job deletion completes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor WaitForCompletion(bool? value = true)
	{
		Instance.WaitForCompletion = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteJobRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}