// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class DeleteExpiredDataRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Delete expired ML data.
/// </para>
/// <para>
/// Delete all job results, model snapshots and forecast data that have exceeded
/// their retention days period. Machine learning state documents that are not
/// associated with any job are also deleted.
/// You can limit the request to a single or set of anomaly detection jobs by
/// using a job identifier, a group name, a comma-separated list of jobs, or a
/// wildcard expression. You can delete expired data for all anomaly detection
/// jobs by using <c>_all</c>, by specifying <c>*</c> as the <c>&lt;job_id></c>, or by omitting the
/// <c>&lt;job_id></c>.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DeleteExpiredDataRequestConverter))]
public sealed partial class DeleteExpiredDataRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestParameters>
{
	public DeleteExpiredDataRequest(Elastic.Clients.Elasticsearch.Id? jobId) : base(r => r.Optional("job_id", jobId))
	{
	}
#if NET7_0_OR_GREATER
	public DeleteExpiredDataRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DeleteExpiredDataRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DeleteExpiredDataRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningDeleteExpiredData;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ml.delete_expired_data";

	/// <summary>
	/// <para>
	/// Identifier for an anomaly detection job. It can be a job identifier, a
	/// group name, or a wildcard expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? JobId { get => P<Elastic.Clients.Elasticsearch.Id?>("job_id"); set => PO("job_id", value); }

	/// <summary>
	/// <para>
	/// The desired requests per second for the deletion processes. The default
	/// behavior is no throttling.
	/// </para>
	/// </summary>
	public float? RequestsPerSecond { get; set; }

	/// <summary>
	/// <para>
	/// How long can the underlying delete processes run until they are canceled.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get; set; }
}

/// <summary>
/// <para>
/// Delete expired ML data.
/// </para>
/// <para>
/// Delete all job results, model snapshots and forecast data that have exceeded
/// their retention days period. Machine learning state documents that are not
/// associated with any job are also deleted.
/// You can limit the request to a single or set of anomaly detection jobs by
/// using a job identifier, a group name, a comma-separated list of jobs, or a
/// wildcard expression. You can delete expired data for all anomaly detection
/// jobs by using <c>_all</c>, by specifying <c>*</c> as the <c>&lt;job_id></c>, or by omitting the
/// <c>&lt;job_id></c>.
/// </para>
/// </summary>
public readonly partial struct DeleteExpiredDataRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteExpiredDataRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest instance)
	{
		Instance = instance;
	}

	public DeleteExpiredDataRequestDescriptor(Elastic.Clients.Elasticsearch.Id? jobId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest(jobId);
	}

	public DeleteExpiredDataRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest(Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Identifier for an anomaly detection job. It can be a job identifier, a
	/// group name, or a wildcard expression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor JobId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.JobId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The desired requests per second for the deletion processes. The default
	/// behavior is no throttling.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor RequestsPerSecond(float? value)
	{
		Instance.RequestsPerSecond = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How long can the underlying delete processes run until they are canceled.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteExpiredDataRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}