// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class DeleteDatafeedRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Use to forcefully delete a started datafeed; this method is quicker than
	/// stopping and deleting the datafeed.
	/// </para>
	/// </summary>
	public bool? Force { get => Q<bool?>("force"); set => Q("force", value); }
}

/// <summary>
/// <para>
/// Delete a datafeed.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DeleteDatafeedRequestConverter))]
public sealed partial class DeleteDatafeedRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteDatafeedRequest(Elastic.Clients.Elasticsearch.Id datafeedId) : base(r => r.Required("datafeed_id", datafeedId))
	{
	}
#if NET7_0_OR_GREATER
	public DeleteDatafeedRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DeleteDatafeedRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningDeleteDatafeed;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => false;

	internal override string OperationName => "ml.delete_datafeed";

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the datafeed. This
	/// identifier can contain lowercase alphanumeric characters (a-z and 0-9),
	/// hyphens, and underscores. It must start and end with alphanumeric
	/// characters.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id DatafeedId { get => P<Elastic.Clients.Elasticsearch.Id>("datafeed_id"); set => PR("datafeed_id", value); }

	/// <summary>
	/// <para>
	/// Use to forcefully delete a started datafeed; this method is quicker than
	/// stopping and deleting the datafeed.
	/// </para>
	/// </summary>
	public bool? Force { get => Q<bool?>("force"); set => Q("force", value); }
}

/// <summary>
/// <para>
/// Delete a datafeed.
/// </para>
/// </summary>
public readonly partial struct DeleteDatafeedRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest instance)
	{
		Instance = instance;
	}

	public DeleteDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.Id datafeedId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest(datafeedId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DeleteDatafeedRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest(Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A numerical character string that uniquely identifies the datafeed. This
	/// identifier can contain lowercase alphanumeric characters (a-z and 0-9),
	/// hyphens, and underscores. It must start and end with alphanumeric
	/// characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor DatafeedId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.DatafeedId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Use to forcefully delete a started datafeed; this method is quicker than
	/// stopping and deleting the datafeed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor Force(bool? value = true)
	{
		Instance.Force = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteDatafeedRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}