// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.MachineLearning;

public sealed partial class DeleteCalendarEventRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Delete events from a calendar.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.MachineLearning.Json.DeleteCalendarEventRequestConverter))]
public sealed partial class DeleteCalendarEventRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteCalendarEventRequest(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Id eventId) : base(r => r.Required("calendar_id", calendarId).Required("event_id", eventId))
	{
	}
#if NET7_0_OR_GREATER
	public DeleteCalendarEventRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DeleteCalendarEventRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.MachineLearningDeleteCalendarEvent;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => false;

	internal override string OperationName => "ml.delete_calendar_event";

	/// <summary>
	/// <para>
	/// A string that uniquely identifies a calendar.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id CalendarId { get => P<Elastic.Clients.Elasticsearch.Id>("calendar_id"); set => PR("calendar_id", value); }

	/// <summary>
	/// <para>
	/// Identifier for the scheduled event.
	/// You can obtain this identifier by using the get calendar events API.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id EventId { get => P<Elastic.Clients.Elasticsearch.Id>("event_id"); set => PR("event_id", value); }
}

/// <summary>
/// <para>
/// Delete events from a calendar.
/// </para>
/// </summary>
public readonly partial struct DeleteCalendarEventRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteCalendarEventRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest instance)
	{
		Instance = instance;
	}

	public DeleteCalendarEventRequestDescriptor(Elastic.Clients.Elasticsearch.Id calendarId, Elastic.Clients.Elasticsearch.Id eventId)
	{
		Instance = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest(calendarId, eventId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DeleteCalendarEventRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor(Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest instance) => new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest(Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A string that uniquely identifies a calendar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor CalendarId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.CalendarId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifier for the scheduled event.
	/// You can obtain this identifier by using the get calendar events API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor EventId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.EventId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest Build(System.Action<Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor(new Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.MachineLearning.DeleteCalendarEventRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}