// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.LicenseManagement;

public sealed partial class PostStartTrialRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// whether the user has acknowledged acknowledge messages (default: false)
	/// </para>
	/// </summary>
	public bool? Acknowledge { get => Q<bool?>("acknowledge"); set => Q("acknowledge", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The type of trial license to generate (default: "trial")
	/// </para>
	/// </summary>
	public string? Type { get => Q<string?>("type"); set => Q("type", value); }
}

/// <summary>
/// <para>
/// Start a trial.
/// Start a 30-day trial, which gives access to all subscription features.
/// </para>
/// <para>
/// NOTE: You are allowed to start a trial only if your cluster has not already activated a trial for the current major product version.
/// For example, if you have already activated a trial for v8.0, you cannot start a new trial until v9.0. You can, however, request an extended trial at https://www.elastic.co/trialextension.
/// </para>
/// <para>
/// To check the status of your trial, use the get trial status API.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.LicenseManagement.Json.PostStartTrialRequestConverter))]
public sealed partial class PostStartTrialRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestParameters>
{
#if NET7_0_OR_GREATER
	public PostStartTrialRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PostStartTrialRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PostStartTrialRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.LicenseManagementPostStartTrial;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "license.post_start_trial";

	/// <summary>
	/// <para>
	/// whether the user has acknowledged acknowledge messages (default: false)
	/// </para>
	/// </summary>
	public bool? Acknowledge { get => Q<bool?>("acknowledge"); set => Q("acknowledge", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The type of trial license to generate (default: "trial")
	/// </para>
	/// </summary>
	public string? Type { get => Q<string?>("type"); set => Q("type", value); }
}

/// <summary>
/// <para>
/// Start a trial.
/// Start a 30-day trial, which gives access to all subscription features.
/// </para>
/// <para>
/// NOTE: You are allowed to start a trial only if your cluster has not already activated a trial for the current major product version.
/// For example, if you have already activated a trial for v8.0, you cannot start a new trial until v9.0. You can, however, request an extended trial at https://www.elastic.co/trialextension.
/// </para>
/// <para>
/// To check the status of your trial, use the get trial status API.
/// </para>
/// </summary>
public readonly partial struct PostStartTrialRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PostStartTrialRequestDescriptor(Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequest instance)
	{
		Instance = instance;
	}

	public PostStartTrialRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor(Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequest instance) => new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequest(Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// whether the user has acknowledged acknowledge messages (default: false)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor Acknowledge(bool? value = true)
	{
		Instance.Acknowledge = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of trial license to generate (default: "trial")
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor Type(string? value)
	{
		Instance.Type = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequest Build(System.Action<Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor(new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartTrialRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}