// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.LicenseManagement;

public sealed partial class PostStartBasicRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// whether the user has acknowledged acknowledge messages (default: false)
	/// </para>
	/// </summary>
	public bool? Acknowledge { get => Q<bool?>("acknowledge"); set => Q("acknowledge", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Start a basic license.
/// </para>
/// <para>
/// Start an indefinite basic license, which gives access to all the basic features.
/// </para>
/// <para>
/// NOTE: In order to start a basic license, you must not currently have a basic license.
/// </para>
/// <para>
/// If the basic license does not support all of the features that are available with your current license, however, you are notified in the response.
/// You must then re-submit the API request with the <c>acknowledge</c> parameter set to <c>true</c>.
/// </para>
/// <para>
/// To check the status of your basic license, use the get basic license API.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.LicenseManagement.Json.PostStartBasicRequestConverter))]
public sealed partial class PostStartBasicRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestParameters>
{
#if NET7_0_OR_GREATER
	public PostStartBasicRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PostStartBasicRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PostStartBasicRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.LicenseManagementPostStartBasic;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "license.post_start_basic";

	/// <summary>
	/// <para>
	/// whether the user has acknowledged acknowledge messages (default: false)
	/// </para>
	/// </summary>
	public bool? Acknowledge { get => Q<bool?>("acknowledge"); set => Q("acknowledge", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Start a basic license.
/// </para>
/// <para>
/// Start an indefinite basic license, which gives access to all the basic features.
/// </para>
/// <para>
/// NOTE: In order to start a basic license, you must not currently have a basic license.
/// </para>
/// <para>
/// If the basic license does not support all of the features that are available with your current license, however, you are notified in the response.
/// You must then re-submit the API request with the <c>acknowledge</c> parameter set to <c>true</c>.
/// </para>
/// <para>
/// To check the status of your basic license, use the get basic license API.
/// </para>
/// </summary>
public readonly partial struct PostStartBasicRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PostStartBasicRequestDescriptor(Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequest instance)
	{
		Instance = instance;
	}

	public PostStartBasicRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor(Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequest instance) => new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequest(Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// whether the user has acknowledged acknowledge messages (default: false)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor Acknowledge(bool? value = true)
	{
		Instance.Acknowledge = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequest Build(System.Action<Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor(new Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostStartBasicRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}