// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.LicenseManagement;

public sealed partial class PostRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies whether you acknowledge the license changes.
	/// </para>
	/// </summary>
	public bool? Acknowledge { get => Q<bool?>("acknowledge"); set => Q("acknowledge", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Update the license.
/// </para>
/// <para>
/// You can update your license at runtime without shutting down your nodes.
/// License updates take effect immediately.
/// If the license you are installing does not support all of the features that were available with your previous license, however, you are notified in the response.
/// You must then re-submit the API request with the acknowledge parameter set to true.
/// </para>
/// <para>
/// NOTE: If Elasticsearch security features are enabled and you are installing a gold or higher license, you must enable TLS on the transport networking layer before you install the license.
/// If the operator privileges feature is enabled, only operator users can use this API.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.LicenseManagement.Json.PostRequestConverter))]
public sealed partial class PostRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestParameters>
{
#if NET7_0_OR_GREATER
	public PostRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PostRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PostRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.LicenseManagementPost;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "license.post";

	/// <summary>
	/// <para>
	/// Specifies whether you acknowledge the license changes.
	/// </para>
	/// </summary>
	public bool? Acknowledge { get => Q<bool?>("acknowledge"); set => Q("acknowledge", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
	public Elastic.Clients.Elasticsearch.LicenseManagement.License? License { get; set; }

	/// <summary>
	/// <para>
	/// A sequence of one or more JSON documents containing the license information.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.LicenseManagement.License>? Licenses { get; set; }
}

/// <summary>
/// <para>
/// Update the license.
/// </para>
/// <para>
/// You can update your license at runtime without shutting down your nodes.
/// License updates take effect immediately.
/// If the license you are installing does not support all of the features that were available with your previous license, however, you are notified in the response.
/// You must then re-submit the API request with the acknowledge parameter set to true.
/// </para>
/// <para>
/// NOTE: If Elasticsearch security features are enabled and you are installing a gold or higher license, you must enable TLS on the transport networking layer before you install the license.
/// If the operator privileges feature is enabled, only operator users can use this API.
/// </para>
/// </summary>
public readonly partial struct PostRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.LicenseManagement.PostRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PostRequestDescriptor(Elastic.Clients.Elasticsearch.LicenseManagement.PostRequest instance)
	{
		Instance = instance;
	}

	public PostRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.LicenseManagement.PostRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor(Elastic.Clients.Elasticsearch.LicenseManagement.PostRequest instance) => new Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.LicenseManagement.PostRequest(Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Specifies whether you acknowledge the license changes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor Acknowledge(bool? value = true)
	{
		Instance.Acknowledge = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor License(Elastic.Clients.Elasticsearch.LicenseManagement.License? value)
	{
		Instance.License = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor License(System.Action<Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor> action)
	{
		Instance.License = Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A sequence of one or more JSON documents containing the license information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor Licenses(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.LicenseManagement.License>? value)
	{
		Instance.Licenses = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A sequence of one or more JSON documents containing the license information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor Licenses(params Elastic.Clients.Elasticsearch.LicenseManagement.License[] values)
	{
		Instance.Licenses = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A sequence of one or more JSON documents containing the license information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor Licenses(params System.Action<Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.LicenseManagement.License>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.LicenseManagement.LicenseDescriptor.Build(action));
		}

		Instance.Licenses = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.LicenseManagement.PostRequest Build(System.Action<Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.LicenseManagement.PostRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor(new Elastic.Clients.Elasticsearch.LicenseManagement.PostRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.LicenseManagement.PostRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}