// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

public sealed partial class SimulateRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes output data for each processor in the executed pipeline.
	/// </para>
	/// </summary>
	public bool? Verbose { get => Q<bool?>("verbose"); set => Q("verbose", value); }
}

/// <summary>
/// <para>
/// Simulate a pipeline.
/// </para>
/// <para>
/// Run an ingest pipeline against a set of provided documents.
/// You can either specify an existing pipeline to use with the provided documents or supply a pipeline definition in the body of the request.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.SimulateRequestConverter))]
public sealed partial class SimulateRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Ingest.SimulateRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateRequest(Elastic.Clients.Elasticsearch.Id? id) : base(r => r.Optional("id", id))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateRequest(Elastic.Clients.Elasticsearch.Id? id, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> docs) : base(r => r.Optional("id", id))
	{
		Docs = docs;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateRequest(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> docs)
	{
		Docs = docs;
	}
#if NET7_0_OR_GREATER
	public SimulateRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SimulateRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SimulateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IngestSimulate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ingest.simulate";

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify a <c>pipeline</c> in the request body, this parameter is required.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? Id { get => P<Elastic.Clients.Elasticsearch.Id?>("id"); set => PO("id", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes output data for each processor in the executed pipeline.
	/// </para>
	/// </summary>
	public bool? Verbose { get => Q<bool?>("verbose"); set => Q("verbose", value); }

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> Docs { get; set; }

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.Pipeline? Pipeline { get; set; }
}

/// <summary>
/// <para>
/// Simulate a pipeline.
/// </para>
/// <para>
/// Run an ingest pipeline against a set of provided documents.
/// You can either specify an existing pipeline to use with the provided documents or supply a pipeline definition in the body of the request.
/// </para>
/// </summary>
public readonly partial struct SimulateRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.SimulateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateRequestDescriptor(Elastic.Clients.Elasticsearch.Ingest.SimulateRequest instance)
	{
		Instance = instance;
	}

	public SimulateRequestDescriptor(Elastic.Clients.Elasticsearch.Id? id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Ingest.SimulateRequest(id);
#pragma warning restore CS0618
	}

	public SimulateRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.SimulateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor(Elastic.Clients.Elasticsearch.Ingest.SimulateRequest instance) => new Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.SimulateRequest(Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify a <c>pipeline</c> in the request body, this parameter is required.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes output data for each processor in the executed pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Verbose(bool? value = true)
	{
		Instance.Verbose = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Docs(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> value)
	{
		Instance.Docs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Docs(params Elastic.Clients.Elasticsearch.Ingest.Document[] values)
	{
		Instance.Docs = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Docs(params System.Action<Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Document>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor.Build(action));
		}

		Instance.Docs = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Pipeline(Elastic.Clients.Elasticsearch.Ingest.Pipeline? value)
	{
		Instance.Pipeline = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Pipeline()
	{
		Instance.Pipeline = Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Pipeline(System.Action<Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor>? action)
	{
		Instance.Pipeline = Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Pipeline<T>(System.Action<Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<T>>? action)
	{
		Instance.Pipeline = Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.SimulateRequest Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor(new Elastic.Clients.Elasticsearch.Ingest.SimulateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Simulate a pipeline.
/// </para>
/// <para>
/// Run an ingest pipeline against a set of provided documents.
/// You can either specify an existing pipeline to use with the provided documents or supply a pipeline definition in the body of the request.
/// </para>
/// </summary>
public readonly partial struct SimulateRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Ingest.SimulateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateRequestDescriptor(Elastic.Clients.Elasticsearch.Ingest.SimulateRequest instance)
	{
		Instance = instance;
	}

	public SimulateRequestDescriptor(Elastic.Clients.Elasticsearch.Id? id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Ingest.SimulateRequest(id);
#pragma warning restore CS0618
	}

	public SimulateRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.SimulateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Ingest.SimulateRequest instance) => new Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.SimulateRequest(Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify a <c>pipeline</c> in the request body, this parameter is required.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes output data for each processor in the executed pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Verbose(bool? value = true)
	{
		Instance.Verbose = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Docs(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> value)
	{
		Instance.Docs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Docs(params Elastic.Clients.Elasticsearch.Ingest.Document[] values)
	{
		Instance.Docs = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Docs(params System.Action<Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Document>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor.Build(action));
		}

		Instance.Docs = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Pipeline(Elastic.Clients.Elasticsearch.Ingest.Pipeline? value)
	{
		Instance.Pipeline = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Pipeline()
	{
		Instance.Pipeline = Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The pipeline to test.
	/// If you don't specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Pipeline(System.Action<Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<TDocument>>? action)
	{
		Instance.Pipeline = Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.SimulateRequest Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Ingest.SimulateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.SimulateRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}