// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Ingest;

public sealed partial class ProcessorGrokRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Run a grok processor.
/// Extract structured fields out of a single text field within a document.
/// You must choose which field to extract matched fields from, as well as the grok pattern you expect will match.
/// A grok pattern is like a regular expression that supports aliased expressions that can be reused.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Ingest.Json.ProcessorGrokRequestConverter))]
public sealed partial class ProcessorGrokRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestParameters>
{
#if NET7_0_OR_GREATER
	public ProcessorGrokRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ProcessorGrokRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ProcessorGrokRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IngestProcessorGrok;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "ingest.processor_grok";
}

/// <summary>
/// <para>
/// Run a grok processor.
/// Extract structured fields out of a single text field within a document.
/// You must choose which field to extract matched fields from, as well as the grok pattern you expect will match.
/// A grok pattern is like a regular expression that supports aliased expressions that can be reused.
/// </para>
/// </summary>
public readonly partial struct ProcessorGrokRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ProcessorGrokRequestDescriptor(Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequest instance)
	{
		Instance = instance;
	}

	public ProcessorGrokRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor(Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequest instance) => new Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequest(Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor descriptor) => descriptor.Instance;

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequest Build(System.Action<Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor(new Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Ingest.ProcessorGrokRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}